/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class RefreshBuildFilesAction
extends Action
implements IUpdate {
    private final AntView fView;

    public RefreshBuildFilesAction(AntView view) {
        super(AntViewActionMessages.RefreshBuildFilesAction_Refresh_Buildfiles_1, AntUIImages.getImageDescriptor("org.eclipse.ant.ui.IMG_REFRESH"));
        this.setToolTipText(AntViewActionMessages.RefreshBuildFilesAction_Refresh_Buildfiles_1);
        this.fView = view;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ant.ui.refresh_buildfile_action_context");
    }

    public void run() {
        Iterator<AntProjectNode> iter;
        Set<AntProjectNode> projects = this.getSelectedProjects();
        if (projects.isEmpty()) {
            AntProjectNode[] antProjectNodeArray = this.fView.getProjects();
            int n = antProjectNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AntProjectNode antproject = antProjectNodeArray[n2];
                projects.add(antproject);
                ++n2;
            }
        }
        if (!(iter = projects.iterator()).hasNext()) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                monitor.beginTask(AntViewActionMessages.RefreshBuildFilesAction_Refreshing_buildfiles_3, projects.size());
                while (iter.hasNext()) {
                    AntProjectNodeProxy project = (AntProjectNodeProxy)iter.next();
                    monitor.subTask(MessageFormat.format(AntViewActionMessages.RefreshBuildFilesAction_Refreshing__0__4, project.getBuildFileName()));
                    project.parseBuildFile(true);
                    monitor.worked(1);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.fView.getViewer().refresh();
    }

    private Set<AntProjectNode> getSelectedProjects() {
        IStructuredSelection selection = (IStructuredSelection)this.fView.getViewer().getSelection();
        HashSet<AntProjectNode> set = new HashSet<AntProjectNode>();
        for (Object data : selection) {
            if (data instanceof AntProjectNode) {
                set.add((AntProjectNode)data);
                continue;
            }
            if (!(data instanceof AntTargetNode)) continue;
            set.add(((AntTargetNode)data).getProjectNode());
        }
        return set;
    }

    public void update() {
        this.setEnabled(this.fView.getProjects().length > 0);
    }
}

