/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.build.JARFileFilter;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.JarSelectionValidator;
import org.eclipse.pde.internal.ui.editor.plugin.NewRuntimeLibraryDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class LibrarySection
extends TableSection
implements IBuildPropertiesConstants {
    private static final int NEW_INDEX = 0;
    private static final int ADD_INDEX = 1;
    private static final int REMOVE_INDEX = 2;
    private static final int UP_INDEX = 3;
    private static final int DOWN_INDEX = 4;
    private Action fRenameAction;
    private Action fRemoveAction;
    private Action fNewAction;
    private TableViewer fLibraryTable;

    public LibrarySection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.NewManifestEditor_LibrarySection_new, PDEUIMessages.NewManifestEditor_LibrarySection_add, PDEUIMessages.NewManifestEditor_LibrarySection_remove, PDEUIMessages.ManifestEditor_LibrarySection_up, PDEUIMessages.ManifestEditor_LibrarySection_down});
    }

    private String getSectionDescription() {
        IPluginModelBase model = this.getModel();
        if (this.isBundle()) {
            return model != null && model.isFragmentModel() ? PDEUIMessages.ClasspathSection_fragment : PDEUIMessages.ClasspathSection_plugin;
        }
        return model != null && model.isFragmentModel() ? PDEUIMessages.ManifestEditor_LibrarySection_fdesc : PDEUIMessages.ManifestEditor_LibrarySection_desc;
    }

    protected boolean isBundle() {
        return this.getBundleContext() != null;
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ManifestEditor_LibrarySection_title);
        section.setDescription(this.getSectionDescription());
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.isEditable());
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fLibraryTable = tablePart.getTableViewer();
        this.fLibraryTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.fLibraryTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        this.updateButtons();
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)container);
        IPluginModelBase model = this.getModel();
        if (model != null) {
            this.fLibraryTable.setInput((Object)model.getPluginBase());
            model.addModelChangedListener((IModelChangedListener)this);
        }
    }

    private void updateButtons() {
        Table table = this.fLibraryTable.getTable();
        boolean hasSelection = table.getSelection().length > 0;
        boolean singleSelection = table.getSelection().length == 1;
        int count = table.getItemCount();
        int index = table.getSelectionIndex();
        boolean canMoveUp = singleSelection && index > 0;
        boolean canMoveDown = singleSelection && index < count - 1;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(1, this.isEditable());
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(2, this.isEditable() && hasSelection);
        tablePart.setButtonEnabled(3, this.isEditable() && canMoveUp);
        tablePart.setButtonEnabled(4, this.isEditable() && canMoveDown);
    }

    private void makeActions() {
        this.fNewAction = new Action(PDEUIMessages.ManifestEditor_LibrarySection_newLibrary){

            public void run() {
                LibrarySection.this.handleNew();
            }
        };
        this.fNewAction.setEnabled(this.isEditable());
        this.fRenameAction = new Action(PDEUIMessages.EditableTablePart_renameAction){

            public void run() {
                LibrarySection.this.getRenameAction().run();
            }
        };
        this.fRenameAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(PDEUIMessages.NewManifestEditor_LibrarySection_remove){

            public void run() {
                LibrarySection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        IBaseModel model = this.getPage().getModel();
        if (model != null && model.isEditable()) {
            this.updateButtons();
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleAdd();
                break;
            }
            case 2: {
                this.handleRemove();
                break;
            }
            case 3: {
                this.handleUp();
                break;
            }
            case 4: {
                this.handleDown();
            }
        }
    }

    public void dispose() {
        IPluginModelBase model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginLibrary) {
            this.fLibraryTable.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fNewAction);
        if (!this.fLibraryTable.getStructuredSelection().isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fRenameAction);
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, this.isBundle());
    }

    /*
     * WARNING - void declaration
     */
    private void handleRemove() {
        int[] indices;
        Object[] selection = this.fLibraryTable.getStructuredSelection().toArray();
        int index = this.fLibraryTable.getTable().getSelectionIndex();
        Object object = indices = this.fLibraryTable.getTable().getSelectionIndices();
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int indice = object[n2];
            if (indice < index) {
                index = indice;
            }
            ++n2;
        }
        String[] remove = new String[selection.length];
        int i = 0;
        while (i < selection.length) {
            if (selection[i] != null && (object = (Object)selection[i]) instanceof IPluginLibrary) {
                void ep;
                IPluginLibrary cfr_ignored_0 = (IPluginLibrary)object;
                IPluginLibrary cfr_ignored_1 = (IPluginLibrary)object;
                IPluginBase plugin = ep.getPluginBase();
                try {
                    plugin.remove((IPluginLibrary)ep);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                remove[i] = ep.getName();
            }
            ++i;
        }
        this.updateBuildProperties(remove, new String[remove.length], true);
        this.updateJavaClasspathLibs(remove, new String[remove.length]);
        int itemCount = this.fLibraryTable.getTable().getItemCount();
        if (itemCount > 0) {
            if (index >= itemCount) {
                index = itemCount - 1;
            }
            this.fLibraryTable.getTable().setSelection(index);
            this.fLibraryTable.getTable().setFocus();
        }
        this.updateButtons();
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index != table.getItemCount() - 1) {
            this.swap(index, index + 1);
        }
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index >= 1) {
            this.swap(index, index - 1);
        }
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        IPluginLibrary l1 = (IPluginLibrary)table.getItem(index1).getData();
        IPluginLibrary l2 = (IPluginLibrary)table.getItem(index2).getData();
        try {
            IPluginModelBase model = this.getModel();
            IPluginBase pluginBase = model.getPluginBase();
            pluginBase.swap(l1, l2);
            this.refresh();
            table.setSelection(index2);
            table.setFocus();
            this.updateButtons();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleNew() {
        IPluginModelBase model = this.getModel();
        NewRuntimeLibraryDialog dialog = new NewRuntimeLibraryDialog(this.getPage().getSite().getShell(), model.getPluginBase().getLibraries());
        dialog.create();
        dialog.getShell().setText(PDEUIMessages.ManifestEditor_LibrarySection_newLibraryEntry);
        SWTUtil.setDialogSize((Dialog)dialog, 250, 175);
        if (dialog.open() == 0) {
            String libName = dialog.getLibraryName();
            if (libName == null || libName.length() == 0) {
                return;
            }
            try {
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                library.setName(libName);
                library.setExported(true);
                model.getPluginBase().add(library);
                this.checkSourceRootEntry();
                this.updateBuildProperties(new String[1], new String[]{library.getName()}, true);
                this.fLibraryTable.setSelection((ISelection)new StructuredSelection((Object)library));
                this.fLibraryTable.getTable().setFocus();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void checkSourceRootEntry() {
        IBuildEntry[] entires;
        IPluginLibrary[] libraries;
        IPluginModelBase pluginModel = this.getModel();
        IPluginLibrary[] iPluginLibraryArray = libraries = pluginModel.getPluginBase().getLibraries();
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library = iPluginLibraryArray[n2];
            if (library.getName().equals(".")) {
                return;
            }
            ++n2;
        }
        IBuildModel model = this.getBuildModel();
        if (model == null) {
            return;
        }
        IBuildEntry[] iBuildEntryArray = entires = model.getBuild().getBuildEntries();
        int n3 = entires.length;
        int n4 = 0;
        while (n4 < n3) {
            IBuildEntry entry = iBuildEntryArray[n4];
            if (entry.getName().equals("source..")) {
                IPluginLibrary library = pluginModel.getPluginFactory().createLibrary();
                try {
                    library.setName(".");
                    pluginModel.getPluginBase().add(library);
                }
                catch (CoreException coreException) {}
            }
            ++n4;
        }
    }

    private IBuildModel getBuildModel() {
        IFormPage page = this.getPage().getEditor().findPage("build-context");
        IBaseModel model = null;
        if (page instanceof BuildSourcePage) {
            model = ((BuildSourcePage)page).getInputContext().getModel();
        }
        if (model != null && model instanceof IBuildModel) {
            return (IBuildModel)model;
        }
        return null;
    }

    private void configureSourceBuildEntry(IBuildModel bmodel, String oldPath, String newPath) throws CoreException {
        IBuild build = bmodel.getBuild();
        IBuildEntry entry = build.getEntry("source." + (oldPath != null ? oldPath : newPath));
        try {
            if (newPath != null) {
                if (entry == null) {
                    IClasspathEntry[] entries;
                    IProject project = ((IModel)this.getPage().getModel()).getUnderlyingResource().getProject();
                    IJavaProject jproject = JavaCore.create((IProject)project);
                    ArrayList<String> tokens = new ArrayList<String>();
                    IClasspathEntry[] iClasspathEntryArray = entries = jproject.getRawClasspath();
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry cpe = iClasspathEntryArray[n2];
                        if (cpe.getEntryKind() == 3) {
                            tokens.add(cpe.getPath().removeFirstSegments(1).addTrailingSeparator().toString());
                        }
                        ++n2;
                    }
                    if (tokens.isEmpty()) {
                        return;
                    }
                    entry = bmodel.getFactory().createEntry("source." + newPath);
                    int i = 0;
                    while (i < tokens.size()) {
                        entry.addToken((String)tokens.get(i));
                        ++i;
                    }
                    build.add(entry);
                } else {
                    entry.setName("source." + newPath);
                }
            } else if (entry != null) {
                build.remove(entry);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void handleAdd() {
        final boolean[] updateClasspath = new boolean[]{true};
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider()){

            protected Control createDialogArea(Composite parent) {
                Composite comp = (Composite)super.createDialogArea(parent);
                Button button = new Button(comp, 32);
                button.setText(PDEUIMessages.LibrarySection_addDialogButton);
                button.setSelection(updateClasspath[0]);
                button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    boolean bl = button.getSelection();
                }));
                4.applyDialogFont((Control)button);
                return comp;
            }
        };
        Class[] acceptedClasses = new Class[]{IFile.class};
        dialog.setValidator((ISelectionStatusValidator)new LibrarySelectionValidator(acceptedClasses, true));
        dialog.setTitle(PDEUIMessages.BuildEditor_ClasspathSection_jarsTitle);
        dialog.setMessage(PDEUIMessages.ClasspathSection_jarsMessage);
        IPluginLibrary[] libraries = this.getModel().getPluginBase().getLibraries();
        IProject project = ((IModel)this.getPage().getModel()).getUnderlyingResource().getProject();
        HashSet<IPath> set = new HashSet<IPath>();
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library = iPluginLibraryArray[n2];
            IPath bundlePath = IPath.fromOSString((String)ClasspathUtilCore.expandLibraryName((String)library.getName()));
            IPath buildPath = PDEProject.getBundleRoot((IProject)project).getProjectRelativePath().append(bundlePath);
            set.add(buildPath);
            ++n2;
        }
        dialog.addFilter((ViewerFilter)new LibraryFilter(set));
        dialog.setInput((Object)project);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.add_library");
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            String[] bundlePaths = new String[elements.length];
            String[] buildPaths = new String[elements.length];
            IPluginModelBase model = this.getModel();
            ArrayList<IPluginLibrary> list = new ArrayList<IPluginLibrary>();
            int i = 0;
            while (i < elements.length) {
                IResource elem = (IResource)elements[i];
                IContainer bundleRoot = PDEProject.getBundleRoot((IProject)project);
                IPath rootPath = bundleRoot.getFullPath();
                IPath bundlePath = elem.getFullPath().makeRelativeTo(rootPath);
                IPath buildPath = elem.getProjectRelativePath();
                if (elem instanceof IFolder) {
                    bundlePath = bundlePath.addTrailingSeparator();
                    buildPath = buildPath.addTrailingSeparator();
                }
                bundlePaths[i] = bundlePath.toString();
                buildPaths[i] = buildPath.toString();
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                try {
                    library.setName(bundlePaths[i]);
                    library.setExported(true);
                    model.getPluginBase().add(library);
                    list.add(library);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                ++i;
            }
            this.checkSourceRootEntry();
            this.updateBuildProperties(new String[bundlePaths.length], bundlePaths, false);
            if (updateClasspath[0]) {
                this.updateJavaClasspathLibs(new String[buildPaths.length], buildPaths);
            }
            this.fLibraryTable.setSelection((ISelection)new StructuredSelection(list.toArray()));
            this.fLibraryTable.getTable().setFocus();
        }
    }

    private void updateBuildProperties(String[] oldPaths, String[] newPaths, boolean modifySourceEntry) {
        IBuildModel bmodel = this.getBuildModel();
        if (bmodel == null) {
            return;
        }
        IBuild build = bmodel.getBuild();
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            entry = bmodel.getFactory().createEntry("bin.includes");
        }
        try {
            if (oldPaths[0] == null) {
                String[] stringArray = newPaths;
                int n = newPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String newPath = stringArray[n2];
                    if (newPath != null) {
                        entry.addToken(newPath);
                        if (modifySourceEntry) {
                            this.configureSourceBuildEntry(bmodel, null, newPath);
                        }
                    }
                    ++n2;
                }
            } else if (newPaths[0] == null) {
                String[] stringArray = oldPaths;
                int n = oldPaths.length;
                int n3 = 0;
                while (n3 < n) {
                    String oldPath = stringArray[n3];
                    if (oldPath != null) {
                        entry.removeToken(oldPath);
                        if (modifySourceEntry) {
                            this.configureSourceBuildEntry(bmodel, oldPath, null);
                        }
                    }
                    ++n3;
                }
                if (entry.getTokens().length == 0) {
                    build.remove(entry);
                }
            } else {
                int i = 0;
                while (i < oldPaths.length) {
                    if (newPaths[i] != null && oldPaths[i] != null) {
                        entry.renameToken(oldPaths[i], newPaths[i]);
                        if (modifySourceEntry) {
                            this.configureSourceBuildEntry(bmodel, oldPaths[i], newPaths[i]);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void updateJavaClasspathLibs(String[] oldPaths, String[] newPaths) {
        IProject project = ((IModel)this.getPage().getModel()).getUnderlyingResource().getProject();
        IJavaProject jproject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] entries = jproject.getRawClasspath();
            ArrayList<IClasspathEntry> toBeAdded = new ArrayList<IClasspathEntry>();
            int index = -1;
            int i = 0;
            while (i < entries.length) {
                block13: {
                    if (entries[i].getEntryKind() == 1) {
                        if (index == -1) {
                            index = i;
                        }
                        IPath path = entries[i].getPath().removeFirstSegments(1).removeTrailingSeparator();
                        int j = 0;
                        while (j < oldPaths.length) {
                            if (oldPaths[j] == null || !path.equals((Object)IPath.fromOSString((String)oldPaths[j]).removeTrailingSeparator())) {
                                ++j;
                                continue;
                            }
                            break block13;
                        }
                    } else if (entries[i].getEntryKind() == 5 && index == -1) {
                        index = i;
                    }
                    toBeAdded.add(entries[i]);
                }
                ++i;
            }
            if (index == -1) {
                index = entries.length;
            }
            String[] stringArray = newPaths;
            int n = newPaths.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry;
                String newPath = stringArray[n2];
                if (newPath != null && !toBeAdded.contains(entry = JavaCore.newLibraryEntry((IPath)project.getFullPath().append(newPath), null, null, (boolean)true))) {
                    toBeAdded.add(index++, entry);
                }
                ++n2;
            }
            if (toBeAdded.size() == entries.length) {
                return;
            }
            IClasspathEntry[] updated = toBeAdded.toArray(new IClasspathEntry[toBeAdded.size()]);
            jproject.setRawClasspath(updated, null);
        }
        catch (JavaModelException javaModelException) {}
    }

    public void refresh() {
        if (this.fLibraryTable.getControl().isDisposed()) {
            return;
        }
        this.fLibraryTable.setSelection(null);
        this.fLibraryTable.refresh();
        super.refresh();
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginLibrary) {
            if (event.getChangeType() == 1) {
                this.fLibraryTable.refresh();
            } else if (event.getChangeType() == 2) {
                this.fLibraryTable.remove(changeObject);
            } else {
                this.fLibraryTable.update(changeObject, null);
            }
        } else if (changeObject.equals(this.fLibraryTable.getInput())) {
            this.markStale();
        } else if (changeObject instanceof IPluginElement && ((IPluginElement)changeObject).getParent() instanceof IPluginLibrary) {
            this.fLibraryTable.update((Object)((IPluginElement)changeObject).getParent(), null);
        }
    }

    @Override
    public void setFocus() {
        this.fLibraryTable.getTable().setFocus();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        IPluginModelBase model = this.getModel();
        IPluginBase plugin = model.getPluginBase();
        try {
            Object[] objectArray = sourceObjects;
            int n = sourceObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object sourceObject = objectArray[n2];
                Object object = sourceObject;
                if (object instanceof PluginLibrary) {
                    void library;
                    PluginLibrary cfr_ignored_0 = (PluginLibrary)object;
                    PluginLibrary cfr_ignored_1 = (PluginLibrary)object;
                    library.reconnect((ISharedPluginModel)model, (IPluginObject)plugin);
                    plugin.add((IPluginLibrary)library);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        Set<IPath> librarySet = null;
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library;
            Object sourceObject = objectArray[n2];
            if (!(sourceObject instanceof IPluginLibrary)) {
                return false;
            }
            if (librarySet == null) {
                librarySet = this.createPluginLibrarySet();
            }
            if (librarySet.contains(IPath.fromOSString((String)ClasspathUtilCore.expandLibraryName((String)(library = (IPluginLibrary)sourceObject).getName())))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Set<IPath> createPluginLibrarySet() {
        IPluginLibrary[] libraries = this.getModel().getPluginBase().getLibraries();
        HashSet<IPath> librarySet = new HashSet<IPath>();
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library = iPluginLibraryArray[n2];
            librarySet.add(IPath.fromOSString((String)ClasspathUtilCore.expandLibraryName((String)library.getName())));
            ++n2;
        }
        return librarySet;
    }

    @Override
    protected void entryModified(Object entry, String value) {
        try {
            IPluginModelBase model = this.getModel();
            IProject project = model.getUnderlyingResource().getProject();
            IPluginLibrary library = (IPluginLibrary)entry;
            model.getPluginBase().remove(library);
            String[] oldValue = new String[]{library.getName()};
            String[] newValue = new String[]{value};
            library.setName(value);
            boolean memberExists = project.findMember(value) != null;
            this.updateBuildProperties(oldValue, newValue, !memberExists);
            this.updateJavaClasspathLibs(oldValue, memberExists ? newValue : new String[1]);
            model.getPluginBase().add(library);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private IPluginModelBase getModel() {
        IBaseModel iBaseModel = this.getPage().getModel();
        if (iBaseModel instanceof IPluginModelBase) {
            void base;
            IPluginModelBase iPluginModelBase = (IPluginModelBase)iBaseModel;
            IPluginModelBase cfr_ignored_0 = (IPluginModelBase)iBaseModel;
            return base;
        }
        return null;
    }

    @Override
    protected boolean isDragAndDropEnabled() {
        return true;
    }

    @Override
    public boolean canDragMove(Object[] sourceObjects) {
        return this.validateDragMoveSanity(sourceObjects);
    }

    private boolean validateDragMoveSanity(Object[] sourceObjects) {
        if (sourceObjects == null) {
            return false;
        }
        if (sourceObjects.length != 1) {
            return false;
        }
        return sourceObjects[0] instanceof IPluginLibrary;
    }

    @Override
    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            return false;
        }
        IPluginLibrary sourcePluginLibrary = (IPluginLibrary)sourceObjects[0];
        IPluginLibrary targetPluginLibrary = (IPluginLibrary)targetObject;
        if (!this.validateDropMoveModel(sourcePluginLibrary, targetPluginLibrary)) {
            return false;
        }
        BundlePluginBase bundlePluginBase = (BundlePluginBase)this.getModel().getPluginBase();
        if (targetLocation == 1) {
            IPluginLibrary previousLibrary = bundlePluginBase.getPreviousLibrary(targetPluginLibrary);
            return !sourcePluginLibrary.equals(previousLibrary);
        }
        if (targetLocation == 2) {
            IPluginLibrary nextLibrary = bundlePluginBase.getNextLibrary(targetPluginLibrary);
            return !sourcePluginLibrary.equals(nextLibrary);
        }
        if (targetLocation == 3) {
            return false;
        }
        return false;
    }

    private boolean validateDropMoveSanity(Object targetObject, Object[] sourceObjects) {
        if (!(targetObject instanceof IPluginLibrary)) {
            return false;
        }
        return this.validateDragMoveSanity(sourceObjects);
    }

    private boolean validateDropMoveModel(IPluginLibrary sourcePluginLibrary, IPluginLibrary targetPluginLibrary) {
        ISharedPluginModel targetModel;
        ISharedPluginModel sourceModel = sourcePluginLibrary.getModel();
        if (!sourceModel.equals(targetModel = targetPluginLibrary.getModel())) {
            return false;
        }
        return this.getModel().getPluginBase() instanceof BundlePluginBase;
    }

    @Override
    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            Display.getDefault().beep();
            return;
        }
        IPluginLibrary sourcePluginLibrary = (IPluginLibrary)sourceObjects[0];
        IPluginLibrary targetPluginLibrary = (IPluginLibrary)targetObject;
        if (targetLocation == 1 || targetLocation == 2) {
            this.doDropMove(sourcePluginLibrary, targetPluginLibrary, targetLocation);
        }
    }

    private void doDropMove(IPluginLibrary sourcePluginLibrary, IPluginLibrary targetPluginLibrary, int targetLocation) {
        this.doDragRemove();
        IPluginModelBase model = this.getModel();
        BundlePluginBase bundlePluginBase = (BundlePluginBase)model.getPluginBase();
        int index = bundlePluginBase.getIndexOf(targetPluginLibrary);
        if (index == -1) {
            return;
        }
        int targetIndex = index;
        if (targetLocation == 2) {
            ++targetIndex;
        }
        if (!(sourcePluginLibrary instanceof PluginLibrary)) {
            return;
        }
        ((PluginLibrary)sourcePluginLibrary).reconnect((ISharedPluginModel)model, (IPluginObject)bundlePluginBase);
        try {
            bundlePluginBase.add(sourcePluginLibrary, targetIndex);
        }
        catch (CoreException coreException) {}
    }

    private void doDragRemove() {
        BundlePluginBase bundlePluginBase = (BundlePluginBase)this.getModel().getPluginBase();
        Object[] sourceObjects = this.getDragSourceObjects();
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return;
        }
        IPluginLibrary sourcePluginLibrary = (IPluginLibrary)sourceObjects[0];
        try {
            bundlePluginBase.remove(sourcePluginLibrary);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    class LibraryFilter
    extends JARFileFilter {
        public LibraryFilter(Set<IPath> set) {
            super(set);
        }

        @Override
        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IFolder) {
                return this.isPathValid(((IFolder)element).getProjectRelativePath());
            }
            if (element instanceof IFile) {
                return this.isFileValid(((IFile)element).getProjectRelativePath());
            }
            return false;
        }
    }

    class LibrarySelectionValidator
    extends JarSelectionValidator {
        public LibrarySelectionValidator(Class<?>[] acceptedTypes, boolean allowMultipleSelection) {
            super(acceptedTypes, allowMultipleSelection);
        }

        @Override
        public boolean isValid(Object element) {
            return element instanceof IFolder ? true : super.isValid(element);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return LibrarySection.this.getModel().getPluginBase().getLibraries();
        }
    }
}

