/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseManifestOperation
implements IRunnableWithProgress {
    private final Shell fShell;
    protected String fPluginId;

    public BaseManifestOperation(Shell shell, String pluginId) {
        this.fShell = shell;
        this.fPluginId = pluginId;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected IFile getFile() {
        IPluginModelBase model = PluginRegistry.findModel((String)this.fPluginId);
        IProject project = model.getUnderlyingResource().getProject();
        return model instanceof IFragmentModel ? PDEProject.getFragmentXml((IProject)project) : PDEProject.getPluginXml((IProject)project);
    }

    protected IPluginModelBase getModel(IFile file) {
        if ("plugin.xml".equals(file.getName())) {
            return new WorkspacePluginModel(file, false);
        }
        return new WorkspaceFragmentModel(file, false);
    }

    protected void updateSingleton(IProgressMonitor monitor) throws CoreException {
        IPluginModelBase plugin = PluginRegistry.findModel((String)this.fPluginId);
        if (plugin instanceof IBundlePluginModel) {
            IFile file = (IFile)plugin.getUnderlyingResource();
            IStatus status = PDEPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
            if (!status.isOK()) {
                throw new CoreException(Status.error((String)NLS.bind((String)PDEUIMessages.ProductDefinitionOperation_readOnly, (Object)this.fPluginId), null));
            }
            ModelModification mod = new ModelModification(file){

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    IManifestHeader header;
                    void modelBase;
                    IBaseModel iBaseModel = model;
                    if (!(iBaseModel instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase iBundlePluginModelBase = (IBundlePluginModelBase)iBaseModel;
                    IBundlePluginModelBase cfr_ignored_0 = (IBundlePluginModelBase)iBaseModel;
                    IBundle bundle = modelBase.getBundleModel().getBundle();
                    IManifestHeader iManifestHeader = header = bundle.getManifestHeader("Bundle-SymbolicName");
                    if (iManifestHeader instanceof BundleSymbolicNameHeader) {
                        void symbolic;
                        BundleSymbolicNameHeader bundleSymbolicNameHeader = (BundleSymbolicNameHeader)iManifestHeader;
                        BundleSymbolicNameHeader cfr_ignored_1 = (BundleSymbolicNameHeader)iManifestHeader;
                        if (!symbolic.isSingleton()) {
                            symbolic.setSingleton(true);
                        }
                    }
                }
            };
            PDEModelUtility.modifyModel(mod, null);
        }
    }
}

