/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix;

import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCreateModuleElementResolution
implements IMarkerResolution2 {
    public void run(IMarker marker) {
        int newOffset;
        AcceleoEditor editor;
        IDocument document;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof AcceleoEditor && (document = (editor = (AcceleoEditor)window.getActivePage().getActiveEditor()).getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null && editor.getContent() != null && (newOffset = this.createModuleElement(document, editor.getContent(), marker)) > -1) {
            editor.selectAndReveal(newOffset, 0);
        }
    }

    protected int createModuleElement(IDocument document, AcceleoSourceContent content, IMarker marker) {
        int result;
        block10: {
            String[] paramNames;
            String[] paramTypes;
            String templateName;
            int newOffset;
            String lineDelimiter;
            int posBegin;
            block11: {
                result = -1;
                String message = marker.getAttribute("message", "");
                posBegin = marker.getAttribute("charStart", -1);
                int posEnd = marker.getAttribute("charEnd", posBegin);
                lineDelimiter = "\n";
                if (document.getNumberOfLines() > 0) {
                    lineDelimiter = document.getLineDelimiter(0);
                }
                if (message == null || posBegin <= -1 || posEnd <= -1) break block10;
                newOffset = this.newOffset(document, content, posBegin);
                Pattern messagePattern = Pattern.compile("Cannot find operation \\(([^()]+)\\(([^()]+)\\)\\) for the type \\(([^()]+)\\)");
                Matcher matcher = messagePattern.matcher(message);
                if (matcher.find()) {
                    templateName = matcher.group(1).trim();
                    paramTypes = this.splitParamTypes(String.valueOf(matcher.group(3)) + ',' + matcher.group(2));
                    paramNames = this.computeParamNames(paramTypes);
                    break block11;
                }
                return -1;
            }
            try {
                if (paramTypes.length == 0) {
                    CSTNode currentNode = content.getCSTNode(posBegin, posBegin);
                    paramTypes = new String[]{this.getCurrentVariableTypeName(currentNode, "Type")};
                }
                StringBuilder newText = new StringBuilder();
                if (newOffset > 0) {
                    newText.append(lineDelimiter);
                    if (!lineDelimiter.equals(document.get(newOffset - 1, 1))) {
                        newText.append(lineDelimiter);
                    }
                }
                int selectAndReveal = newOffset + newText.length();
                int newTextLength = newText.length();
                this.append(newText, lineDelimiter, templateName, paramTypes, paramNames);
                if (newText.length() > newTextLength) {
                    document.replace(newOffset, 0, newText.toString());
                    marker.delete();
                    result = selectAndReveal;
                }
            }
            catch (BadLocationException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return result;
    }

    private String[] splitParamTypes(String parameters) {
        String[] types = parameters.split(",");
        int i = 0;
        while (i < types.length) {
            types[i] = types[i].trim();
            ++i;
        }
        return types;
    }

    private String[] computeParamNames(String[] paramTypes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(paramTypes.length);
        String[] stringArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String candidate = String.valueOf('a') + type;
            if (names.contains(candidate)) {
                int count = 1;
                while (names.contains(String.valueOf(candidate) + count)) {
                    ++count;
                }
                candidate = String.valueOf(candidate) + count;
            }
            names.add(candidate);
            ++n2;
        }
        return names.toArray(new String[names.size()]);
    }

    private String getCurrentVariableTypeName(CSTNode currentNode, String defaultType) {
        Variable eContext = null;
        if (currentNode instanceof Template) {
            Template iTemplate = (Template)currentNode;
            if (iTemplate.getParameter().size() > 0) {
                eContext = (Variable)iTemplate.getParameter().get(0);
            }
        } else if (currentNode instanceof Query) {
            Query iQuery = (Query)currentNode;
            if (iQuery.getParameter().size() > 0) {
                eContext = (Variable)iQuery.getParameter().get(0);
            }
        } else if (currentNode instanceof Macro) {
            Macro iMacro = (Macro)currentNode;
            if (iMacro.getParameter().size() > 0) {
                eContext = (Variable)iMacro.getParameter().get(0);
            }
        } else if (currentNode instanceof ForBlock) {
            eContext = ((ForBlock)currentNode).getLoopVariable();
        } else if (currentNode instanceof LetBlock) {
            eContext = ((LetBlock)currentNode).getLetVariable();
        }
        String res = eContext != null && eContext.getType() != null ? eContext.getType() : (currentNode != null && currentNode.eContainer() instanceof CSTNode ? this.getCurrentVariableTypeName((CSTNode)currentNode.eContainer(), defaultType) : defaultType);
        return res;
    }

    protected int newOffset(IDocument document, AcceleoSourceContent content, int offset) {
        return document.getLength();
    }

    protected abstract void append(StringBuilder var1, String var2, String var3, String[] var4, String[] var5);
}

