/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.StringBufferToStringBuilderFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class StringBufferToStringBuilderCleanUpCore
extends AbstractCleanUp {
    public StringBufferToStringBuilderCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public StringBufferToStringBuilderCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.stringbuffer_to_stringbuilder");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.stringbuffer_to_stringbuilder")) {
            return null;
        }
        return StringBufferToStringBuilderFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.stringbuilder_for_local_vars"));
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.stringbuffer_to_stringbuilder")) {
            if (this.isEnabled("cleanup.stringbuilder_for_local_vars")) {
                return new String[]{MultiFixMessages.StringBuilderForLocalVarsOnlyCleanUp_description};
            }
            return new String[]{MultiFixMessages.StringBufferToStringBuilderCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.stringbuffer_to_stringbuilder") && !this.isEnabled("cleanup.stringbuilder_for_local_vars")) {
            bld.append("public void foo(StringBuilder x) {\n");
        } else {
            bld.append("public void foo(StringBuffer x) {\n");
        }
        if (this.isEnabled("cleanup.stringbuffer_to_stringbuilder")) {
            bld.append("    StringBuilder y = new StringBuilder();\n");
        } else {
            bld.append("    StringBuffer y = new StringBuffer();\n");
        }
        bld.append("    y.append(\"a string\");\n");
        bld.append("    System.out.println(y.toString());\n");
        bld.append("}\n");
        return bld.toString();
    }
}

