/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.backend;

import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.Log;
import org.eclipse.fx.drift.internal.SYS;
import org.eclipse.fx.drift.internal.backend.Image;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.common.MainMemoryImageData;
import org.eclipse.fx.drift.internal.prism.Prism;

public class MainMemoryImage
implements Image {
    public static final Image.ImageType TYPE = new Image.ImageType("MainMemory");
    private int number;
    private Vec2i size;
    private MainMemoryImageData data;
    int glTexture;
    long memPointer;
    int memSize;

    public MainMemoryImage(int number, Vec2i size) {
        this.number = number;
        this.size = size;
    }

    @Override
    public ImageData getData() {
        return this.data;
    }

    @Override
    public void allocate() {
        this.glTexture = GL.glGenTexture();
        GL.glBindTexture(3553, this.glTexture);
        GL.glTexImage2D(3553, 0, 6408, this.size.x, this.size.y, 0, 32993, 5121, 0L);
        GL.glBindTexture(3553, 0);
        this.memSize = this.size.x * this.size.y * 4;
        this.memPointer = SYS.malloc(this.memSize);
        Log.debug("*allocated " + this.number + " 0x" + Long.toHexString(this.memPointer) + "(" + this.size.x + "x" + this.size.y + ": " + this.memSize + "B)");
        this.data = new MainMemoryImageData(this.number, this.size, this.memPointer, this.memSize);
    }

    @Override
    public void release() {
        GL.glDeleteTexture(this.glTexture);
        Log.debug("*release " + this.glTexture + " 0x" + Long.toHexString(this.memPointer));
        SYS.free(this.memPointer);
    }

    @Override
    public void onAcquire() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPresent() {
        MainMemoryImageData mainMemoryImageData = this.data;
        synchronized (mainMemoryImageData) {
            this.downloadToMemorySimple(this.glTexture, this.memPointer);
        }
    }

    private void downloadToMemorySimple(int tex, long pPixels) {
        int format = Prism.isD3D() ? 32993 : 6408;
        GL.glBindTexture(3553, this.glTexture);
        GL.glGetTexImage(3553, 0, format, 33639, this.memPointer);
        GL.glBindTexture(3553, 0);
        Log.debug("*downloaded " + tex + " => 0x" + Long.toHexString(this.memPointer));
    }

    private void downloadToMemoryBuf(int tex, int size, long pPixels) {
        int buf = GL.glGenBuffer();
        GL.glBindBuffer(35051, buf);
        GL.glBufferData(35051, size, 0L, 35045);
        int format = 6408;
        GL.glBindTexture(3553, tex);
        GL.glGetTexImage(3553, 0, format, 33639, 0L);
        GL.glBindTexture(3553, 0);
        long glBuf = GL.glMapBuffer(35051, 35000);
        SYS.memcpy(pPixels, glBuf, size);
        GL.glUnmapBuffer(35051);
        GL.glBindBuffer(35051, 0);
        GL.glDeleteBuffer(buf);
    }

    @Override
    public int getGLTexture() {
        return this.glTexture;
    }
}

