/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.frontend;

import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import org.eclipse.fx.drift.internal.Log;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.frontend.FxImage;
import org.eclipse.fx.drift.internal.prism.Prism;

public abstract class AFxImage<D extends ImageData>
implements FxImage<D> {
    private Texture texture;
    protected final D data;

    public AFxImage(D data) {
        this.data = data;
    }

    @Override
    public D getData() {
        return this.data;
    }

    @Override
    public void allocate(ResourceFactory rf) throws Exception {
        this.texture = rf.createTexture(PixelFormat.BYTE_BGRA_PRE, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_NOT_NEEDED, ((ImageData)this.data).size.x, ((ImageData)this.data).size.y);
        this.texture.makePermanent();
        Log.debug("Texture Created! " + this + " / " + this.texture + " / " + Prism.getTextureHandle(this.texture));
    }

    @Override
    public void release() {
        this.texture.dispose();
    }

    @Override
    public void update() {
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }
}

