/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.jni.win32;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.fx.drift.internal.Log;

public enum ErrorCode {
    ERROR_INVALID_HANDLE(6),
    ERROR_INVALID_DATA(13),
    ERROR_OPEN_FAILED(110),
    ERROR_NOT_SUPPORTED(50),
    ERROR_NOT_LOCKED(158),
    ERROR_LOCK_FAILED(167),
    ERROR_BUSY(170);

    public int value;

    private ErrorCode(int value) {
        this.value = value;
    }

    public static ErrorCode fromValue(int value) {
        Optional<ErrorCode> code = Stream.of(ErrorCode.values()).filter(v -> v.value == value).findFirst();
        if (code.isPresent()) {
            return code.get();
        }
        Log.error("Error code not yet supported: " + Integer.toHexString(value));
        Thread.dumpStack();
        return null;
    }
}

