/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation.pagetransition.animation;

import javafx.animation.Animation;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.PathTransitionBuilder;
import javafx.animation.ScaleTransitionBuilder;
import javafx.animation.SequentialTransitionBuilder;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import org.eclipse.fx.ui.animation.pagetransition.CenterSwitchAnimation;

public class PageChangeAnimation
extends CenterSwitchAnimation {
    @Override
    protected Animation createAndPrepareAnimation(Node curNode, Node newNode) {
        Bounds b = curNode.getBoundsInLocal();
        double cX = b.getMinX() + b.getWidth() / 2.0;
        double cY = b.getMinY() + b.getHeight() / 2.0;
        double val = 200.0;
        CubicCurve cIn = new CubicCurve(cX - val, cY, cX - val, cY - val, cX, cY - val, cX, cY);
        CubicCurve cOut = new CubicCurve(cX, cY, cX, cY + val, cX + val, cY + val, cX + val, cY + 0.0);
        PathTransitionBuilder moveOut = PathTransitionBuilder.create().duration(new Duration(1000.0)).node(curNode).path((Shape)cOut);
        PathTransitionBuilder moveIn = PathTransitionBuilder.create().duration(new Duration(1000.0)).node(newNode).path((Shape)cIn);
        ScaleTransitionBuilder zoomOut = (ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(new Duration(1000.0)).toX(0.2).toY(0.2).interpolator(Interpolator.EASE_BOTH);
        ScaleTransitionBuilder zoomIn = (ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(new Duration(1000.0)).fromX(0.2).fromY(0.2).toX(0.7).toY(0.7).interpolator(Interpolator.EASE_BOTH);
        ParallelTransition main = ParallelTransitionBuilder.create().children(new Animation[]{zoomOut.node(curNode).build(), zoomIn.node(newNode).build(), moveIn.build(), moveOut.build(), FadeTransitionBuilder.create().node(curNode).duration(new Duration(1000.0)).fromValue(1.0).toValue(0.0).build(), moveOut.build(), FadeTransitionBuilder.create().node(newNode).duration(new Duration(1000.0)).fromValue(0.0).toValue(1.0).build()}).build();
        ScaleTransitionBuilder zoomOut1 = (ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(new Duration(300.0)).toX(0.7).toY(0.7).interpolator(Interpolator.EASE_BOTH);
        ScaleTransitionBuilder zoomIn1 = (ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(new Duration(300.0)).toX(1.0).toY(1.0).interpolator(Interpolator.EASE_BOTH);
        return SequentialTransitionBuilder.create().children(new Animation[]{ParallelTransitionBuilder.create().children(new Animation[]{zoomOut1.node(curNode).build(), zoomOut1.node(newNode).build()}).build(), main, ParallelTransitionBuilder.create().children(new Animation[]{zoomIn1.node(curNode).build(), zoomIn1.node(newNode).build()}).build()}).build();
    }

    @Override
    protected void resetProperties(Node curNode, Node newNode) {
        newNode.setTranslateZ(0.0);
        curNode.setTranslateZ(0.0);
        newNode.setRotate(0.0);
        curNode.setRotate(0.0);
        curNode.setScaleX(1.0);
        curNode.setScaleY(1.0);
        curNode.setOpacity(1.0);
        curNode.setTranslateX(0.0);
        curNode.setTranslateY(0.0);
        newNode.setScaleX(1.0);
        newNode.setScaleY(1.0);
        newNode.setOpacity(1.0);
        newNode.setTranslateX(0.0);
        newNode.setTranslateY(0.0);
    }
}

