/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation.pagetransition.animation;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.ScaleTransitionBuilder;
import javafx.animation.SequentialTransitionBuilder;
import javafx.animation.TranslateTransitionBuilder;
import javafx.scene.Node;
import javafx.util.Duration;
import org.eclipse.fx.ui.animation.pagetransition.CenterSwitchAnimation;

public class ZoomSlideAnimation
extends CenterSwitchAnimation {
    @Override
    protected Animation createAndPrepareAnimation(Node curNode, Node newNode) {
        double deltaX = -curNode.getBoundsInLocal().getWidth();
        newNode.setTranslateX(-deltaX);
        TranslateTransitionBuilder slide = ((TranslateTransitionBuilder)TranslateTransitionBuilder.create().interpolator(Interpolator.EASE_BOTH)).byX(deltaX).duration(new Duration(300.0));
        ScaleTransitionBuilder zoomOut = (ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(new Duration(300.0)).toX(0.7).toY(0.7).interpolator(Interpolator.EASE_BOTH);
        ScaleTransitionBuilder zoomIn = (ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(new Duration(300.0)).toX(1.0).toY(1.0).interpolator(Interpolator.EASE_BOTH);
        return SequentialTransitionBuilder.create().children(new Animation[]{ParallelTransitionBuilder.create().children(new Animation[]{zoomOut.node(curNode).build(), zoomOut.node(newNode).build()}).build(), ParallelTransitionBuilder.create().children(new Animation[]{slide.node(curNode).build(), slide.node(newNode).build()}).build(), ParallelTransitionBuilder.create().children(new Animation[]{zoomIn.node(curNode).build(), zoomIn.node(newNode).build()}).build()}).build();
    }

    @Override
    protected void resetProperties(Node curNode, Node newNode) {
        newNode.setTranslateX(0.0);
        newNode.setScaleX(1.0);
        newNode.setScaleY(1.0);
        curNode.setTranslateX(0.0);
        curNode.setScaleX(1.0);
        curNode.setScaleY(1.0);
        curNode.setEffect(null);
        newNode.setEffect(null);
    }
}

