/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.keybindings.e4.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.ui.keybindings.Binding;
import org.eclipse.fx.ui.keybindings.KeyLookup;
import org.eclipse.fx.ui.keybindings.ParseException;
import org.eclipse.fx.ui.keybindings.TriggerSequence;
import org.eclipse.fx.ui.keybindings.e4.EBindingService;
import org.eclipse.fx.ui.keybindings.e4.internal.BindingTable;
import org.eclipse.fx.ui.keybindings.e4.internal.BindingTableManager;
import org.eclipse.fx.ui.keybindings.e4.internal.ContextSet;
import org.eclipse.fx.ui.keybindings.service.BindingFactory;

public class BindingServiceImpl
implements EBindingService {
    static final String ACTIVE_CONTEXTS = "activeContexts";
    static final String USER_TYPE = "user";
    @Inject
    private IEclipseContext context;
    @Inject
    private BindingTableManager manager;
    @Inject
    private ContextManager contextManager;
    @Inject
    private KeyLookup keylookup;
    @Inject
    private BindingFactory factory;
    private ContextSet contextSet = ContextSet.EMPTY;

    @Override
    public Binding createBinding(TriggerSequence sequence, ParameterizedCommand command, String contextId, Map<String, String> attributes) {
        String schemeId = "org.eclipse.ui.defaultAcceleratorConfiguration";
        if (sequence != null && !sequence.isEmpty() && contextId != null) {
            String tmp;
            if (attributes != null && (tmp = attributes.get("schemeId")) != null && tmp.length() > 0) {
                schemeId = tmp;
            }
            return this.factory.createKeyBinding(sequence, command, schemeId, contextId);
        }
        return null;
    }

    @Override
    public void activateBinding(Binding binding) {
        String contextId = binding.getContextId();
        BindingTable table = this.manager.getTable(contextId);
        if (table == null) {
            return;
        }
        table.addBinding(binding);
    }

    @Override
    public void deactivateBinding(Binding binding) {
        String contextId = binding.getContextId();
        BindingTable table = this.manager.getTable(contextId);
        if (table == null) {
            return;
        }
        table.removeBinding(binding);
    }

    @Override
    public TriggerSequence createSequence(String sequence) {
        try {
            return this.factory.getKeySequenceInstance(this.keylookup, sequence);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Collection<Binding> getConflictsFor(TriggerSequence sequence) {
        return this.manager.getConflictsFor(this.contextSet, sequence);
    }

    @Override
    public Collection<Binding> getAllConflicts() {
        return this.manager.getAllConflicts();
    }

    @Override
    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.manager.getPerfectMatch(this.contextSet, trigger);
    }

    @Override
    public boolean isPartialMatch(TriggerSequence keySequence) {
        return this.manager.isPartialMatch(this.contextSet, keySequence);
    }

    @Override
    public TriggerSequence getBestSequenceFor(ParameterizedCommand command) {
        Binding binding = this.manager.getBestSequenceFor(this.contextSet, command);
        return binding == null ? null : binding.getTriggerSequence();
    }

    @Override
    public Collection<TriggerSequence> getSequencesFor(ParameterizedCommand command) {
        Collection<Binding> bindings = this.manager.getSequencesFor(this.contextSet, command);
        ArrayList<TriggerSequence> sequences = new ArrayList<TriggerSequence>(bindings.size());
        for (Binding binding : bindings) {
            sequences.add(binding.getTriggerSequence());
        }
        return sequences;
    }

    @Override
    public Collection<Binding> getBindingsFor(ParameterizedCommand command) {
        return this.manager.getBindingsFor(this.contextSet, command);
    }

    @Override
    public boolean isPerfectMatch(TriggerSequence sequence) {
        return this.getPerfectMatch(sequence) != null;
    }

    @Override
    public Collection<Binding> getPartialMatches(TriggerSequence sequence) {
        return this.manager.getPartialMatches(this.contextSet, sequence);
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    @Inject
    public void setContextIds(@Named(value="activeContexts") @Optional Set<String> set) {
        if (set == null || set.isEmpty() || this.contextManager == null) {
            this.contextSet = ContextSet.EMPTY;
            if (this.contextManager != null) {
                this.contextManager.setActiveContextIds(Collections.EMPTY_SET);
            }
            return;
        }
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (String id : set) {
            contexts.add(this.contextManager.getContext(id));
        }
        this.contextSet = this.manager.createContextSet(contexts);
        this.contextManager.setActiveContextIds(set);
    }

    @Override
    public Collection<Binding> getActiveBindings() {
        return this.manager.getActiveBindings();
    }
}

