/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;

public class GridData {
    public ObjectProperty<Alignment> verticalAlignment = new SimpleObjectProperty((Object)this, "verticalAlignment", (Object)Alignment.CENTER);
    public ObjectProperty<Alignment> horizontalAlignment = new SimpleObjectProperty((Object)this, "horizontalAlignment", (Object)Alignment.BEGINNING);
    public IntegerProperty widthHint = new SimpleIntegerProperty((Object)this, "widthHint", -1);
    public IntegerProperty heightHint = new SimpleIntegerProperty((Object)this, "heightHint", -1);
    public IntegerProperty horizontalIndent = new SimpleIntegerProperty((Object)this, "horizontalIndent");
    public IntegerProperty verticalIndent = new SimpleIntegerProperty((Object)this, "verticalIndent");
    public IntegerProperty horizontalSpan = new SimpleIntegerProperty((Object)this, "horizontalSpan", 1);
    public IntegerProperty verticalSpan = new SimpleIntegerProperty((Object)this, "verticalSpan", 1);
    public BooleanProperty grabExcessHorizontalSpace = new SimpleBooleanProperty((Object)this, "grabExcessHorizontalSpace", false);
    public BooleanProperty grabExcessVerticalSpace = new SimpleBooleanProperty((Object)this, "grabExcessVerticalSpace", false);
    public IntegerProperty minimumWidth = new SimpleIntegerProperty((Object)this, "minimumWidth", 0);
    public IntegerProperty minimumHeight = new SimpleIntegerProperty((Object)this, "minimumHeight", 0);
    public BooleanProperty exclude = new SimpleBooleanProperty((Object)this, "exclude", false);
    public static final int VERTICAL_ALIGN_BEGINNING = 2;
    public static final int VERTICAL_ALIGN_CENTER = 4;
    public static final int VERTICAL_ALIGN_END = 8;
    public static final int VERTICAL_ALIGN_FILL = 16;
    public static final int HORIZONTAL_ALIGN_BEGINNING = 32;
    public static final int HORIZONTAL_ALIGN_CENTER = 64;
    public static final int HORIZONTAL_ALIGN_END = 128;
    public static final int HORIZONTAL_ALIGN_FILL = 256;
    public static final int GRAB_HORIZONTAL = 512;
    public static final int GRAB_VERTICAL = 1024;
    public static final int FILL_VERTICAL = 1040;
    public static final int FILL_HORIZONTAL = 768;
    public static final int FILL_BOTH = 1808;
    double cacheWidth = -1.0;
    double cacheHeight = -1.0;
    double defaultWhint;
    double defaultHhint;
    double defaultWidth = -1.0;
    double defaultHeight = -1.0;
    double currentWhint;
    double currentHhint;
    double currentWidth = -1.0;
    double currentHeight = -1.0;

    public GridData() {
    }

    public GridData(int style) {
        if ((style & 2) != 0) {
            this.verticalAlignment.set((Object)Alignment.BEGINNING);
        }
        if ((style & 4) != 0) {
            this.verticalAlignment.set((Object)Alignment.CENTER);
        }
        if ((style & 0x10) != 0) {
            this.verticalAlignment.set((Object)Alignment.FILL);
        }
        if ((style & 8) != 0) {
            this.verticalAlignment.set((Object)Alignment.END);
        }
        if ((style & 0x20) != 0) {
            this.horizontalAlignment.set((Object)Alignment.BEGINNING);
        }
        if ((style & 0x40) != 0) {
            this.horizontalAlignment.set((Object)Alignment.CENTER);
        }
        if ((style & 0x100) != 0) {
            this.horizontalAlignment.set((Object)Alignment.FILL);
        }
        if ((style & 0x80) != 0) {
            this.horizontalAlignment.set((Object)Alignment.END);
        }
        this.grabExcessHorizontalSpace.set((style & 0x200) != 0);
        this.grabExcessVerticalSpace.set((style & 0x400) != 0);
    }

    public GridData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        this(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, 1, 1);
    }

    public GridData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int verticalSpan) {
        this.horizontalAlignment.set((Object)horizontalAlignment);
        this.verticalAlignment.set((Object)verticalAlignment);
        this.grabExcessHorizontalSpace.set(grabExcessHorizontalSpace);
        this.grabExcessVerticalSpace.set(grabExcessVerticalSpace);
        this.horizontalSpan.set(horizontalSpan);
        this.verticalSpan.set(verticalSpan);
    }

    public GridData(int width, int height) {
        this.widthHint.set(width);
        this.heightHint.set(height);
    }

    void computeSize(Node control, int wHint, int hHint, boolean flushCache) {
        if (this.cacheWidth != -1.0 && this.cacheHeight != -1.0) {
            return;
        }
        if (wHint == this.widthHint.get() && hHint == this.heightHint.get()) {
            if (this.defaultWidth == -1.0 || this.defaultHeight == -1.0 || (double)wHint != this.defaultWhint || (double)hHint != this.defaultHhint) {
                this.defaultWhint = wHint;
                this.defaultHhint = hHint;
                this.defaultWidth = wHint == -1 ? control.prefWidth((double)hHint) : this.defaultWhint;
                this.defaultHeight = hHint == -1 ? control.prefHeight((double)wHint) : this.defaultHhint;
            }
            this.cacheWidth = this.defaultWidth;
            this.cacheHeight = this.defaultHeight;
            return;
        }
        if (this.currentWidth == -1.0 || this.currentHeight == -1.0 || (double)wHint != this.currentWhint || (double)hHint != this.currentHhint) {
            this.currentWhint = wHint;
            this.currentHhint = hHint;
            this.currentWidth = control.getLayoutBounds().getWidth();
            this.currentHeight = control.getLayoutBounds().getHeight();
        }
        this.cacheWidth = this.currentWidth;
        this.cacheHeight = this.currentHeight;
    }

    void flushCache() {
        this.cacheHeight = -1.0;
        this.cacheWidth = -1.0;
        this.defaultHeight = -1.0;
        this.defaultWidth = -1.0;
        this.currentHeight = -1.0;
        this.currentWidth = -1.0;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public void setExclude(boolean value) {
        this.exclude.set(value);
    }

    public boolean isExclude() {
        return this.exclude.get();
    }

    public BooleanProperty excludeProperty() {
        return this.exclude;
    }

    public void setGrabHorizontalSpace(boolean value) {
        this.grabExcessHorizontalSpace.set(value);
    }

    public boolean isGrabHorizontalSpace() {
        return this.grabExcessHorizontalSpace.get();
    }

    public BooleanProperty grabHorizontalSpaceProperty() {
        return this.grabExcessHorizontalSpace;
    }

    public void setGrabVerticalSpace(boolean value) {
        this.grabExcessVerticalSpace.set(value);
    }

    public boolean isGrabVerticalSapce() {
        return this.grabExcessVerticalSpace.get();
    }

    public BooleanProperty grabExcessVerticalSpaceProperty() {
        return this.grabExcessVerticalSpace;
    }

    public void setHeightHint(int value) {
        this.heightHint.set(value);
    }

    public int getHeightHint() {
        return this.heightHint.get();
    }

    public IntegerProperty heightHintProperty() {
        return this.heightHint;
    }

    public void setHorizontalAlignment(Alignment value) {
        this.horizontalAlignment.set((Object)value);
    }

    public Alignment getHorizontalAlignment() {
        return (Alignment)((Object)this.horizontalAlignment.get());
    }

    public ObjectProperty<Alignment> horizontalAlignmentProperty() {
        return this.horizontalAlignment;
    }

    public void setHorizontalIdent(int value) {
        this.horizontalIndent.set(value);
    }

    public int getHorizontalIdent() {
        return this.horizontalIndent.get();
    }

    public IntegerProperty horizontalIdentProperty() {
        return this.horizontalIndent;
    }

    public void setHorizontalSpan(int value) {
        this.horizontalSpan.set(value);
    }

    public int getHorizontalSpan() {
        return this.horizontalSpan.get();
    }

    public IntegerProperty horizontalSpanProperty() {
        return this.horizontalSpan;
    }

    public void setMinimumHeight(int value) {
        this.minimumHeight.set(value);
    }

    public int getMinimumHeight() {
        return this.minimumHeight.get();
    }

    public IntegerProperty minimumHeightProperty() {
        return this.minimumHeight;
    }

    public void setMinimumWidth(int value) {
        this.minimumWidth.set(value);
    }

    public int getMinimumWidth() {
        return this.minimumWidth.get();
    }

    public IntegerProperty minimumWidthProperty() {
        return this.minimumWidth;
    }

    public void setVerticalAlignment(Alignment value) {
        this.verticalAlignment.set((Object)value);
    }

    public Alignment getVerticalAlignment() {
        return (Alignment)((Object)this.verticalAlignment.get());
    }

    public ObjectProperty<Alignment> verticalAlignmentProperty() {
        return this.verticalAlignment;
    }

    public void setVerticalIndent(int value) {
        this.verticalIndent.set(value);
    }

    public int getVerticalIndent() {
        return this.verticalIndent.get();
    }

    public IntegerProperty verticalIndentProperty() {
        return this.verticalIndent;
    }

    public void setVerticalSpan(int value) {
        this.verticalSpan.set(value);
    }

    public int getVerticalSpan() {
        return this.verticalSpan.get();
    }

    public IntegerProperty verticalSpanProperty() {
        return this.verticalSpan;
    }

    public void setWidthHint(int value) {
        this.widthHint.set(value);
    }

    public int getWidthHint() {
        return this.widthHint.get();
    }

    public IntegerProperty widthHintProperty() {
        return this.widthHint;
    }

    public String toString() {
        String hAlign = "";
        switch ((Alignment)((Object)this.horizontalAlignment.get())) {
            case FILL: {
                hAlign = "SWT.FILL";
                break;
            }
            case BEGINNING: {
                hAlign = "SWT.BEGINNING";
                break;
            }
            case END: {
                hAlign = "GridData.END";
                break;
            }
            case CENTER: {
                hAlign = "GridData.CENTER";
                break;
            }
            default: {
                hAlign = "Undefined " + this.horizontalAlignment;
            }
        }
        String vAlign = "";
        switch ((Alignment)((Object)this.verticalAlignment.get())) {
            case FILL: {
                vAlign = "SWT.FILL";
                break;
            }
            case BEGINNING: {
                vAlign = "SWT.BEGINNING";
                break;
            }
            case END: {
                vAlign = "SWT.END";
                break;
            }
            case CENTER: {
                vAlign = "SWT.CENTER";
                break;
            }
            default: {
                vAlign = "Undefined " + this.verticalAlignment;
            }
        }
        String string = String.valueOf(this.getName()) + " {";
        string = String.valueOf(string) + "horizontalAlignment=" + hAlign + " ";
        if (this.horizontalIndent.get() != 0) {
            string = String.valueOf(string) + "horizontalIndent=" + this.horizontalIndent.get() + " ";
        }
        if (this.horizontalSpan.get() != 1) {
            string = String.valueOf(string) + "horizontalSpan=" + this.horizontalSpan.get() + " ";
        }
        if (this.grabExcessHorizontalSpace.get()) {
            string = String.valueOf(string) + "grabExcessHorizontalSpace=" + this.grabExcessHorizontalSpace.get() + " ";
        }
        if (this.widthHint.get() != -1) {
            string = String.valueOf(string) + "widthHint=" + this.widthHint.get() + " ";
        }
        if (this.minimumWidth.get() != 0) {
            string = String.valueOf(string) + "minimumWidth=" + this.minimumWidth.get() + " ";
        }
        string = String.valueOf(string) + "verticalAlignment=" + vAlign + " ";
        if (this.verticalIndent.get() != 0) {
            string = String.valueOf(string) + "verticalIndent=" + this.verticalIndent.get() + " ";
        }
        if (this.verticalSpan.get() != 1) {
            string = String.valueOf(string) + "verticalSpan=" + this.verticalSpan.get() + " ";
        }
        if (this.grabExcessVerticalSpace.get()) {
            string = String.valueOf(string) + "grabExcessVerticalSpace=" + this.grabExcessVerticalSpace.get() + " ";
        }
        if (this.heightHint.get() != -1) {
            string = String.valueOf(string) + "heightHint=" + this.heightHint.get() + " ";
        }
        if (this.minimumHeight.get() != 0) {
            string = String.valueOf(string) + "minimumHeight=" + this.minimumHeight.get() + " ";
        }
        if (this.exclude.get()) {
            string = String.valueOf(string) + "exclude=" + this.exclude.get() + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }

    public static enum Alignment {
        BEGINNING,
        CENTER,
        END,
        FILL;

    }
}

