/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.lifecycle.ELifecycleService;
import org.eclipse.fx.ui.lifecycle.annotations.PreClose;
import org.eclipse.fx.ui.lifecycle.annotations.PreShow;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;

public abstract class BaseMenuRenderer<N>
extends BaseRenderer<MMenu, WMenu<N>>
implements EventProcessor.ChildrenHandler<MMenu, MMenuElement> {
    @Inject
    private ELifecycleService lifecycleService;
    @Inject
    private IContributionFactory contributionFactory;
    @Log
    @Inject
    private Logger logger;
    private static final String DYNAMIC_MENU_CONTRIBUTION = "DYNAMIC_MENU_CONTRIBUTION";

    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    protected void initWidget(final MMenu element, WMenu<N> widget) {
        super.initWidget(element, widget);
        widget.setShowingCallback(new Runnable(){

            @Override
            public void run() {
                BaseMenuRenderer.this.handleShowing(element);
            }
        });
        widget.setHidingCallback(new Runnable(){

            @Override
            public void run() {
                IEclipseContext context = BaseMenuRenderer.this.getModelContext((MUIElement)element).createChild("lifecycle");
                context.set(MMenu.class, (Object)element);
                BaseMenuRenderer.this.lifecycleService.validateAnnotation(PreClose.class, (MUIElement)element, context);
                MMenuElement[] mMenuElementArray = element.getChildren().toArray(new MMenuElement[0]);
                int n = mMenuElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MDynamicMenuContribution dc;
                    Object contrib;
                    MMenuElement e = mMenuElementArray[n2];
                    if (e instanceof MDynamicMenuContribution && (contrib = (dc = (MDynamicMenuContribution)e).getObject()) != null) {
                        List previous = (List)dc.getTransientData().remove(BaseMenuRenderer.DYNAMIC_MENU_CONTRIBUTION);
                        context.set(List.class, (Object)previous);
                        try {
                            ContextInjectionFactory.invoke((Object)contrib, AboutToHide.class, (IEclipseContext)context, null);
                            if (previous != null && !previous.isEmpty()) {
                                element.getChildren().removeAll(previous);
                            }
                        }
                        catch (Throwable t) {
                            BaseMenuRenderer.this.logger.debug("Unable to process the AboutToHide", t);
                        }
                    }
                    ++n2;
                }
                context.dispose();
            }
        });
    }

    void handleShowing(MMenu element) {
        IEclipseContext context = this.getModelContext((MUIElement)element).createChild("lifecycle");
        context.set(MMenu.class, (Object)element);
        this.lifecycleService.validateAnnotation(PreShow.class, (MUIElement)element, context);
        MMenuElement[] mMenuElementArray = element.getChildren().toArray(new MMenuElement[0]);
        int n = mMenuElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMenuElement e = mMenuElementArray[n2];
            if (e instanceof MDynamicMenuContribution) {
                Object contrib;
                MDynamicMenuContribution dc = (MDynamicMenuContribution)e;
                if (dc.getObject() == null && dc.getContributionURI() != null) {
                    try {
                        dc.setObject(this.contributionFactory.create(dc.getContributionURI(), context));
                    }
                    catch (Throwable t) {
                        this.logger.debug("Unable to create contribution", t);
                    }
                }
                if ((contrib = dc.getObject()) != null) {
                    ArrayList list = new ArrayList();
                    context.set(List.class, list);
                    try {
                        ContextInjectionFactory.invoke((Object)contrib, AboutToShow.class, (IEclipseContext)context, null);
                        int idx = element.getChildren().indexOf(e);
                        element.getChildren().addAll(idx, list);
                        dc.getTransientData().put(DYNAMIC_MENU_CONTRIBUTION, list);
                    }
                    catch (Throwable t) {
                        this.logger.debug("Unable to process AboutToShow", t);
                    }
                }
            }
            ++n2;
        }
        for (MMenuElement e : element.getChildren()) {
            if (!(e.getRenderer() instanceof BaseItemRenderer)) continue;
            BaseItemRenderer r = (BaseItemRenderer)((Object)e.getRenderer());
            r.checkEnablement(e);
        }
        context.dispose();
    }

    @Override
    public void doProcessContent(MMenu element) {
        WMenu menu = (WMenu)this.getWidget((MUIElement)element);
        for (MMenuElement e : element.getChildren()) {
            WMenuElement widget;
            if (!e.isToBeRendered() || (widget = (WMenuElement)this.engineCreateWidget(e)) == null || !e.isVisible()) continue;
            menu.addElement(widget);
        }
    }

    @Override
    public void handleChildrenRemove(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (element instanceof MDynamicMenuContribution) {
                MDynamicMenuContribution dc = (MDynamicMenuContribution)element;
                dc.getObject();
            }
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenAddition(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    public void childRendered(MMenu parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WMenu menu = (WMenu)this.getWidget((MUIElement)parentElement);
        WMenuElement menuElement = (WMenuElement)element.getWidget();
        menu.addElement(idx, menuElement);
    }

    @Override
    protected int getRenderedIndex(MUIElement parent, MUIElement element) {
        EObject eElement = (EObject)element;
        EObject container = eElement.eContainer();
        List list = (List)container.eGet((EStructuralFeature)eElement.eContainmentFeature());
        int idx = 0;
        for (MUIElement u : list) {
            if (!u.isToBeRendered() || !u.isVisible() || u instanceof MDynamicMenuContribution) continue;
            if (u == element) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public void hideChild(MMenu container, MUIElement changedObj) {
        WMenu menu = (WMenu)this.getWidget((MUIElement)container);
        if (menu == null) {
            return;
        }
        WMenuElement widget = (WMenuElement)changedObj.getWidget();
        if (widget != null) {
            menu.removeElement(widget);
        }
    }
}

