/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding;

import java.text.MessageFormat;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.fx.core.databinding.AdapterFactory;
import org.eclipse.fx.core.databinding.ObservableWritableValue;

public abstract class PropertyListCellFaytory<O>
implements Callback<ListView<O>, ListCell<O>> {
    public static <O> PropertyListCellFaytory<O> textFactory(final IValueProperty textProperty) {
        return new PropertyListCellFaytory<O>(){

            public ListCell<O> call(ListView<O> param) {
                return 1.textCell(textProperty);
            }
        };
    }

    public static <O> PropertyListCellFaytory<O> textFactory(final String template, final IValueProperty ... textProperties) {
        return new PropertyListCellFaytory<O>(){

            public ListCell<O> call(ListView<O> param) {
                return 2.textCell(template, textProperties);
            }
        };
    }

    public static <O> ListCell<O> textCell(IValueProperty textProperty) {
        return new TextOnlyPropertyListCell(textProperty);
    }

    public static <O> ListCell<O> textCell(String template, IValueProperty ... textProperties) {
        return new TemplateTextOnlyPropertyListCell(template, textProperties);
    }

    static class TemplateComputedValue
    extends ComputedValue {
        private IObservableValue[] values;
        private String template;

        public TemplateComputedValue(Object o, String template, IValueProperty[] properties) {
            this.template = template;
            this.values = new IObservableValue[properties.length];
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = properties[i].observe(o);
                ++i;
            }
        }

        protected Object calculate() {
            Object[] v = new Object[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                v[i] = this.values[i].getValue();
                ++i;
            }
            return MessageFormat.format(this.template, v);
        }

        public synchronized void dispose() {
            super.dispose();
            IObservableValue[] iObservableValueArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                IObservableValue v = iObservableValueArray[n2];
                v.dispose();
                ++n2;
            }
        }
    }

    static class TemplateTextOnlyPropertyListCell<O>
    extends ListCell<O> {
        private IObservableValue currentObservable;
        private IValueProperty[] properties;
        private String template;

        public TemplateTextOnlyPropertyListCell(String template, IValueProperty ... properties) {
            this.template = template;
            this.properties = properties;
        }

        protected void updateItem(O item, boolean empty) {
            super.updateItem(item, empty);
            IObservableValue oldObservable = this.currentObservable;
            this.textProperty().unbind();
            if (item != null && !empty) {
                this.currentObservable = new TemplateComputedValue(item, this.template, this.properties);
                ObservableWritableValue adapt = AdapterFactory.adapt((IObservableValue)this.currentObservable);
                this.textProperty().bind((ObservableValue)adapt);
            } else {
                this.setText(null);
            }
            if (oldObservable != null) {
                oldObservable.dispose();
            }
        }
    }

    static class TextOnlyPropertyListCell<O>
    extends ListCell<O> {
        private IObservableValue currentObservable;
        private IValueProperty textProperty;

        public TextOnlyPropertyListCell(IValueProperty textProperty) {
            this.textProperty = textProperty;
        }

        protected void updateItem(O item, boolean empty) {
            super.updateItem(item, empty);
            IObservableValue oldObservable = this.currentObservable;
            this.textProperty().unbind();
            if (item != null && !empty) {
                this.currentObservable = this.textProperty.observe(item);
                ObservableWritableValue adapt = AdapterFactory.adapt((IObservableValue)this.currentObservable);
                this.textProperty().bind((ObservableValue)adapt);
            } else {
                this.setText(null);
            }
            if (oldObservable != null) {
                oldObservable.dispose();
            }
        }
    }
}

