/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.internal;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.inject.Inject;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.services.resources.GraphicNodeProvider;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.resources.ImageProvider;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.fx.internal.ProviderComponent;
import org.eclipse.jdt.annotation.NonNull;

public class GraphicsLoaderImpl
implements GraphicsLoader {
    private WeakHashMap<URI, WeakReference<Image>> imageCache = new WeakHashMap();
    @Inject
    private ProviderComponent providerComponent;
    @Inject
    @Optional
    private ThemeManager themeManager;
    @Inject
    @Log
    private Logger logger;

    public void setProviderComponent(ProviderComponent providerComponent) {
        this.providerComponent = providerComponent;
    }

    public void unsetProviderComponent(ProviderComponent providerComponent) {
        if (this.providerComponent == providerComponent) {
            this.providerComponent = null;
        }
    }

    public Image getImage(URI _uri) {
        ImageProvider pv;
        Theme currentTheme;
        HashMap<@NonNull String, @NonNull String> map = new HashMap<String, String>();
        if (this.themeManager != null && this.themeManager.getCurrentTheme() != null && (currentTheme = this.themeManager.getCurrentTheme()) != null) {
            map.put("themeId", currentTheme.getId());
        }
        URI uri = GraphicsLoaderImpl.replaceDynamicValues(_uri, map);
        WeakReference<Image> r = this.imageCache.get(uri);
        Image img = null;
        if (r != null) {
            img = (Image)r.get();
        }
        if (img == null && (pv = this.providerComponent.getImageProvider(uri)) != null) {
            try {
                img = pv.getImage(uri);
                this.imageCache.put(uri, new WeakReference<Image>(img));
            }
            catch (IOException e) {
                this.logger.error("Unable to load image from '" + uri + "'", (Throwable)e);
            }
        }
        return img;
    }

    public Node getGraphicsNode(URI _uri) {
        URI uri;
        GraphicNodeProvider graphicNodeProvider;
        Theme currentTheme;
        HashMap<@NonNull String, @NonNull String> map = new HashMap<String, String>();
        if (this.themeManager != null && this.themeManager.getCurrentTheme() != null && (currentTheme = this.themeManager.getCurrentTheme()) != null) {
            map.put("themeId", currentTheme.getId());
        }
        if ((graphicNodeProvider = this.providerComponent.getGraphicNodeProvider(uri = GraphicsLoaderImpl.replaceDynamicValues(_uri, map))) == null) {
            Image img = this.getImage(uri);
            if (img != null) {
                return new ImageView(img);
            }
        } else {
            try {
                return graphicNodeProvider.getGraphicNode(uri);
            }
            catch (IOException e) {
                this.logger.error("Unable to load graphic node from '" + uri + "'", (Throwable)e);
            }
        }
        return null;
    }

    private static @NonNull URI replaceDynamicValues(@NonNull URI uri, @NonNull Map<@NonNull String, @NonNull String> dynamicMap) {
        String s = uri.toString();
        s = StrSubstitutor.replace((Object)s, dynamicMap);
        return uri.createURI(s);
    }
}

