/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import org.eclipse.fx.core.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleURI
implements URI {
    private @NonNull String[] segments = new String[0];
    private @Nullable String query;
    private @NonNull String uri;

    public SimpleURI(@NonNull String uri) {
        this.uri = uri;
        this.parseURI(uri);
    }

    private void parseURI(String uri) {
        int queryStart;
        String _uri = uri;
        int schemeEnd = _uri.indexOf(58);
        if (schemeEnd != -1) {
            _uri = _uri.substring(schemeEnd + 2);
        }
        if ((queryStart = _uri.indexOf(63)) != -1) {
            this.query = _uri.substring(queryStart + 1);
            _uri = _uri.substring(0, queryStart);
        }
        this.segments = _uri.split("/");
    }

    @Override
    public boolean isPlatformPlugin() {
        return this.segments.length > 0 && "plugin".equals(this.segments[0]);
    }

    @Override
    public @Nullable String segment(int i) {
        if (i < this.segments.length) {
            return this.segments[i];
        }
        return null;
    }

    @Override
    public int segmentCount() {
        return this.segments.length;
    }

    @Override
    public @Nullable String query() {
        return this.query;
    }

    @Override
    public @Nullable String lastSegment() {
        int l = this.segments.length;
        if (l == 0) {
            return null;
        }
        return this.segments[l - 1];
    }

    public String toString() {
        return this.uri;
    }

    @Override
    public boolean hasQuery() {
        return this.query != null;
    }

    @Override
    public URI createURI(String s) {
        return new SimpleURI(s);
    }
}

