/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.base.rendering.ElementRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPlaceholderWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.services.EModelStylingService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;

public abstract class BaseRenderer<M extends MUIElement, W extends WWidget<M>>
implements ElementRenderer<M, W> {
    private static final String RENDERING_CONTEXT_KEY = "fx.rendering.context";
    public static final String CONTEXT_DOM_ELEMENT = "fx.rendering.domElement";
    private static final String RENDER_KEY = "_renderer";
    @Inject
    IEclipseContext _context;
    @Inject
    EModelService modelService;
    @Inject
    EModelStylingService modelStylingService;
    Map<String, EAttribute> attributeMap = new HashMap<String, EAttribute>();
    private Map<MUIElement, Boolean> contentProcessing = new HashMap<MUIElement, Boolean>();
    Map<MUIElement, Boolean> contextModification = new HashMap<MUIElement, Boolean>();
    Map<MUIElement, Boolean> uiModification = new HashMap<MUIElement, Boolean>();
    @Inject
    @Log
    Logger logger;
    final @NonNull Map<@NonNull MUIElement, @NonNull ActiveLeafRunAndTrack> visibleWhenElements = new HashMap<MUIElement, ActiveLeafRunAndTrack>();
    public static final String CALCULATED_VISIBILITY = "efx_calculated_visibility";
    public static final String CURRENT_VISIBLE_WHEN = "efx_current_visible_when";

    protected Logger getLogger() {
        return this.logger;
    }

    protected boolean inContentProcessing(MUIElement element) {
        return this.contentProcessing.get(element) == Boolean.TRUE;
    }

    protected boolean inContextModification(@NonNull MUIElement element) {
        return this.contextModification.get(element) == Boolean.TRUE;
    }

    protected boolean inUIModification(@NonNull MUIElement element) {
        return this.uiModification.get(element) == Boolean.TRUE;
    }

    public final @NonNull W createWidget(@NonNull M element) {
        IEclipseContext context = this.setupRenderingContext(element);
        WWidget widget = (WWidget)ContextInjectionFactory.make(this.getWidgetClass(element), (IEclipseContext)context);
        widget.setPropertyChangeHandler(e -> this.propertyObjectChanged(element, e));
        this.initWidget(element, widget);
        IEventBroker broker = (IEventBroker)this._context.get(IEventBroker.class);
        if (broker != null) {
            this.initDefaultEventListeners(broker);
        } else {
            this.logger.error("No event broker was found. Most things will not operate appropiately!");
        }
        element.getTransientData().put(CALCULATED_VISIBILITY, element.isVisible() && BaseRenderer.checkVisibleWhen(element, this.getModelContext((MUIElement)element)));
        if (element.getVisibleWhen() != null) {
            ActiveLeafRunAndTrack rat = new ActiveLeafRunAndTrack((MUIElement)element, (IEventBroker)this._context.get(IEventBroker.class));
            this.visibleWhenElements.put((MUIElement)element, rat);
            IEclipseContext modelContext = this.getModelContext((MUIElement)element);
            if (modelContext != null) {
                modelContext.runAndTrack((RunAndTrack)rat);
            }
        }
        return (W)widget;
    }

    public void syncUIModifications(@NonNull MUIElement element, @NonNull Runnable codeBlock) {
        if (this.inUIModification(element)) {
            codeBlock.run();
            return;
        }
        try {
            this.uiModification.put(element, Boolean.TRUE);
            codeBlock.run();
        }
        finally {
            this.uiModification.remove(element);
        }
    }

    private void propertyObjectChanged(@NonNull M element,  @NonNull WPropertyChangeHandler.WPropertyChangeEvent<W> event) {
        if (this.inUIModification((MUIElement)element) || this.inContextModification((MUIElement)element)) {
            return;
        }
        try {
            EStructuralFeature f;
            this.uiModification.put((MUIElement)element, Boolean.TRUE);
            EAttribute attribute = this.attributeMap.get(event.propertyname);
            EObject eo = (EObject)element;
            if (attribute == null && (f = eo.eClass().getEStructuralFeature(event.propertyname)) instanceof EAttribute) {
                attribute = (EAttribute)f;
                this.attributeMap.put(event.propertyname, attribute);
            }
            if (attribute != null) {
                if (attribute.getEType().getInstanceClass() == Integer.TYPE) {
                    Object v = event.newValue;
                    if (v == null) {
                        eo.eSet((EStructuralFeature)attribute, (Object)0);
                    } else {
                        eo.eSet((EStructuralFeature)attribute, (Object)((Number)v).intValue());
                    }
                } else {
                    eo.eSet((EStructuralFeature)attribute, event.newValue);
                }
            }
        }
        finally {
            this.uiModification.remove(element);
        }
    }

    private void initDefaultEventListeners(@NonNull IEventBroker broker) {
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/application/ApplicationElement/persistedState/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/application/ApplicationElement/tags/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UIElement/containerData/*");
        broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visibleWhen/*", this::handleVisibleWhen);
    }

    private void handleVisibleWhen(Event event) {
        Object element = event.getProperty("ChangedElement");
        if (element instanceof MUIElement) {
            MUIElement e = (MUIElement)element;
            if (e.getRenderer() == this) {
                if (e.getVisibleWhen() == null) {
                    this.visibleWhenElements.remove(e);
                } else {
                    this.visibleWhenElements.put(e, new ActiveLeafRunAndTrack(e, (IEventBroker)this._context.get(IEventBroker.class)));
                }
            }
            IEventBroker broker = (IEventBroker)this._context.get(IEventBroker.class);
            broker.send("org/eclipse/fx/MUIElement/UpdateVisibleWhenResult", (Object)e);
        }
    }

    protected boolean isRenderer(@NonNull MUIElement element) {
        if (element.getRenderer() != null) {
            return element.getRenderer() == this;
        }
        @Nullable IEclipseContext renderingContext = this.getRenderingContext(element);
        if (renderingContext != null) {
            return renderingContext.get(RENDER_KEY) == this;
        }
        return false;
    }

    public final IEclipseContext setupRenderingContext(@NonNull M element) {
        IEclipseContext context;
        block6: {
            context = (IEclipseContext)element.getTransientData().get(RENDERING_CONTEXT_KEY);
            if (context == null) {
                context = this._context.createChild("Element RenderingContext");
                context.set(RENDER_KEY, (Object)this);
                element.getTransientData().put(RENDERING_CONTEXT_KEY, context);
                context.set(CONTEXT_DOM_ELEMENT, element);
                this.initRenderingContext(element, context);
                try {
                    this.contextModification.put((MUIElement)element, Boolean.TRUE);
                    EObject eo = element instanceof MPlaceholder ? (EObject)((MPlaceholder)element).getRef() : (EObject)element;
                    if (eo != null) {
                        this.initContext(eo, context);
                        if (element instanceof MPlaceholder) {
                            this.initContext((EObject)element, context);
                        }
                        break block6;
                    }
                    throw new IllegalStateException("The placeholder reference of '" + element + "' is null");
                }
                finally {
                    this.contextModification.remove(element);
                }
            }
        }
        return context;
    }

    protected void initContext(@NonNull EObject eo, @NonNull IEclipseContext context) {
        for (EAttribute eAttribute : eo.eClass().getEAllAttributes()) {
            context.set(eAttribute.getName(), eo.eGet((EStructuralFeature)eAttribute));
        }
        if (eo instanceof MApplicationElement) {
            for (Map.Entry entry : ((MApplicationElement)eo).getPersistedState().entrySet()) {
                context.set("persistedState_" + (String)entry.getKey(), entry.getValue());
            }
        }
    }

    protected void registerEventListener(@NonNull IEventBroker broker, @NonNull String topic) {
        broker.subscribe(topic, this::handleEvent);
    }

    void handleEvent(Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MUIElement)) {
            return;
        }
        Object newValue = event.getProperty("NewValue");
        String attributeName = event.getProperty("AttName").toString();
        if (!UIEvents.isSET((Event)event) && !"tags".equals(attributeName)) {
            return;
        }
        MUIElement e = (MUIElement)changedObj;
        if (this.inContextModification(e)) {
            return;
        }
        try {
            this.contextModification.put(e, Boolean.TRUE);
            if (changedObj instanceof MUIElement && this.isRenderer(e)) {
                IEclipseContext ctx;
                MUIElement m;
                if (attributeName.equals("tags") && (m = (MUIElement)changedObj).getWidget() != null) {
                    if (UIEvents.isADD((Event)event)) {
                        Collection addedTags = Util.asCollection(event, "NewValue");
                        ((WWidget)m.getWidget()).addStyleClasses(this.modelStylingService.getStylesFromTags(new ArrayList(addedTags)));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        Collection removedTags = Util.asCollection(event, "OldValue");
                        ((WWidget)m.getWidget()).removeStyleClasses(this.modelStylingService.getStylesFromTags(new ArrayList(removedTags)));
                    }
                }
                if ((ctx = (IEclipseContext)e.getTransientData().get(RENDERING_CONTEXT_KEY)) != null) {
                    if (attributeName.equals("persistedState") && newValue instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)newValue;
                        ctx.set(String.valueOf(attributeName) + "_" + (String)entry.getKey(), entry.getValue());
                    } else if (attributeName.equals("tags")) {
                        ctx.set("tags", new ArrayList(e.getTags()));
                    } else {
                        ctx.set(attributeName, newValue);
                    }
                    this.handleAttributeChange(e, ctx, attributeName, newValue);
                }
            }
        }
        finally {
            this.contextModification.remove(e);
        }
    }

    protected void handleAttributeChange(MUIElement e, IEclipseContext context, String attributeName, Object newValue) {
        if (e instanceof MUILabel) {
            MUILabel l = (MUILabel)e;
            if ("label".equals(attributeName)) {
                context.set("localizedLabel", (Object)l.getLocalizedLabel());
            } else if ("tooltip".equals(attributeName)) {
                context.set("localizedTooltip", (Object)l.getLocalizedTooltip());
            }
        }
    }

    protected void initRenderingContext(@NonNull M element, @NonNull IEclipseContext context) {
    }

    protected void initWidget(@NonNull M element, @NonNull W widget) {
    }

    public void destroyWidget(@NonNull M element) {
        if (element.getTransientData().containsKey(RENDERING_CONTEXT_KEY)) {
            if (element.getWidget() instanceof WWidget) {
                ((WWidget)element.getWidget()).setWidgetState(WWidget.WidgetState.DISPOSED);
            }
            this.unbindWidget(element, (WWidget)element.getWidget());
            IEclipseContext ctx = (IEclipseContext)element.getTransientData().get(RENDERING_CONTEXT_KEY);
            ctx.dispose();
            element.getTransientData().remove(RENDERING_CONTEXT_KEY);
        }
        if (element.getVisibleWhen() != null) {
            this.visibleWhenElements.remove(element);
        }
    }

    private void unbindWidget(@NonNull M me, @NonNull W widget) {
        widget.setDomElement(null);
        me.setWidget(null);
    }

    public void bindWidget(@NonNull M me, @NonNull W widget) {
        widget.setDomElement(me);
        widget.addStyleClasses(this.modelStylingService.getStyles(me));
        EObject eo = (EObject)me;
        widget.addStyleClasses("M" + eo.eClass().getName());
        for (EClass e : eo.eClass().getEAllSuperTypes()) {
            widget.addStyleClasses("M" + e.getName());
        }
        String elementId = me.getElementId();
        if (elementId != null) {
            widget.setStyleId(Util.toCSSId(elementId));
        }
        me.setWidget(widget);
    }

    public void postProcess(@NonNull M element) {
        if (element.getWidget() instanceof WWidget) {
            ((WWidget)element.getWidget()).setWidgetState(WWidget.WidgetState.CREATED);
        }
    }

    public void preDestroy(@NonNull M element) {
        if (element.getWidget() instanceof WWidget) {
            ((WWidget)element.getWidget()).setWidgetState(WWidget.WidgetState.IN_TEAR_DOWN);
        }
    }

    protected @NonNull IPresentationEngine getPresentationEngine() {
        IPresentationEngine p = (IPresentationEngine)this._context.get(IPresentationEngine.class);
        if (p == null) {
            throw new IllegalStateException("IPresentationEngine not available");
        }
        return p;
    }

    protected abstract @NonNull Class<@NonNull ? extends W> getWidgetClass(@NonNull M var1);

    protected <LW extends WWidget<PM>, PM extends MUIElement> @Nullable LW engineCreateWidget(@NonNull PM pm) {
        return (LW)((WWidget)this.getPresentationEngine().createGui(pm));
    }

    protected <LW extends WWidget<PM>, PM extends MUIElement> @Nullable LW engineCreateWidget(@NonNull PM pm, @NonNull IEclipseContext context) {
        return (LW)((WWidget)this.getPresentationEngine().createGui(pm, null, context));
    }

    protected @Nullable IEclipseContext getRenderingContext(@NonNull MUIElement element) {
        return (IEclipseContext)element.getTransientData().get(RENDERING_CONTEXT_KEY);
    }

    protected @Nullable IEclipseContext getContextForParent(@NonNull MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    public @Nullable IEclipseContext getModelContext(@NonNull MUIElement element) {
        if (element instanceof MContext) {
            return ((MContext)element).getContext();
        }
        return this.getContextForParent(element);
    }

    protected void activate(@NonNull MPart element, boolean requiresFocus) {
        this.logger.debug("Activating " + element);
        IEclipseContext curContext = this.getModelContext((MUIElement)element);
        if (curContext != null) {
            BaseRenderer.printContextHierarchy(this.logger, curContext);
            EPartService ps = (EPartService)curContext.get(EPartService.class.getName());
            this.logger.debug("activating with: " + ps);
            this.logger.debug("The window: " + curContext.get(MWindow.class));
            if (ps != null) {
                ps.activate(element, requiresFocus);
            }
        }
    }

    private static final void printContextHierarchy(Logger logger, IEclipseContext c) {
        if (logger.isEnabled(Logger.Level.DEBUG)) {
            IEclipseContext context = c;
            logger.debug("=== Context ===");
            do {
                logger.debug("" + context);
            } while ((context = context.getParent()) != null);
        }
    }

    public final void processContent(@NonNull M element) {
        try {
            this.contentProcessing.put((MUIElement)element, Boolean.TRUE);
            this.doProcessContent(element);
        }
        finally {
            this.contentProcessing.remove(element);
        }
    }

    public static boolean checkVisibleWhen(MUIElement item, IEclipseContext context) {
        if (item.getVisibleWhen() != null && item.getVisibleWhen() instanceof MCoreExpression) {
            ExpressionContext exprContext = new ExpressionContext(context.getActiveLeaf());
            boolean value = ContributionsAnalyzer.isVisible((MCoreExpression)((MCoreExpression)item.getVisibleWhen()), (ExpressionContext)exprContext);
            item.getTransientData().put(CURRENT_VISIBLE_WHEN, value);
            return value;
        }
        return true;
    }

    public static boolean getVisibleWhen(MUIElement item, IEclipseContext context) {
        if (item.getVisibleWhen() != null) {
            if (item.getTransientData().get(CURRENT_VISIBLE_WHEN) != null) {
                return (Boolean)item.getTransientData().get(CURRENT_VISIBLE_WHEN);
            }
            return BaseRenderer.checkVisibleWhen(item, context);
        }
        return true;
    }

    protected final int getRenderedIndex(@NonNull MUIElement parent, @NonNull MUIElement element) {
        EObject eElement = (EObject)element;
        EObject container = eElement.eContainer();
        List list = (List)container.eGet((EStructuralFeature)eElement.eContainmentFeature());
        int idx = 0;
        for (MUIElement u : list) {
            if (u == null) {
                this.getLogger().error("Found a null element in " + list);
                continue;
            }
            if (!this.isChildRenderedAndVisible(u)) continue;
            if (u == element) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public boolean isChildRenderedAndVisible(@NonNull MUIElement u) {
        return u.isToBeRendered() && u.isVisible() && BaseRenderer.getVisibleWhen(u, this.getModelContext(u));
    }

    protected abstract void doProcessContent(@NonNull M var1);

    protected void checkSelectedElement(MUIElement element) {
        MElementContainer parent;
        if (element instanceof MElementContainer && (parent = (MElementContainer)element).getSelectedElement() != null) {
            if (parent.getChildren().isEmpty()) {
                parent.setSelectedElement(null);
            } else {
                Optional<MUIElement> first = parent.getChildren().stream().filter(c -> c == parent.getSelectedElement() && this.isChildRenderedAndVisible((MUIElement)c)).findFirst();
                if (!first.isPresent()) {
                    first = parent.getChildren().stream().filter(c -> this.isChildRenderedAndVisible((MUIElement)c)).findFirst();
                    if (first.isPresent()) {
                        parent.setSelectedElement(first.get());
                    } else {
                        parent.setSelectedElement(null);
                    }
                }
            }
        }
    }

    protected void fixContextHierarchy(@NonNull Collection<@NonNull ? extends MUIElement> elements) {
        elements.stream().forEach(this::fixContextHierarchy);
    }

    protected void fixContextHierarchy(@NonNull MUIElement element) {
        IEclipseContext context;
        MUIElement tmp = element;
        if (!tmp.isToBeRendered()) {
            return;
        }
        if (tmp instanceof MPlaceholder && tmp.getWidget() != null) {
            MPlaceholder ph = (MPlaceholder)tmp;
            MUIElement ref = ph.getRef();
            if (ref.getCurSharedRef() != ph) {
                ref.setCurSharedRef(ph);
                WPlaceholderWidget placeholder = (WPlaceholderWidget)ph.getWidget();
                WLayoutedWidget content = (WLayoutedWidget)ref.getWidget();
                placeholder.setContent(content);
            }
            tmp = ref;
        }
        if (tmp instanceof MContext && (context = ((MContext)tmp).getContext()) != null) {
            IEclipseContext newParentContext = this.modelService.getContainingContext(tmp);
            if (context.getParent() != newParentContext) {
                Util.setParentContext(context, newParentContext);
            }
        }
        if (tmp instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)tmp;
            ArrayList kids = new ArrayList(container.getChildren());
            for (MUIElement childElement : kids) {
                this.fixContextHierarchy(childElement);
            }
        }
    }

    public void focus(@NonNull MUIElement element) {
        if (element.getWidget() instanceof WWidget) {
            WWidget widget = (WWidget)element.getWidget();
            widget.activate();
        }
    }

    public W getWidget(@NonNull M element) {
        return (W)((WWidget)element.getWidget());
    }

    public static <M extends MApplicationElement> void populateModelInterfaces(M element, IEclipseContext context, Class<M> clazz) {
        BaseRenderer.populateModelInterfaces(element, context, clazz.getInterfaces());
    }

    private static void populateModelInterfaces(MApplicationElement element, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            context.set(intf.getName(), (Object)element);
            BaseRenderer.populateModelInterfaces(element, context, intf.getInterfaces());
            ++n2;
        }
    }

    class ActiveLeafRunAndTrack
    extends RunAndTrack {
        RunAndTrack currentActiveLeafRAT;
        final MUIElement element;
        final HashSet<String> variables;
        final IEventBroker broker;

        public ActiveLeafRunAndTrack(MUIElement element, IEventBroker broker) {
            this.element = element;
            this.broker = broker;
            ExpressionInfo info = new ExpressionInfo();
            ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)element.getVisibleWhen());
            this.variables = new HashSet<String>(Arrays.asList(info.getAccessedVariableNames()));
        }

        public boolean changed(IEclipseContext context) {
            if (BaseRenderer.this.visibleWhenElements.get(this.element) == this) {
                this.currentActiveLeafRAT = new RunAndTrack(){

                    public boolean changed(IEclipseContext context) {
                        if (ActiveLeafRunAndTrack.this.currentActiveLeafRAT == this) {
                            for (String v : ActiveLeafRunAndTrack.this.variables) {
                                context.get(v);
                            }
                            ActiveLeafRunAndTrack.this.broker.send("org/eclipse/fx/MUIElement/UpdateVisibleWhenResult", (Object)ActiveLeafRunAndTrack.this.element);
                            return true;
                        }
                        return false;
                    }
                };
                context.getActiveLeaf().runAndTrack(this.currentActiveLeafRAT);
                return true;
            }
            this.currentActiveLeafRAT = null;
            return false;
        }
    }
}

