/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckType;

public interface Issue {
    public static final String CODE_KEY = "CODE_KEY";
    public static final String URI_KEY = "URI_KEY";
    public static final String DATA_KEY = "DATA_KEY";

    public Severity getSeverity();

    public String getMessage();

    public String getCode();

    public CheckType getType();

    public URI getUriToProblem();

    public Integer getLineNumber();

    public Integer getOffset();

    public Integer getLength();

    public boolean isSyntaxError();

    public String[] getData();

    public static class IssueImpl
    implements Issue {
        private static Logger LOG = Logger.getLogger(IssueImpl.class);
        private Integer length;
        private Integer lineNumber;
        private Integer offset;
        private String code;
        private String message;
        private boolean isSyntaxError = false;
        private URI uriToProblem;
        private Severity severity;
        private CheckType type;
        private String[] data;

        @Override
        public Integer getLength() {
            return this.length;
        }

        public void setLength(Integer length) {
            if (length < 0) {
                LOG.error((Object)"Issue length < 0");
                this.length = 0;
            } else {
                this.length = length;
            }
        }

        @Override
        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
        }

        @Override
        public Integer getOffset() {
            return this.offset;
        }

        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public URI getUriToProblem() {
            return this.uriToProblem;
        }

        public void setUriToProblem(URI uriToProblem) {
            this.uriToProblem = uriToProblem;
        }

        @Override
        public Severity getSeverity() {
            return this.severity == null ? Severity.ERROR : this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        @Override
        public String[] getData() {
            return this.data;
        }

        public void setData(String[] data) {
            this.data = data;
        }

        @Override
        public CheckType getType() {
            return this.type;
        }

        public void setType(CheckType type) {
            this.type = type;
        }

        public void setSyntaxError(boolean isSyntaxError) {
            this.isSyntaxError = isSyntaxError;
        }

        @Override
        public boolean isSyntaxError() {
            return this.isSyntaxError;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this.getSeverity().name());
            buffer.append(":").append(this.getMessage());
            buffer.append(" (");
            if (this.getUriToProblem() != null) {
                buffer.append(this.getUriToProblem().trimFragment());
            }
            buffer.append(" line : ").append(this.getLineNumber()).append(")");
            return buffer.toString();
        }
    }
}

