/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class STRINGValueConverter
extends AbstractLexerBasedConverter<String> {
    @Override
    protected String toEscapedString(String value) {
        return String.valueOf('\"') + Strings.convertToJavaString((String)value, (boolean)false) + '\"';
    }

    @Override
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.length() == 1) {
                throw new ValueConverterWithValueException(this.getStringNotClosedMessage(), node, "", null);
            }
            return this.convertFromString(string, node);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, e);
        }
    }

    protected String convertFromString(String literal, INode node) throws ValueConverterWithValueException {
        char aChar;
        char[] convtBuf;
        char[] in = literal.toCharArray();
        int off = 1;
        int len = literal.length() - 1;
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        String errorMessage = null;
        int errorIndex = -1;
        int errorLength = -1;
        block16: while (off < end - 1) {
            if ((aChar = in[off++]) == '\\') {
                if (off < end) {
                    aChar = in[off++];
                    switch (aChar) {
                        case 'u': {
                            int value = 0;
                            if (off + 4 > end || !this.isHexSequence(in, off, 4)) {
                                out[outLen++] = aChar;
                                if (errorMessage != null) continue block16;
                                errorMessage = "Invalid unicode";
                                errorIndex = off - 2;
                                errorLength = 2;
                                break;
                            }
                            int i = 0;
                            while (i < 4) {
                                aChar = in[off++];
                                switch (aChar) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + aChar - 48;
                                        break;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + aChar - 97;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + aChar - 65;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                                ++i;
                            }
                            out[outLen++] = (char)value;
                            break;
                        }
                        case 't': {
                            out[outLen++] = 9;
                            break;
                        }
                        case 'r': {
                            out[outLen++] = 13;
                            break;
                        }
                        case 'n': {
                            out[outLen++] = 10;
                            break;
                        }
                        case 'f': {
                            out[outLen++] = 12;
                            break;
                        }
                        case 'b': {
                            out[outLen++] = 8;
                            break;
                        }
                        case '\"': {
                            out[outLen++] = 34;
                            break;
                        }
                        case '\'': {
                            out[outLen++] = 39;
                            break;
                        }
                        case '\\': {
                            out[outLen++] = 92;
                            break;
                        }
                        default: {
                            if (errorMessage == null) {
                                errorMessage = this.getInvalidEscapeSequenceMessage();
                                errorIndex = off - 2;
                                errorLength = 2;
                            }
                            out[outLen++] = aChar;
                            break;
                        }
                    }
                    continue;
                }
                if (errorMessage == null) {
                    errorMessage = this.getInvalidEscapeSequenceMessage();
                    errorIndex = off - 1;
                    errorLength = 1;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        if (off < end) {
            if (off != end - 1) {
                throw new IllegalStateException();
            }
            aChar = in[off];
            if (in[0] != in[off]) {
                out[outLen++] = aChar;
                if (errorMessage == null) {
                    if (in[off] == '\\') {
                        errorMessage = this.getInvalidEscapeSequenceMessage();
                        errorIndex = off;
                        errorLength = 1;
                    } else {
                        errorMessage = this.getStringNotClosedMessage();
                    }
                } else {
                    errorMessage = this.getStringNotClosedMessage();
                    errorIndex = -1;
                    errorLength = -1;
                }
            }
        }
        if (errorMessage != null) {
            throw new ValueConverterWithValueException(errorMessage, node, new String(out, 0, outLen), errorIndex, errorLength, null);
        }
        return new String(out, 0, outLen);
    }

    protected String getInvalidEscapeSequenceMessage() {
        return "Invalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ )";
    }

    protected String getStringNotClosedMessage() {
        return "String literal is not properly closed";
    }

    protected boolean isHexSequence(char[] in, int off, int chars) {
        int i = off;
        while (i < in.length && i < off + chars) {
            char c = in[i];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

