/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={ExtendedObjectSupplier.class}, property={"dependency.injection.annotation:String=org.eclipse.fx.core.adapter.Adapt"})
public class AdaptValueSupplier
extends ExtendedObjectSupplier {
    public Object get(IObjectDescriptor descriptor, final IRequestor requestor, boolean track, boolean group) {
        Requestor r = (Requestor)requestor;
        Class<?> desiredClass = AdaptValueSupplier.getDesiredClass(descriptor.getDesiredType());
        if (desiredClass == null) {
            return IInjector.NOT_A_VALUE;
        }
        final String key = descriptor.hasQualifier(Named.class) ? ((Named)descriptor.getQualifier(Named.class)).value() : desiredClass.getName();
        final AtomicInteger i = new AtomicInteger();
        final AtomicReference<Object> ref = new AtomicReference<Object>();
        final Dummy dummy = (Dummy)r.getInjector().make(Dummy.class, r.getPrimarySupplier());
        if (track) {
            dummy.context.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    if (i.getAndIncrement() == 1) {
                        requestor.resolveArguments(false);
                        requestor.execute();
                        return false;
                    }
                    ref.set(dummy.context.get(key));
                    return true;
                }
            });
        } else {
            ref.set(dummy.context.get(key));
        }
        if (ref.get() != null && dummy.adapterService.canAdapt(ref.get(), desiredClass)) {
            return dummy.adapterService.adapt(ref.get(), desiredClass, new AdapterService.ValueAccess[]{new ValueAccessImpl(dummy.context)});
        }
        return IInjector.NOT_A_VALUE;
    }

    private static @Nullable Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    static class Dummy {
        public AdapterService adapterService;
        public final IEclipseContext context;

        @Inject
        public Dummy(IEclipseContext context, AdapterService adapterService) {
            this.context = context;
            this.adapterService = adapterService;
        }
    }

    static class ValueAccessImpl
    implements AdapterService.ValueAccess {
        private final IEclipseContext context;

        public ValueAccessImpl(IEclipseContext context) {
            this.context = context;
        }

        public <O> O getValue(String key) {
            return (O)this.context.get(key);
        }

        public <O> O getValue(Class<O> key) {
            return (O)this.context.get(key);
        }
    }
}

