/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

public class CancelableDiagnostician
extends Diagnostician {
    public static final String CANCEL_INDICATOR = CancelableDiagnostician.class + ".CANCEL_INDICATOR";
    @Inject
    private OperationCanceledManager operationCanceledManager;

    @Inject
    public CancelableDiagnostician(EValidator.Registry registry) {
        super(registry);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.checkCanceled(context);
        return super.validate(eObject, diagnostics, context);
    }

    protected void checkCanceled(Map<Object, Object> context) {
        this.operationCanceledManager.checkCanceled(this.getCancelIndicator(context));
    }

    @Deprecated
    protected boolean isCanceled(Map<Object, Object> context) {
        CancelIndicator indicator = this.getCancelIndicator(context);
        return indicator != null && indicator.isCanceled();
    }

    protected CancelIndicator getCancelIndicator(Map<Object, Object> context) {
        return context != null ? (CancelIndicator)context.get(CANCEL_INDICATOR) : null;
    }

    protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.checkCanceled(context);
        return super.doValidateContents(eObject, diagnostics, context);
    }
}

