/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import java.util.Collection;
import java.util.Stack;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.PopupWindow;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistant;
import org.eclipse.fx.text.ui.contentassist.IContentAssistListener;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.contentassist.IContextInformationPresenter;
import org.eclipse.fx.text.ui.contentassist.IContextInformationValidator;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;

class ContextInformationPopup
implements IContentAssistListener {
    private ITextViewer fViewer;
    private ContentAssistant fContentAssistant;
    private PopupWindow fContextSelectorStage;
    private IContextInformation[] fContextSelectorInput;
    private String fLineDelimiter = null;
    private PopupWindow fContextInfoPopup;
    private BorderPane fRoot;
    private Label fContent;
    private Stack<ContextFrame> fContextFrameStack = new Stack();
    private ContextFrame fLastContext = null;

    public ContextInformationPopup(ContentAssistant contentAssistant, ITextViewer viewer) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = viewer;
        this.fContextInfoPopup = new PopupWindow(){};
        this.fContextInfoPopup.setAutoFix(false);
        this.fContextInfoPopup.setAutoHide(false);
        viewer.getTextWidget().sceneProperty().addListener(e -> {
            if (viewer.getTextWidget().getScene() != null) {
                this.fContextInfoPopup.getScene().getStylesheets().setAll((Collection)viewer.getTextWidget().getScene().getStylesheets());
            }
        });
        this.fRoot = new BorderPane();
        this.fRoot.getStyleClass().add((Object)"styled-text-hover");
        this.fContent = new Label();
        this.fRoot.setCenter((Node)this.fContent);
        this.fContent.getStyleClass().add((Object)"styled-text-hover-text");
        this.fContextInfoPopup.getScene().setRoot((Parent)this.fRoot);
    }

    public String showContextProposals(boolean autoActivated) {
        System.err.println("showContextProposals(" + autoActivated + ") (TODO)");
        return "TODO";
    }

    public void showContextInformation(IContextInformation info, int offset) {
        if (info != null && info.getInformationDisplayString() != null && !info.getInformationDisplayString().isEmpty()) {
            this.fContent.setText(info.getInformationDisplayString());
            Point2D locationAtOffset = this.fViewer.getTextWidget().getLocationAtOffset(offset);
            locationAtOffset = this.fViewer.getTextWidget().localToScreen(locationAtOffset);
            if (locationAtOffset != null) {
                this.fContextInfoPopup.show(this.fViewer.getTextWidget().getScene().getWindow(), locationAtOffset.getX(), locationAtOffset.getY());
            }
        } else {
            this.fContextInfoPopup.hide();
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent event) {
        return false;
    }

    static class ContextFrame {
        final int fBeginOffset;
        final int fOffset;
        final int fVisibleOffset;
        final IContextInformation fInformation;
        final IContextInformationValidator fValidator;
        final IContextInformationPresenter fPresenter;

        public ContextFrame(IContextInformation information, int beginOffset, int offset, int visibleOffset, IContextInformationValidator validator, IContextInformationPresenter presenter) {
            this.fInformation = information;
            this.fBeginOffset = beginOffset;
            this.fOffset = offset;
            this.fVisibleOffset = visibleOffset;
            this.fValidator = validator;
            this.fPresenter = presenter;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextFrame) {
                ContextFrame frame = (ContextFrame)obj;
                return this.fInformation.equals(frame.fInformation) && this.fBeginOffset == frame.fBeginOffset;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.fInformation.hashCode() << 16 | this.fBeginOffset;
        }
    }
}

