/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.source;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.text.SourceTextEditActions;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.ui.TextViewer;
import org.eclipse.fx.text.ui.contentassist.IContentAssistant;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.internal.AnnotationModelSupport;
import org.eclipse.fx.text.ui.internal.WrappedLineRulerAnnotationPresenter;
import org.eclipse.fx.text.ui.internal.WrappedTextAnnotationPresenter;
import org.eclipse.fx.text.ui.presentation.IPresentationReconciler;
import org.eclipse.fx.text.ui.reconciler.IReconciler;
import org.eclipse.fx.text.ui.source.ILineRulerAnnotationPresenter;
import org.eclipse.fx.text.ui.source.ISourceViewer;
import org.eclipse.fx.text.ui.source.ISourceViewerExtension;
import org.eclipse.fx.text.ui.source.ISourceViewerExtension2;
import org.eclipse.fx.text.ui.source.ISourceViewerExtension3;
import org.eclipse.fx.text.ui.source.ISourceViewerExtension4;
import org.eclipse.fx.text.ui.source.ITextAnnotationPresenter;
import org.eclipse.fx.text.ui.source.SourceViewerConfiguration;
import org.eclipse.fx.ui.controls.styledtext.TriggerActionMapping;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;

public class SourceViewer
extends TextViewer
implements ISourceViewer,
ISourceViewerExtension,
ISourceViewerExtension2,
ISourceViewerExtension3,
ISourceViewerExtension4 {
    private IPresentationReconciler fPresentationReconciler;
    private IReconciler fReconciler;
    private IAnnotationModel fVisualAnnotationModel;
    protected static final Object MODEL_ANNOTATION_MODEL = new Object();
    private Annotation fRangeIndicator;
    private final TriggerActionMapping actionMapping = new TriggerActionMapping();
    private BiFunction<IDocument, Integer, Set<HoverInfo>> documentHoverInfoLookup = null;
    private Function<Annotation, Set<HoverInfo>> annotationHoverInfoLookup = null;
    private IContentAssistant assistant;

    private void initSourceViewerActionMapping() {
        this.actionMapping.map("Ctrl+Space", (TextEditAction)SourceTextEditActions.PROPOSAL_REQUEST);
        super.getActionMapping().setOverride(this.actionMapping);
    }

    @Override
    public Subscription subscribeAction(BiFunction<TextEditAction, TriggerActionMapping.Context, Boolean> handler) {
        return this.actionMapping.subscribe(handler);
    }

    @Override
    public void configure(SourceViewerConfiguration configuration) {
        IContentAssistant assist;
        if (this.getTextWidget() == null) {
            return;
        }
        this.initSourceViewerActionMapping();
        this.actionMapping.setOverride(configuration.getOverrideMapping());
        if (configuration.getFeatures() != null) {
            this.getFeatures().bind(configuration.getFeatures());
        }
        this.setUndoManager(configuration.getUndoManager(this));
        this.getTextWidget().getStyleClass().add((Object)configuration.getStyleclassName());
        this.documentHoverInfoLookup = configuration::getDocumentHoverInfo;
        this.annotationHoverInfoLookup = configuration::getAnnotationHoverInfo;
        this.setDocumentPartitioning(configuration.getConfiguredDocumentPartitioning(this));
        this.fPresentationReconciler = configuration.getPresentationReconciler(this);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install(this);
        }
        this.fReconciler = configuration.getReconciler(this);
        if (this.fReconciler != null) {
            this.fReconciler.install(this);
        }
        if ((assist = configuration.getContentAssist()) != null) {
            assist.install(this);
        }
        if (configuration.getAnnotationPresenter() != null) {
            configuration.getAnnotationPresenter().getLineRulerAnnotationPresenter().forEach(p -> this.getTextWidget().getAnnotationPresenter().add((Object)new WrappedLineRulerAnnotationPresenter((ILineRulerAnnotationPresenter)p)));
            configuration.getAnnotationPresenter().getTextAnnotationPresenter().forEach(p -> this.getTextWidget().getAnnotationPresenter().add((Object)new WrappedTextAnnotationPresenter((ITextAnnotationPresenter)p)));
        }
        String[] types = configuration.getConfiguredContentTypes(this);
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            this.setTextHover(configuration.getTextHover(this, t), t, 255);
            ++i;
        }
        IAnnotationModel annotationModel = configuration.getAnnotationModel();
        if (annotationModel != null) {
            AnnotationModelSupport support = new AnnotationModelSupport(annotationModel, this.getTextWidget());
            support.install();
        }
        this.getTextWidget().setQuickLinkCallback(configuration.getQuicklinkCallback());
        this.assistant = configuration.getContentAssist();
    }

    @Override
    public Set<HoverInfo> getHoverInfo(int offset) {
        if (this.documentHoverInfoLookup != null) {
            return this.documentHoverInfoLookup.apply(this.getDocument(), offset);
        }
        return super.getHoverInfo(offset);
    }

    @Override
    public Set<HoverInfo> getHoverInfo(Annotation annotation) {
        if (this.annotationHoverInfoLookup != null) {
            return this.annotationHoverInfoLookup.apply(annotation);
        }
        return super.getHoverInfo(annotation);
    }

    protected void disposeVisualAnnotationModel() {
        if (this.fVisualAnnotationModel != null) {
            if (this.getDocument() != null) {
                this.fVisualAnnotationModel.disconnect(this.getDocument());
            }
            if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fVisualAnnotationModel).removeAnnotationModel(MODEL_ANNOTATION_MODEL);
            }
            this.fVisualAnnotationModel = null;
        }
    }

    protected IAnnotationModel createVisualAnnotationModel(IAnnotationModel annotationModel) {
        AnnotationModel model = new AnnotationModel();
        model.addAnnotationModel(MODEL_ANNOTATION_MODEL, annotationModel);
        return (IAnnotationModel)model;
    }

    @Override
    public void setDocument(IDocument document, IAnnotationModel annotationModel) {
        this.setDocument(document, annotationModel, -1, -1);
    }

    @Override
    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        this.disposeVisualAnnotationModel();
        if (annotationModel != null && document != null) {
            this.fVisualAnnotationModel = this.createVisualAnnotationModel(annotationModel);
            if (annotationModel instanceof ISynchronizable && this.fVisualAnnotationModel instanceof ISynchronizable) {
                ISynchronizable sync = (ISynchronizable)this.fVisualAnnotationModel;
                sync.setLockObject(((ISynchronizable)annotationModel).getLockObject());
            }
            this.fVisualAnnotationModel.connect(document);
        }
        if (modelRangeOffset == -1 && modelRangeLength == -1) {
            super.setDocument(document);
        } else {
            super.setDocument(document, modelRangeOffset, modelRangeLength);
        }
    }

    @Override
    public IAnnotationModel getAnnotationModel() {
        if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension extension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            return extension.getAnnotationModel(MODEL_ANNOTATION_MODEL);
        }
        return null;
    }

    @Override
    public IAnnotationModel getVisualAnnotationModel() {
        return this.fVisualAnnotationModel;
    }

    public void setRangeIndicator(Annotation rangeIndicator) {
        this.fRangeIndicator = rangeIndicator;
    }

    public IRegion getRangeIndication() {
        Position position;
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null && (position = this.fVisualAnnotationModel.getPosition(this.fRangeIndicator)) != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    public void showContextInformation(IContextInformation ci) {
        this.assistant.showContextInformation(ci);
    }
}

