/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane.skin;

import com.sun.javafx.scene.control.skin.TabPaneSkin;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.controls.tabpane.GenericTab;
import org.eclipse.fx.ui.controls.tabpane.skin.FXTabWrapper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DnDTabPaneSkin
extends TabPaneSkin
implements DndTabPaneFactory.DragSetup {
    private static Tab DRAGGED_TAB;
    public static final DataFormat TAB_MOVE;
    private Object noneEnum;
    private StyleableProperty<Object> openAnimation;
    private StyleableProperty<Object> closeAnimation;
    private @Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction;
    private @Nullable Consumer<@NonNull GenericTab> dragFinishedConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer;
    private @Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction;

    static {
        TAB_MOVE = new DataFormat(new String[]{"DnDTabPane:tabMove"});
    }

    public DnDTabPaneSkin(TabPane tabPane) {
        super(tabPane);
        this.hookTabFolderSkin();
    }

    private void hookTabFolderSkin() {
        block7: {
            try {
                Field f_tabHeaderArea = TabPaneSkin.class.getDeclaredField("tabHeaderArea");
                f_tabHeaderArea.setAccessible(true);
                StackPane tabHeaderArea = (StackPane)f_tabHeaderArea.get(this);
                tabHeaderArea.setOnDragOver(e -> e.consume());
                Field f_headersRegion = tabHeaderArea.getClass().getDeclaredField("headersRegion");
                f_headersRegion.setAccessible(true);
                StackPane headersRegion = (StackPane)f_headersRegion.get(tabHeaderArea);
                EventHandler handler = this::tabPane_handleDragStart;
                EventHandler handlerFinished = this::tabPane_handleDragDone;
                for (Node tabHeaderSkin : headersRegion.getChildren()) {
                    tabHeaderSkin.addEventHandler(MouseEvent.DRAG_DETECTED, handler);
                    tabHeaderSkin.addEventHandler(DragEvent.DRAG_DONE, handlerFinished);
                }
                headersRegion.getChildren().addListener(change -> {
                    while (change.next()) {
                        if (change.wasRemoved()) {
                            change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.DRAG_DETECTED, handler));
                            change.getRemoved().forEach(e -> e.removeEventHandler(DragEvent.DRAG_DONE, handlerFinished));
                        }
                        if (!change.wasAdded()) continue;
                        change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.DRAG_DETECTED, handler));
                        change.getAddedSubList().forEach(e -> e.addEventHandler(DragEvent.DRAG_DONE, handlerFinished));
                    }
                });
                tabHeaderArea.addEventHandler(DragEvent.DRAG_OVER, arg_0 -> this.lambda$2((Pane)tabHeaderArea, (Pane)headersRegion, arg_0));
                tabHeaderArea.addEventHandler(DragEvent.DRAG_DROPPED, arg_0 -> this.lambda$3((Pane)tabHeaderArea, (Pane)headersRegion, arg_0));
                tabHeaderArea.addEventHandler(DragEvent.DRAG_EXITED, this::tabPane_handleDragDone);
                Field field = TabPaneSkin.class.getDeclaredField("openTabAnimation");
                field.setAccessible(true);
                this.openAnimation = (StyleableProperty)field.get(this);
                field = TabPaneSkin.class.getDeclaredField("closeTabAnimation");
                field.setAccessible(true);
                this.closeAnimation = (StyleableProperty)field.get(this);
                Class<?>[] classArray = this.getClass().getDeclaredClasses();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> cl = classArray[n2];
                    if ("TabAnimation".equals(cl.getSimpleName())) {
                        Enum[] enumArray = (Enum[])cl.getEnumConstants();
                        int n3 = enumArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Enum enumConstant = enumArray[n4];
                            if ("NONE".equals(enumConstant.name())) {
                                this.noneEnum = enumConstant;
                                break block7;
                            }
                            ++n4;
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    void tabPane_handleDragStart(MouseEvent event) {
        try {
            Field f_tab = event.getSource().getClass().getDeclaredField("tab");
            f_tab.setAccessible(true);
            Tab t = (Tab)f_tab.get(event.getSource());
            if (t != null && this.efx_canStartDrag(FXTabWrapper.wrap(t))) {
                DRAGGED_TAB = t;
                Node node = (Node)event.getSource();
                Dragboard db = node.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                WritableImage snapShot = node.snapshot(new SnapshotParameters(), null);
                PixelReader reader = snapShot.getPixelReader();
                int padX = 10;
                int padY = 10;
                int width = (int)snapShot.getWidth();
                int height = (int)snapShot.getHeight();
                WritableImage image = new WritableImage(width + padX, height + padY);
                PixelWriter writer = image.getPixelWriter();
                int h = 0;
                int v = 0;
                while (h < width + padX) {
                    v = 0;
                    while (v < height + padY) {
                        if (h >= padX && h <= width + padX && v >= padY && v <= height + padY) {
                            writer.setColor(h, v, reader.getColor(h - padX, v - padY));
                        } else {
                            writer.setColor(h, v, Color.TRANSPARENT);
                        }
                        ++v;
                    }
                    ++h;
                }
                db.setDragView((Image)image, image.getWidth(), image.getHeight() * -1.0);
                ClipboardContent content = new ClipboardContent();
                String data = this.efx_getClipboardContent(FXTabWrapper.wrap(t));
                if (data != null) {
                    content.put((Object)TAB_MOVE, (Object)data);
                }
                db.setContent((Map)content);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void tabPane_handleDragOver(Pane tabHeaderArea, Pane headersRegion, DragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        event.consume();
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Object referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            try {
                int idx;
                Field field = referenceNode.getClass().getDeclaredField("tab");
                field.setAccessible(true);
                Tab tab = (Tab)field.get(referenceNode);
                boolean noMove = false;
                if (tab == draggedTab) {
                    noMove = true;
                } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                    idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                    if (idx > 0 && ((TabPane)this.getSkinnable()).getTabs().get(idx - 1) == draggedTab) {
                        noMove = true;
                    }
                } else {
                    idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                    if (idx + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(idx + 1) == draggedTab) {
                        noMove = true;
                    }
                }
                if (noMove) {
                    this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
                    return;
                }
                Bounds b = referenceNode.getBoundsInLocal();
                b = referenceNode.localToScene(b);
                b = ((TabPane)this.getSkinnable()).sceneToLocal(b);
                this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), b, type);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        } else {
            this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
        }
    }

    void tabPane_handleDragDropped(Pane tabHeaderArea, Pane headersRegion, DragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Object referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            block18: {
                try {
                    int idx;
                    Field field = referenceNode.getClass().getDeclaredField("tab");
                    field.setAccessible(true);
                    Tab tab = (Tab)field.get(referenceNode);
                    boolean noMove = false;
                    if (tab == null) {
                        event.setDropCompleted(false);
                        return;
                    }
                    if (tab == draggedTab) {
                        noMove = true;
                    } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                        idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                        if (idx > 0 && ((TabPane)this.getSkinnable()).getTabs().get(idx - 1) == draggedTab) {
                            noMove = true;
                        }
                    } else {
                        idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                        if (idx + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(idx + 1) == draggedTab) {
                            noMove = true;
                        }
                    }
                    if (!noMove) {
                        StyleOrigin openOrigin = this.openAnimation.getStyleOrigin();
                        StyleOrigin closeOrigin = this.closeAnimation.getStyleOrigin();
                        Object openValue = this.openAnimation.getValue();
                        Object closeValue = this.closeAnimation.getValue();
                        try {
                            this.openAnimation.setValue(this.noneEnum);
                            this.closeAnimation.setValue(this.noneEnum);
                            this.efx_dropped(event.getScreenX(), event.getScreenY(), FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), type);
                            event.setDropCompleted(true);
                            break block18;
                        }
                        finally {
                            this.openAnimation.applyStyle(openOrigin, openValue);
                            this.closeAnimation.applyStyle(closeOrigin, closeValue);
                        }
                    }
                    event.setDropCompleted(false);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            event.consume();
        }
    }

    void tabPane_handleDragDone(DragEvent event) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        this.efx_dragFinished(FXTabWrapper.wrap(tab));
    }

    @Override
    public void setClipboardDataFunction(@Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction) {
        this.clipboardDataFunction = clipboardDataFunction;
    }

    @Override
    public void setStartFunction(@Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction) {
        this.startFunction = startFunction;
    }

    @Override
    public void setDragFinishedConsumer(@Nullable Consumer<@NonNull GenericTab> dragFinishedConsumer) {
        this.dragFinishedConsumer = dragFinishedConsumer;
    }

    @Override
    public void setFeedbackConsumer(@Nullable Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer) {
        this.feedbackConsumer = feedbackConsumer;
    }

    @Override
    public void setDropConsumer(@Nullable Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer) {
        this.dropConsumer = dropConsumer;
    }

    private boolean efx_canStartDrag(@NonNull GenericTab tab) {
        if (this.startFunction != null) {
            return this.startFunction.apply(tab);
        }
        return true;
    }

    private void efx_dragFeedback(@NonNull GenericTab draggedTab, GenericTab targetTab, Bounds bounds,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.feedbackConsumer != null) {
            this.feedbackConsumer.accept(new DndTabPaneFactory.FeedbackData(draggedTab, targetTab, bounds, dropType));
        }
    }

    private void efx_dropped(double x, double y, @NonNull GenericTab draggedTab, @NonNull GenericTab targetTab,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.dropConsumer != null) {
            this.dropConsumer.accept(new DndTabPaneFactory.DroppedData(x, y, draggedTab, targetTab, dropType));
        }
    }

    private void efx_dragFinished(@NonNull GenericTab tab) {
        if (this.dragFinishedConsumer != null) {
            this.dragFinishedConsumer.accept(tab);
        }
    }

    private String efx_getClipboardContent(@NonNull GenericTab t) {
        if (this.clipboardDataFunction != null) {
            return this.clipboardDataFunction.apply(t);
        }
        return String.valueOf(System.identityHashCode(t));
    }

    private /* synthetic */ void lambda$2(Pane pane, Pane pane2, DragEvent e) {
        this.tabPane_handleDragOver(pane, pane2, e);
    }

    private /* synthetic */ void lambda$3(Pane pane, Pane pane2, DragEvent e) {
        this.tabPane_handleDragDropped(pane, pane2, e);
    }
}

