/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AutomaticModuleNaming;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class InternalModuleSupport {
    private static final Logger log = LoggerFactory.getLogger(InternalModuleSupport.class);

    InternalModuleSupport() {
    }

    public static void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        if (javaProject == null || !javaProject.exists()) {
            return;
        }
        IModuleDescription moduleDescription = javaProject.getModuleDescription();
        if (!(moduleDescription instanceof AbstractModule)) {
            return;
        }
        AbstractModule module = (AbstractModule)moduleDescription;
        Set requiredModules = Stream.of(module.getRequiredModules()).map(m -> new String(m.name())).collect(Collectors.toSet());
        for (IClasspathEntryDescriptor entry : classpath.getEntryDescriptors()) {
            String moduleName = InternalModuleSupport.getModuleName(entry, monitor);
            if (!requiredModules.contains(moduleName)) continue;
            entry.setClasspathAttribute("module", Boolean.TRUE.toString());
        }
    }

    private static String getModuleName(IClasspathEntryDescriptor entry, IProgressMonitor monitor) {
        String module = null;
        if (1 == entry.getEntryKind()) {
            module = InternalModuleSupport.getModuleNameFromJar(entry.getPath().toFile());
        } else if (2 == entry.getEntryKind()) {
            module = InternalModuleSupport.getModuleNameFromProject(entry.getPath(), monitor);
        }
        return module;
    }

    private static String getModuleNameFromProject(IPath projectPath, IProgressMonitor monitor) {
        IJavaProject project = InternalModuleSupport.getJavaProject(projectPath);
        String module = null;
        if (project != null) {
            try {
                if (project.getModuleDescription() == null) {
                    MavenProject mavenProject;
                    String buildName = null;
                    IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project.getProject());
                    if (facade != null && (mavenProject = facade.getMavenProject(monitor)) != null) {
                        buildName = mavenProject.getBuild().getFinalName();
                    }
                    if (buildName == null || buildName.isEmpty()) {
                        buildName = project.getElementName();
                    }
                    module = new String(AutomaticModuleNaming.determineAutomaticModuleName((String)buildName, (boolean)false, null));
                } else {
                    module = project.getModuleDescription().getElementName();
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return module;
    }

    private static IJavaProject getJavaProject(IPath projectPath) {
        if (projectPath == null || projectPath.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectPath.lastSegment());
        if (project.isAccessible()) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    private static String getModuleNameFromJar(File file) {
        if (!file.isFile()) {
            return null;
        }
        char[] moduleName = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                IBinaryModule module = null;
                ClassFileReader reader = ClassFileReader.read((ZipFile)zipFile, (String)"module-info.class");
                if (reader != null && (module = reader.getModuleDeclaration()) != null) {
                    moduleName = module.name();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException ex) {
            log.error(ex.getMessage(), ex);
        }
        if (moduleName == null) {
            moduleName = AutomaticModuleNaming.determineAutomaticModuleName((String)file.getAbsolutePath());
        }
        return new String(moduleName);
    }
}

