/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.log;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface Logger {
    public void log(@NonNull Level var1, @NonNull String var2);

    default public void log(@NonNull Level level, @NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(level)) {
            this.log(level, messageSupplier.get());
        }
    }

    default public <T> @Nullable T log(@NonNull Level level, @Nullable T value, Function<@Nullable T, @NonNull String> messageCreator) {
        if (this.isEnabled(level)) {
            this.log(level, messageCreator.apply(value));
        }
        return value;
    }

    public void log(@NonNull Level var1, @NonNull String var2, @NonNull Throwable var3);

    default public void log(@NonNull Level level, @NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(level)) {
            this.log(level, messageSupplier.get(), t);
        }
    }

    default public <T> @Nullable T log(@NonNull Level level, @Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator, @NonNull Throwable t) {
        if (this.isEnabled(level)) {
            this.log(level, messageCreator.apply(value), t);
        }
        return value;
    }

    public void logf(@NonNull Level var1, @NonNull String var2, Object ... var3);

    public void logf(@NonNull Level var1, @NonNull String var2, @NonNull Throwable var3, Object ... var4);

    public void trace(@NonNull String var1);

    default public void trace(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.TRACE)) {
            this.trace(messageSupplier.get());
        }
    }

    default public <T> @Nullable T trace(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator) {
        if (this.isEnabled(Level.TRACE)) {
            this.trace(messageCreator.apply(value));
        }
        return value;
    }

    public void debug(@NonNull String var1);

    default public void debug(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.DEBUG)) {
            this.debug(messageSupplier.get());
        }
    }

    default public <T> @Nullable T debug(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator) {
        if (this.isEnabled(Level.DEBUG)) {
            this.debug(messageCreator.apply(value));
        }
        return value;
    }

    public void info(@NonNull String var1);

    default public void info(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageSupplier.get());
        }
    }

    default public <T> @Nullable T info(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageCreator.apply(value));
        }
        return value;
    }

    public void warning(@NonNull String var1);

    default public void warning(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.WARNING)) {
            this.warning(messageSupplier.get());
        }
    }

    default public <T> @Nullable T warning(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator) {
        if (this.isEnabled(Level.WARNING)) {
            this.warning(messageCreator.apply(value));
        }
        return value;
    }

    public void error(@NonNull String var1);

    default public void error(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageSupplier.get());
        }
    }

    default public <T> @Nullable T error(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageCreator.apply(value));
        }
        return value;
    }

    public void fatal(@NonNull String var1);

    default public void fatal(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.FATAL)) {
            this.fatal(messageSupplier.get());
        }
    }

    default public <T> @Nullable T fatal(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator) {
        if (this.isEnabled(Level.FATAL)) {
            this.fatal(messageCreator.apply(value));
        }
        return value;
    }

    public void trace(@NonNull String var1, @NonNull Throwable var2);

    default public void trace(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.TRACE)) {
            this.trace(messageSupplier.get(), t);
        }
    }

    default public <T> @Nullable T trace(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator, @NonNull Throwable t) {
        if (this.isEnabled(Level.TRACE)) {
            this.trace(messageCreator.apply(value), t);
        }
        return value;
    }

    public void debug(@NonNull String var1, @NonNull Throwable var2);

    default public void debug(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.DEBUG)) {
            this.debug(messageSupplier.get(), t);
        }
    }

    default public <T> @Nullable T debug(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator, @NonNull Throwable t) {
        if (this.isEnabled(Level.DEBUG)) {
            this.debug(messageCreator.apply(value), t);
        }
        return value;
    }

    public void info(@NonNull String var1, @NonNull Throwable var2);

    default public void info(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageSupplier.get(), t);
        }
    }

    default public <T> @Nullable T info(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator, @NonNull Throwable t) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageCreator.apply(value), t);
        }
        return value;
    }

    public void warning(@NonNull String var1, @NonNull Throwable var2);

    default public void warning(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.WARNING)) {
            this.warning(messageSupplier.get(), t);
        }
    }

    default public <T> @Nullable T warning(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator, @NonNull Throwable t) {
        if (this.isEnabled(Level.WARNING)) {
            this.warning(messageCreator.apply(value), t);
        }
        return value;
    }

    public void error(@NonNull String var1, @NonNull Throwable var2);

    default public void error(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageSupplier.get(), t);
        }
    }

    default public <T> @Nullable T error(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator, @NonNull Throwable t) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageCreator.apply(value), t);
        }
        return value;
    }

    public void fatal(@NonNull String var1, @NonNull Throwable var2);

    default public void fatal(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.FATAL)) {
            this.fatal(messageSupplier.get(), t);
        }
    }

    default public <T> @Nullable T fatal(@Nullable T value, @NonNull Function<@Nullable T, @NonNull String> messageCreator, @NonNull Throwable t) {
        if (this.isEnabled(Level.FATAL)) {
            this.fatal(messageCreator.apply(value), t);
        }
        return value;
    }

    public void tracef(@NonNull String var1, Object ... var2);

    public void debugf(@NonNull String var1, Object ... var2);

    public void infof(@NonNull String var1, Object ... var2);

    public void warningf(@NonNull String var1, Object ... var2);

    public void errorf(@NonNull String var1, Object ... var2);

    public void fatalf(@NonNull String var1, Object ... var2);

    public void tracef(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void debugf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void infof(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void warningf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void errorf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void fatalf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public boolean isEnabled(Level var1);

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

