/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.dnd;

import java.util.Collection;
import java.util.function.Consumer;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.eclipse.fx.core.SystemUtils;

public class EFXDragEvent
extends Event {
    private static Object DRAGGED_CONTENT = null;
    private static DragFeedback DRAG_FEEDBACK = null;
    private static final long serialVersionUID = 1L;
    public static final EventType<EFXDragEvent> ANY = new EventType(Event.ANY, "DRAG");
    public static EventType<EFXDragEvent> DRAG_START = new EventType(Event.ANY, "DRAG_START");
    public static EventType<EFXDragEvent> DRAG_OVER = new EventType(ANY, "DRAG_OVER");
    public static final EventType<EFXDragEvent> DRAG_DROPPED = new EventType(ANY, "DRAG_DROPPED");
    public static final EventType<EFXDragEvent> DRAG_EXITED = new EventType(ANY, "DRAG_EXITED");
    public static final EventType<EFXDragEvent> DRAG_DONE = new EventType(ANY, "DRAG_DONE");
    private final double screenX;
    private final double screenY;
    private final State state = new State();

    public EFXDragEvent(Object source, EventTarget target, EventType<? extends Event> eventType, double screenX, double screenY, boolean complete) {
        super(source, target, eventType);
        this.screenX = screenX;
        this.screenY = screenY;
        this.state.complete = complete;
        if (eventType == DRAG_START) {
            DRAGGED_CONTENT = null;
            if (this.canShowFeedbackDragFeedback()) {
                DRAG_FEEDBACK = SystemUtils.isMacOS() ? new DragFeedbackStage((Node)source) : new DragFeedbackPopup((Node)source);
            }
        } else if (eventType == DRAG_DONE && DRAG_FEEDBACK != null) {
            DRAG_FEEDBACK.dispose();
            DRAG_FEEDBACK = null;
        }
        if (DRAG_FEEDBACK != null) {
            DRAG_FEEDBACK.updateCoordinates(screenX, screenY);
        }
    }

    public void updateFeedback(Consumer<StackPane> consumer) {
        if (DRAG_FEEDBACK != null) {
            DRAG_FEEDBACK.updateFeedback(consumer);
        }
    }

    public static void updateFeedbackLocation(double screenX, double screenY) {
        if (DRAG_FEEDBACK != null) {
            DRAG_FEEDBACK.updateCoordinates(screenX, screenY);
        }
    }

    public double getScreenX() {
        return this.screenX;
    }

    public double getScreenY() {
        return this.screenY;
    }

    public double getX() {
        return ((Node)this.getSource()).screenToLocal(this.screenX, this.screenY).getX();
    }

    public double getY() {
        return ((Node)this.getSource()).screenToLocal(this.screenX, this.screenY).getY();
    }

    public void setDraggedContent(Object content) {
        if (this.getEventType() == DRAG_START) {
            DRAGGED_CONTENT = content;
        }
    }

    public Object getDraggedContent() {
        return DRAGGED_CONTENT;
    }

    public void setComplete(boolean complete) {
        if (this.getEventType() == DRAG_DROPPED) {
            this.state.complete = complete;
        }
    }

    public boolean isComplete() {
        return this.state.complete;
    }

    public boolean canShowFeedbackDragFeedback() {
        return !"Linux".equals(System.getProperty("os.name"));
    }

    static abstract class DragFeedback {
        DragFeedback() {
        }

        public abstract void dispose();

        public abstract void updateCoordinates(double var1, double var3);

        public abstract void updateFeedback(Consumer<StackPane> var1);
    }

    static class DragFeedbackPopup
    extends DragFeedback {
        PopupWindow popupWindow;
        double screenX;
        double screenY;
        Node n;

        public DragFeedbackPopup(Node n) {
            this.n = n;
            this.popupWindow = new PopupWindow(){};
            this.popupWindow.setAutoFix(false);
            this.popupWindow.setUserData((Object)"findNodeExclude");
            StackPane root = new StackPane();
            root.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            this.popupWindow.getScene().getStylesheets().setAll((Collection)n.getScene().getStylesheets());
            this.popupWindow.getScene().setRoot((Parent)root);
        }

        @Override
        public void updateCoordinates(double screenX, double screenY) {
            this.popupWindow.setX(screenX - this.popupWindow.getWidth() / 2.0);
            this.popupWindow.setY(screenY + 20.0);
        }

        @Override
        public void updateFeedback(Consumer<StackPane> consumer) {
            consumer.accept((StackPane)this.popupWindow.getScene().getRoot());
            this.popupWindow.sizeToScene();
            this.popupWindow.setX(this.screenX - this.popupWindow.getWidth() / 2.0);
            this.popupWindow.setY(this.screenY + 20.0);
            this.popupWindow.show(this.n.getScene().getWindow());
        }

        @Override
        public void dispose() {
            this.popupWindow.hide();
        }
    }

    static class DragFeedbackStage
    extends DragFeedback {
        Stage popupWindow;
        double screenX;
        double screenY;
        Node n;

        public DragFeedbackStage(Node n) {
            this.n = n;
            this.popupWindow = new Stage();
            this.popupWindow.initStyle(StageStyle.TRANSPARENT);
            this.popupWindow.setUserData((Object)"findNodeExclude");
            this.popupWindow.setAlwaysOnTop(true);
            StackPane root = new StackPane();
            root.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            Scene value = new Scene((Parent)root);
            value.setFill((Paint)Color.TRANSPARENT);
            this.popupWindow.setScene(value);
            this.popupWindow.getScene().getStylesheets().setAll((Collection)n.getScene().getStylesheets());
            this.popupWindow.getScene().setRoot((Parent)root);
        }

        @Override
        public void updateCoordinates(double screenX, double screenY) {
            this.popupWindow.setX(screenX - this.popupWindow.getWidth() / 2.0);
            this.popupWindow.setY(screenY + 20.0);
        }

        @Override
        public void updateFeedback(Consumer<StackPane> consumer) {
            consumer.accept((StackPane)this.popupWindow.getScene().getRoot());
            this.popupWindow.sizeToScene();
            this.popupWindow.setX(this.screenX - this.popupWindow.getWidth() / 2.0);
            this.popupWindow.setY(this.screenY + 20.0);
            this.popupWindow.show();
        }

        @Override
        public void dispose() {
            this.popupWindow.hide();
        }
    }

    static class State {
        boolean complete = false;

        State() {
        }
    }
}

