/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.hover.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ListBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;

public class ResizeablePane
extends Region {
    private DoubleProperty resizeHandleSize = new SimpleStyleableDoubleProperty(RESIZE_HANDLE_SIZE, (Object)this, "resizeHandleSize", Double.valueOf(5.0));
    private static final CssMetaData<ResizeablePane, Number> RESIZE_HANDLE_SIZE = new CssMetaData<ResizeablePane, Number>("-efx-resize-handle-size", StyleConverter.getSizeConverter(), (Number)5.0){

        public boolean isSettable(ResizeablePane n) {
            return n.resizeHandleSize == null || !n.resizeHandleSize.isBound();
        }

        public StyleableDoubleProperty getStyleableProperty(ResizeablePane n) {
            return (StyleableDoubleProperty)n.resizeHandleSize;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private ObjectProperty<Node> contentProperty = new SimpleObjectProperty((Object)this, "content");
    private Node resizeWest;
    private Node resizeEast;
    private Node resizeSouth;
    private Node resizeNorth;
    private Node resizeNorthWest;
    private Node resizeNorthEast;
    private Node resizeSouthWest;
    private Node resizeSouthEast;
    private ObjectProperty<Window> windowProperty = new SimpleObjectProperty((Object)this, "window");
    private Handler handler = new Handler();

    static {
        ArrayList<CssMetaData<ResizeablePane, Number>> styleables = new ArrayList<CssMetaData<ResizeablePane, Number>>(Region.getClassCssMetaData());
        styleables.add(RESIZE_HANDLE_SIZE);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ResizeablePane.getClassCssMetaData();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.contentProperty;
    }

    public void setContent(Node node) {
        this.contentProperty().set((Object)node);
    }

    public Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public ResizeablePane() {
        this.initialize();
    }

    protected double computeMinWidth(double height) {
        return 2.0 * this.resizeHandleSize.get() + this.getContent().minWidth(height);
    }

    protected double computeMinHeight(double width) {
        return 2.0 * this.resizeHandleSize.get() + this.getContent().minHeight(width);
    }

    protected double computePrefHeight(double width) {
        return 2.0 * this.resizeHandleSize.get() + this.getContent().prefHeight(width);
    }

    protected double computePrefWidth(double height) {
        return 2.0 * this.resizeHandleSize.get() + this.getContent().prefWidth(height);
    }

    private Node createHandle(Cursor cursor) {
        Region handle = new Region();
        handle.setCursor(cursor);
        handle.setOnMousePressed((EventHandler)this.handler);
        handle.setOnMouseDragged((EventHandler)this.handler);
        handle.setOnMouseReleased((EventHandler)this.handler);
        return handle;
    }

    private void initialize() {
        this.getStyleClass().add((Object)"resize-popup-pane");
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)20, (int)20, (int)20, (double)0.7), new CornerRadii(this.resizeHandleSize.get()), Insets.EMPTY)}));
        this.resizeWest = this.createHandle(Cursor.W_RESIZE);
        this.resizeEast = this.createHandle(Cursor.E_RESIZE);
        this.resizeSouth = this.createHandle(Cursor.S_RESIZE);
        this.resizeNorth = this.createHandle(Cursor.N_RESIZE);
        this.resizeNorthWest = this.createHandle(Cursor.NW_RESIZE);
        this.resizeNorthEast = this.createHandle(Cursor.NE_RESIZE);
        this.resizeSouthWest = this.createHandle(Cursor.SW_RESIZE);
        this.resizeSouthEast = this.createHandle(Cursor.SE_RESIZE);
        ContentListBinding binding = new ContentListBinding();
        Bindings.bindContent((List)this.getChildren(), (ObservableList)binding);
    }

    public ObjectProperty<Window> windowProperty() {
        return this.windowProperty;
    }

    public void setWindow(Window window) {
        this.windowProperty().set((Object)window);
    }

    public Window getWindow() {
        return (Window)this.windowProperty().get();
    }

    private void resizeWindow(double x, double y, double width, double height) {
        this.getWindow().setX(x);
        this.getWindow().setY(y);
        this.setMinWidth(Math.max(this.computeMinWidth(height), width));
        this.setMinHeight(Math.max(this.computeMinHeight(width), height));
        this.setPrefWidth(width);
        this.setPrefHeight(height);
        this.setMaxWidth(width);
        this.setMaxHeight(height);
        this.getWindow().setWidth(width + 20.0);
        this.getWindow().setHeight(height + 20.0);
    }

    protected void layoutChildren() {
        double handleSize = this.resizeHandleSize.get();
        double width = this.getWidth();
        double height = this.getHeight();
        this.resizeWest.resizeRelocate(0.0, handleSize, handleSize, height - handleSize);
        this.resizeNorthWest.resizeRelocate(0.0, 0.0, handleSize, handleSize);
        this.resizeNorth.resizeRelocate(handleSize, 0.0, width - handleSize, handleSize);
        this.resizeNorthEast.resizeRelocate(width - handleSize, 0.0, handleSize, handleSize);
        this.resizeEast.resizeRelocate(width - handleSize, handleSize, handleSize, height - handleSize);
        this.resizeSouthEast.resizeRelocate(width - handleSize, height - handleSize, handleSize, handleSize);
        this.resizeSouth.resizeRelocate(handleSize, height - handleSize, width - handleSize, handleSize);
        this.resizeSouthWest.resizeRelocate(0.0, height - handleSize, handleSize, handleSize);
        Node center = (Node)this.contentProperty().get();
        if (center != null) {
            center.resizeRelocate(handleSize, handleSize, width - 2.0 * handleSize, height - 2.0 * handleSize);
        }
    }

    private class ContentListBinding
    extends ListBinding<Node> {
        public ContentListBinding() {
            this.bind(new Observable[]{ResizeablePane.this.contentProperty()});
        }

        protected ObservableList<Node> computeValue() {
            Node center = (Node)ResizeablePane.this.contentProperty().get();
            if (center == null) {
                return FXCollections.observableArrayList((Object[])new Node[]{ResizeablePane.this.resizeWest, ResizeablePane.this.resizeEast, ResizeablePane.this.resizeSouth, ResizeablePane.this.resizeNorth, ResizeablePane.this.resizeNorthWest, ResizeablePane.this.resizeNorthEast, ResizeablePane.this.resizeSouthWest, ResizeablePane.this.resizeSouthEast});
            }
            return FXCollections.observableArrayList((Object[])new Node[]{ResizeablePane.this.resizeWest, ResizeablePane.this.resizeEast, ResizeablePane.this.resizeSouth, ResizeablePane.this.resizeNorth, ResizeablePane.this.resizeNorthWest, ResizeablePane.this.resizeNorthEast, ResizeablePane.this.resizeSouthWest, ResizeablePane.this.resizeSouthEast, center});
        }

        public void dispose() {
            super.dispose();
            this.unbind(new Observable[]{ResizeablePane.this.contentProperty()});
        }
    }

    private class Handler
    implements EventHandler<MouseEvent> {
        double dragBeginX;
        double dragBeginY;
        boolean rN;
        boolean rS;
        boolean rE;
        boolean rW;
        double x;
        double y;
        double width;
        double height;

        private Handler() {
        }

        public void handle(MouseEvent e) {
            if (MouseEvent.MOUSE_PRESSED == e.getEventType()) {
                System.err.println("BEGIN");
                this.dragBeginX = e.getScreenX();
                this.dragBeginY = e.getScreenY();
                this.x = ResizeablePane.this.getWindow().getX();
                this.y = ResizeablePane.this.getWindow().getY();
                this.width = ResizeablePane.this.getWidth();
                this.height = ResizeablePane.this.getHeight();
                if (e.getSource() == ResizeablePane.this.resizeNorth) {
                    this.rN = true;
                } else if (e.getSource() == ResizeablePane.this.resizeNorthEast) {
                    this.rN = true;
                    this.rE = true;
                } else if (e.getSource() == ResizeablePane.this.resizeEast) {
                    this.rE = true;
                } else if (e.getSource() == ResizeablePane.this.resizeSouthEast) {
                    this.rS = true;
                    this.rE = true;
                } else if (e.getSource() == ResizeablePane.this.resizeSouth) {
                    this.rS = true;
                } else if (e.getSource() == ResizeablePane.this.resizeSouthWest) {
                    this.rS = true;
                    this.rW = true;
                } else if (e.getSource() == ResizeablePane.this.resizeWest) {
                    this.rW = true;
                } else if (e.getSource() == ResizeablePane.this.resizeNorthWest) {
                    this.rW = true;
                    this.rN = true;
                }
            } else if (MouseEvent.MOUSE_DRAGGED == e.getEventType()) {
                double x = this.x;
                double y = this.y;
                double width = this.width;
                double height = this.height;
                double deltaX = e.getScreenX() - this.dragBeginX;
                double deltaY = e.getScreenY() - this.dragBeginY;
                double minWidth = ResizeablePane.this.getContent().minWidth(-1.0) + ResizeablePane.this.resizeHandleSize.get() * 2.0;
                double minHeight = ResizeablePane.this.getContent().minHeight(-1.0) + ResizeablePane.this.resizeHandleSize.get() * 2.0;
                if (this.rS && (height += deltaY) < minHeight) {
                    height = minHeight;
                }
                if (this.rE && (width += deltaX) < minWidth) {
                    width = minWidth;
                }
                if (this.rN) {
                    y += deltaY;
                    if ((height -= deltaY) < minHeight) {
                        height = minHeight;
                        y = this.y + this.height - minHeight;
                    }
                }
                if (this.rW) {
                    x += deltaX;
                    if ((width -= deltaX) < minWidth) {
                        width = minWidth;
                        x = this.x + this.width - minWidth;
                    }
                }
                ResizeablePane.this.resizeWindow(x, y, width, height);
            } else if (MouseEvent.MOUSE_RELEASED == e.getEventType()) {
                this.rN = false;
                this.rS = false;
                this.rE = false;
                this.rW = false;
            }
        }
    }
}

