/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.junit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.fx.core.EventLoop;
import org.eclipse.fx.core.ThreadQueue;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.junit.RunInSyncThread;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ThreadSynchronizedRule
implements TestRule {
    private final ThreadSynchronize threadSync;
    private final Consumer<ThreadSynchronize.BlockCondition<Void>> waitConditionAcceptor;
    private Thread eventProcessor = new Thread(this::spin);
    private AtomicBoolean spinning = new AtomicBoolean();
    private EventLoop queue;

    public ThreadSynchronizedRule(Consumer<ThreadSynchronize.BlockCondition<Void>> waitConditionAcceptor) {
        this.queue = new EventLoop();
        this.threadSync = ThreadSynchronize.createBasicThreadSyncronize((ThreadQueue)this.queue);
        this.waitConditionAcceptor = waitConditionAcceptor;
        this.spinning.set(true);
        this.eventProcessor.start();
    }

    private void spin() {
        while (this.spinning.get()) {
            if (this.queue.dispatch()) continue;
            this.queue.sleep();
        }
    }

    public void stopEventQueue() {
        this.spinning.set(false);
    }

    public ThreadSynchronizedRule(ThreadSynchronize threadSync) {
        this.threadSync = threadSync;
        this.waitConditionAcceptor = null;
    }

    public Statement apply(Statement base, Description description) {
        Statement result = base;
        RunInSyncThread annotation = (RunInSyncThread)description.getAnnotation(RunInSyncThread.class);
        if (annotation != null) {
            result = new RunInThreadStmt(base, this.threadSync, this.waitConditionAcceptor);
        }
        return result;
    }

    public ThreadSynchronize getThreadSynchronize() {
        return this.threadSync;
    }

    static class RunInThreadStmt
    extends Statement {
        private Statement base;
        private ThreadSynchronize threadSync;
        private Consumer<ThreadSynchronize.BlockCondition<Void>> waitConditionAcceptor;

        public RunInThreadStmt(Statement base, ThreadSynchronize threadSync, Consumer<ThreadSynchronize.BlockCondition<Void>> waitConditionAcceptor) {
            this.base = base;
            this.threadSync = threadSync;
            this.waitConditionAcceptor = waitConditionAcceptor;
        }

        public void evaluate() throws Throwable {
            CompletableFuture f = new CompletableFuture();
            Runnable execute = () -> {
                try {
                    this.base.evaluate();
                    f.complete(null);
                }
                catch (Throwable t) {
                    f.completeExceptionally(t);
                }
            };
            if (this.waitConditionAcceptor != null) {
                this.threadSync.asyncExec(() -> {
                    ThreadSynchronize.BlockCondition c = new ThreadSynchronize.BlockCondition();
                    c.subscribeUnblockedCallback(v -> execute.run());
                    this.waitConditionAcceptor.accept((ThreadSynchronize.BlockCondition<Void>)c);
                });
            } else {
                execute.run();
            }
            try {
                f.get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof AssertionError) {
                    throw ex.getCause();
                }
                throw ex;
            }
        }
    }
}

