/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.internal.ClasspathEntryDescriptor;

public class ClasspathDescriptor
implements IClasspathDescriptor {
    private final ArrayList<IClasspathEntryDescriptor> entries = new ArrayList();
    private final Map<IPath, IClasspathEntryDescriptor> staleEntries = new LinkedHashMap<IPath, IClasspathEntryDescriptor>();
    private final boolean uniquePaths;

    public ClasspathDescriptor(boolean uniquePaths) {
        this.uniquePaths = uniquePaths;
    }

    public ClasspathDescriptor(IJavaProject javaProject) throws JavaModelException {
        this(true);
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (!javaProject.getProject().getFullPath().equals((Object)cpe.getPath())) {
                ClasspathEntryDescriptor entry = new ClasspathEntryDescriptor(cpe);
                this.entries.add(entry);
                this.staleEntries.put(entry.getPath(), entry);
            }
            ++n2;
        }
    }

    @Override
    public boolean containsPath(IPath path) {
        for (IClasspathEntryDescriptor descriptor : this.entries) {
            if (!path.equals((Object)descriptor.getPath())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClasspathEntryDescriptor addSourceEntry(IPath sourcePath, IPath outputLocation, boolean generated) {
        return this.addSourceEntry(sourcePath, outputLocation, new IPath[0], new IPath[0], generated);
    }

    @Override
    public List<IClasspathEntryDescriptor> removeEntry(final IPath path) {
        return this.removeEntry(new IClasspathDescriptor.EntryFilter(){

            @Override
            public boolean accept(IClasspathEntryDescriptor descriptor) {
                return path.equals((Object)descriptor.getPath());
            }
        });
    }

    @Override
    public List<IClasspathEntryDescriptor> removeEntry(IClasspathDescriptor.EntryFilter filter) {
        ArrayList<IClasspathEntryDescriptor> result = new ArrayList<IClasspathEntryDescriptor>();
        Iterator<IClasspathEntryDescriptor> iter = this.entries.iterator();
        while (iter.hasNext()) {
            IClasspathEntryDescriptor descriptor = iter.next();
            if (!filter.accept(descriptor)) continue;
            this.staleEntries.remove(descriptor.getPath());
            result.add(descriptor);
            iter.remove();
        }
        return result;
    }

    @Override
    public ClasspathEntryDescriptor addSourceEntry(IPath sourcePath, IPath outputLocation, IPath[] inclusion, IPath[] exclusion, boolean generated) {
        ClasspathEntryDescriptor descriptor = new ClasspathEntryDescriptor(3, sourcePath);
        descriptor.setOutputLocation(outputLocation);
        descriptor.setInclusionPatterns(inclusion);
        descriptor.setExclusionPatterns(exclusion);
        IClasspathEntryDescriptor oldEntry = this.staleEntries.get(sourcePath);
        if (oldEntry != null) {
            for (Map.Entry<String, String> entry : oldEntry.getClasspathAttributes().entrySet()) {
                descriptor.setClasspathAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (generated) {
            descriptor.setClasspathAttribute("optional", "true");
        }
        this.addEntryDescriptor(descriptor);
        return descriptor;
    }

    @Override
    public void touchEntry(IPath sourcePath) {
        this.staleEntries.remove(sourcePath);
    }

    @Override
    public IClasspathEntry[] getEntries() {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        for (IClasspathEntryDescriptor entry : this.entries) {
            if (entry.isPomDerived() && this.staleEntries.containsKey(entry.getPath())) continue;
            result.add(entry.toClasspathEntry());
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    @Override
    public List<IClasspathEntryDescriptor> getEntryDescriptors() {
        return this.entries;
    }

    @Override
    public ClasspathEntryDescriptor addEntry(IClasspathEntry cpe) {
        ClasspathEntryDescriptor entry = new ClasspathEntryDescriptor(cpe);
        this.addEntryDescriptor(entry);
        return entry;
    }

    @Override
    public IClasspathEntryDescriptor replaceEntry(IClasspathDescriptor.EntryFilter filter, IClasspathEntry cpe) {
        ListIterator<IClasspathEntryDescriptor> iter = this.entries.listIterator();
        while (iter.hasNext()) {
            IClasspathEntryDescriptor descriptor = iter.next();
            if (!filter.accept(descriptor)) continue;
            this.staleEntries.remove(descriptor.getPath());
            ClasspathEntryDescriptor entry = new ClasspathEntryDescriptor(cpe);
            entry.setPomDerived(true);
            iter.set(entry);
            return entry;
        }
        return null;
    }

    @Override
    public ClasspathEntryDescriptor addProjectEntry(Artifact a, IMavenProjectFacade projectFacade) {
        ClasspathEntryDescriptor entry = this.addProjectEntry(projectFacade.getFullPath());
        entry.setArtifactKey(new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), a.getClassifier()));
        entry.setScope(a.getScope());
        entry.setOptionalDependency(a.isOptional());
        return entry;
    }

    @Override
    public ClasspathEntryDescriptor addProjectEntry(IPath entryPath) {
        ClasspathEntryDescriptor entry = new ClasspathEntryDescriptor(2, entryPath);
        this.addEntryDescriptor(entry);
        return entry;
    }

    @Override
    public ClasspathEntryDescriptor addLibraryEntry(Artifact artifact, IPath srcPath, IPath srcRoot, String javaDocUrl) {
        ArtifactKey artifactKey = new ArtifactKey(artifact);
        Path entryPath = new Path(artifact.getFile().getAbsolutePath());
        ClasspathEntryDescriptor entry = this.addLibraryEntry((IPath)entryPath);
        entry.setArtifactKey(artifactKey);
        if (javaDocUrl != null) {
            entry.setClasspathAttribute("javadoc_location", javaDocUrl);
        }
        return entry;
    }

    @Override
    public ClasspathEntryDescriptor addLibraryEntry(IPath entryPath) {
        ClasspathEntryDescriptor entry = new ClasspathEntryDescriptor(1, entryPath);
        this.addEntryDescriptor(entry);
        return entry;
    }

    private void addEntryDescriptor(ClasspathEntryDescriptor descriptor) {
        this.staleEntries.remove(descriptor.getPath());
        descriptor.setPomDerived(true);
        ListIterator<IClasspathEntryDescriptor> iter = this.entries.listIterator();
        if (this.uniquePaths) {
            while (iter.hasNext()) {
                if (!iter.next().getPath().equals((Object)descriptor.getPath())) continue;
                iter.set(descriptor);
                return;
            }
        }
        this.entries.add(descriptor);
    }
}

