/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String slClass = OptionHelper.getSystemProperty((String)"logback.statusListenerClass");
        if (!OptionHelper.isEmpty((String)slClass)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, slClass);
        }
    }

    private static void addStatusListener(LoggerContext loggerContext, String listenerClass) {
        Object listener = null;
        listener = "SYSOUT".equalsIgnoreCase(listenerClass) ? new OnConsoleStatusListener() : StatusListenerConfigHelper.createListenerPerClassName(loggerContext, listenerClass);
        StatusListenerConfigHelper.initListener(loggerContext, (StatusListener)listener);
    }

    private static void initListener(LoggerContext loggerContext, StatusListener listener) {
        if (listener != null) {
            if (listener instanceof ContextAware) {
                ((ContextAware)listener).setContext((Context)loggerContext);
            }
            if (listener instanceof LifeCycle) {
                ((LifeCycle)listener).start();
            }
            loggerContext.getStatusManager().add(listener);
        }
    }

    private static StatusListener createListenerPerClassName(LoggerContext loggerContext, String listenerClass) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName((String)listenerClass, StatusListener.class, (Context)loggerContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

