/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintWriter;
import org.apache.felix.scr.impl.ComponentCommands;
import org.apache.felix.scr.info.ScrInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

public class ComponentCommandsScrInfo
implements ScrInfo {
    private final ComponentCommands commands;
    private final BundleContext context;

    ComponentCommandsScrInfo(ComponentCommands commands, BundleContext context) {
        this.commands = commands;
        this.context = context;
    }

    @Override
    public void list(String bundleIdentifier, PrintWriter out) {
        CharSequence formatted;
        long bundleId;
        try {
            bundleId = Long.parseLong(bundleIdentifier);
        }
        catch (NumberFormatException e) {
            Bundle bundle = this.findBundle(bundleIdentifier);
            if (bundle == null) {
                throw new IllegalArgumentException("Cannot find bundle with ID: " + bundleIdentifier);
            }
            bundleId = bundle.getBundleId();
        }
        try {
            ComponentDescriptionDTO[] dtos = this.commands.list(bundleId);
            formatted = dtos != null ? this.commands.format(dtos, 1) : "No components found for bundle  " + bundleId;
        }
        catch (Exception e) {
            throw new RuntimeException("Error listing or formatting SCR runtime information", e);
        }
        out.println(formatted);
    }

    @Override
    public void info(String componentId, PrintWriter out) {
        CharSequence formatted;
        ComponentDescriptionDTO infoObj;
        try {
            long configId = Long.parseLong(componentId);
            infoObj = this.commands.info(configId);
        }
        catch (NumberFormatException e) {
            infoObj = this.commands.info(componentId);
        }
        if (infoObj != null) {
            try {
                formatted = this.commands.format((Object)infoObj, 0);
            }
            catch (Exception e) {
                throw new RuntimeException("Error formatting SCR runtime information", e);
            }
        } else {
            formatted = "No component found with ID " + componentId;
        }
        out.println(formatted);
    }

    @Override
    public void config(PrintWriter out) {
        out.println(this.commands.config());
    }

    private Bundle findBundle(String bsn) {
        for (Bundle b : this.context.getBundles()) {
            if (!b.getSymbolicName().equals(bsn)) continue;
            return b;
        }
        return null;
    }
}

