/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.fx.core.TypeTypeProviderService;
import org.eclipse.fx.ui.workbench.services.ModelService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component
public class ModelServiceImpl
implements ModelService,
TypeTypeProviderService<ModelService.ModelElementFactory> {
    public @NonNull String getUniqueId(@NonNull MApplicationElement element) {
        EObject eo = (EObject)element;
        String id = ((XMIResource)eo.eResource()).getID(eo);
        if (id == null) {
            throw new IllegalStateException("Unable to locate ID for '" + element + "'");
        }
        return id;
    }

    public <M extends MApplicationElement> @Nullable M getElementInstance(@NonNull MApplication m, @NonNull String uniqueId) {
        return (M)((MApplicationElement)((XMIResource)((EObject)m).eResource()).getEObject(uniqueId));
    }

    public MApplication getRoot(@NonNull MApplicationElement e) {
        Resource eResource = ((EObject)e).eResource();
        return eResource != null ? (MApplication)eResource.getContents().get(0) : null;
    }

    public Class<? extends ModelService.ModelElementFactory> getType(Type s) {
        return ModelElementFactoryImpl.class;
    }

    public boolean test(Type t) {
        return t == ModelService.ModelElementFactory.class;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ModelService.ModelElementFactory createModelElementFactory(@NonNull Class<?> owner, @NonNull EModelService modelService) {
        return new ModelElementFactoryImpl(modelService, owner);
    }

    public static @NonNull String _getBundleName(Class<?> clazz) {
        String bundleId = FrameworkUtil.getBundle(clazz).getSymbolicName();
        if (bundleId == null) {
            throw new IllegalStateException("Could not extract the bundle name from the '" + clazz + "'");
        }
        return bundleId;
    }

    public static @NonNull Supplier<@NonNull String> _getBundleNameSupplier(Class<?> clazz) {
        String id = ModelServiceImpl._getBundleName(clazz);
        return () -> id;
    }

    public @NonNull String getBundleName(Class<?> clazz) {
        return ModelServiceImpl._getBundleName(clazz);
    }

    public @NonNull Supplier<@NonNull String> getBundleNameSupplier(Class<?> clazz) {
        return ModelServiceImpl._getBundleNameSupplier(clazz);
    }

    public static class ModelElementFactoryImpl
    implements ModelService.ModelElementFactory {
        private final @NonNull EModelService modelService;
        private final @NonNull Supplier<@NonNull String> contributor;

        @Inject
        public ModelElementFactoryImpl(@NonNull EModelService modelService, @Named(value="localInstanceOwnerType") @Named(value="localInstanceOwnerType") @NonNull Class<?> ownerType) {
            this.modelService = modelService;
            this.contributor = ModelServiceImpl._getBundleNameSupplier(ownerType);
        }

        public <T extends MApplicationElement> @NonNull T createModelElement(@NonNull Class<@NonNull T> clazz) {
            return (T)this.createModelElement(clazz, this.contributor, e -> e);
        }

        public <T extends MApplicationElement> @NonNull T createModelElement(@NonNull Class<@NonNull T> clazz, @NonNull Function<@NonNull T, @NonNull T> processor) {
            return this.createModelElement(clazz, this.contributor, processor);
        }

        public <T extends MApplicationElement> @NonNull T createModelElement(@NonNull Class<@NonNull T> clazz, @NonNull Supplier<@NonNull String> contributor) {
            return (T)this.createModelElement(clazz, contributor, t -> t);
        }

        public <T extends MApplicationElement> @NonNull T createModelElement(@NonNull Class<@NonNull T> clazz, @NonNull Supplier<@NonNull String> contributor, Function<@NonNull T, @NonNull T> processor) {
            MApplicationElement element = this.modelService.createModelElement(clazz);
            element.setContributorURI("platform:/plugin/" + contributor);
            element = (MApplicationElement)processor.apply(element);
            return (T)element;
        }

        public <T extends MApplicationElement> @NonNull Supplier<T> createModelElementCreator(@NonNull Class<@NonNull T> clazz) {
            return this.createModelElementCreator(clazz, this.contributor, t -> t);
        }

        public <T extends MApplicationElement> @NonNull Supplier<T> createModelElementCreator(@NonNull Class<@NonNull T> clazz, @NonNull Function<@NonNull T, @NonNull T> processor) {
            return this.createModelElementCreator(clazz, this.contributor, processor);
        }

        public <T extends MApplicationElement> @NonNull Supplier<T> createModelElementCreator(@NonNull Class<@NonNull T> clazz, @NonNull Supplier<@NonNull String> contributor) {
            return this.createModelElementCreator(clazz, contributor, t -> t);
        }

        public <T extends MApplicationElement> @NonNull Supplier<T> createModelElementCreator(@NonNull Class<@NonNull T> clazz, @NonNull Supplier<@NonNull String> contributor, Function<@NonNull T, @NonNull T> processor) {
            return () -> this.createModelElement(clazz, contributor, processor);
        }
    }
}

