/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import java.io.File;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.IndexingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArtifactScanningMonitor
implements ArtifactScanningListener {
    private static final Logger log = LoggerFactory.getLogger(ArtifactScanningMonitor.class);
    private static final long THRESHOLD = 1000L;
    private final IProgressMonitor monitor;
    private long timestamp = System.currentTimeMillis();
    private final File repositoryDir;

    ArtifactScanningMonitor(File repositoryDir, IProgressMonitor monitor) {
        this.repositoryDir = repositoryDir;
        this.monitor = monitor;
    }

    public void scanningStarted(IndexingContext ctx) {
    }

    public void scanningFinished(IndexingContext ctx, ScanningResult result) {
    }

    public void artifactDiscovered(ArtifactContext ac) {
        long current = System.currentTimeMillis();
        if (current - this.timestamp > 1000L) {
            String id = ac.getPom().getAbsolutePath().substring(this.repositoryDir.getAbsolutePath().length());
            this.monitor.setTaskName(id);
            this.timestamp = current;
        }
    }

    public void artifactError(ArtifactContext ac, Exception e) {
        String id = ac.getPom().getAbsolutePath().substring(this.repositoryDir.getAbsolutePath().length());
        log.error(String.valueOf(id) + " " + e.getMessage());
    }
}

