/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import com.google.common.base.Strings;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.renderers.base.BaseToolItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolItem;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;

public class DefToolItemRenderer
extends BaseToolItemRenderer<Node> {
    protected Class<? extends WToolItem<Node>> getWidgetClass(MToolItem item) {
        return ToolItemImpl.class;
    }

    public static class ToolItemImpl
    extends WWidgetImpl<ButtonBase, MToolItem>
    implements WToolItem<Node> {
        private ItemType type;
        private boolean menuButton;
        private Runnable onActionCallback;
        private boolean handled = true;
        private boolean enabled = true;
        private boolean checkbox = false;
        @Inject
        private GraphicsLoader graphicsLoader;

        @Inject
        public ToolItemImpl(@Named(value="fx.rendering.domElement") @Named(value="fx.rendering.domElement") MToolItem domElement) {
            this.type = domElement.getType();
            this.menuButton = domElement.getMenu() != null;
            this.checkbox = domElement.getTags().contains("fx_checkbox");
        }

        @Override
        protected void bindProperties(ButtonBase widget) {
            super.bindProperties(widget);
            if (widget instanceof CheckBox) {
                this.bindProperty("selected", (ObservableValue<Object>)((CheckBox)widget).selectedProperty());
            } else if (widget instanceof ToggleButton) {
                this.bindProperty("selected", (ObservableValue<Object>)((ToggleButton)widget).selectedProperty());
            }
        }

        public void setHandled(boolean handled) {
            if (this.handled != handled) {
                this.handled = handled;
                this.updateEnabledState();
            }
        }

        private void updateEnabledState() {
            ((ButtonBase)this.getWidget()).setDisable(!this.handled || !this.enabled);
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") @Named(value="localizedLabel") String label) {
            ((ButtonBase)this.getWidget()).setText(label);
        }

        @Inject
        public void setAccessibilityText(@Named(value="accessibilityPhrase") @Named(value="accessibilityPhrase") String helpText) {
            ((ButtonBase)this.getWidget()).setAccessibleHelp(helpText);
        }

        @Inject
        public void setTooltip(@Named(value="localizedTooltip") @Named(value="localizedTooltip") String tooltip) {
            if (tooltip != null && !tooltip.isEmpty()) {
                ((ButtonBase)this.getWidget()).setTooltip(new Tooltip(tooltip));
            } else {
                ((ButtonBase)this.getWidget()).setTooltip(null);
            }
        }

        @Inject
        public void setEnabled(@Named(value="enabled") @Named(value="enabled") boolean enabled) {
            this.enabled = enabled;
            this.updateEnabledState();
        }

        @Inject
        public void setIconURI(@Named(value="iconURI") @Named(value="iconURI") String uri) {
            if (Strings.isNullOrEmpty((String)uri)) {
                ((ButtonBase)this.getWidget()).setGraphic(null);
            } else {
                ((ButtonBase)this.getWidget()).setGraphic(this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)new EMFUri(URI.createURI((String)uri))));
            }
        }

        @Inject
        public void setSelected(@Named(value="selected") @Named(value="selected") boolean selected) {
            ToggleButton b;
            if (this.getWidget() instanceof CheckBox) {
                CheckBox b2 = (CheckBox)this.getWidget();
                if (b2.isSelected() != selected) {
                    b2.setSelected(selected);
                }
            } else if (this.getWidget() instanceof ToggleButton && (b = (ToggleButton)this.getWidget()).isSelected() != selected) {
                b.setSelected(selected);
            }
        }

        public void setOnActionCallback(Runnable onActionCallback) {
            this.onActionCallback = onActionCallback;
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.onActionCallback = null;
        }

        @Override
        protected ButtonBase createWidget() {
            ButtonBase b = this.internalCreateWidget();
            b.setOnAction(this::handleOnAction);
            return b;
        }

        void handleOnAction(ActionEvent e) {
            if (this.onActionCallback != null) {
                this.onActionCallback.run();
            }
        }

        private @NonNull ButtonBase internalCreateWidget() {
            switch (this.type) {
                case CHECK: {
                    if (this.checkbox) {
                        return new CheckBox();
                    }
                    return new ToggleButton();
                }
                case RADIO: {
                    return new RadioButton();
                }
            }
            if (this.menuButton) {
                SplitMenuButton b = new SplitMenuButton();
                return b;
            }
            return new Button();
        }

        public void addStyleClasses(List<String> classnames) {
            ((ButtonBase)this.getWidget()).getStyleClass().addAll(classnames);
        }

        public void addStyleClasses(String ... classnames) {
            ((ButtonBase)this.getWidget()).getStyleClass().addAll((Object[])classnames);
        }

        public void removeStyleClasses(List<String> classnames) {
            ((ButtonBase)this.getWidget()).getStyleClass().removeAll(classnames);
        }

        public void removeStyleClasses(String ... classnames) {
            ((ButtonBase)this.getWidget()).getStyleClass().removeAll((Object[])classnames);
        }

        public void setStyleId(String id) {
            ((ButtonBase)this.getWidget()).setId(id);
        }

        @Override
        protected void setUserData(WWidgetImpl<ButtonBase, MToolItem> widget) {
            ((ButtonBase)this.getWidget()).setUserData(widget);
        }
    }
}

