/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.ZipBundleFile;

public class ZipBundleEntry
extends BundleEntry {
    protected final ZipEntry zipEntry;
    protected final ZipBundleFile bundleFile;

    ZipBundleEntry(ZipEntry zipEntry, ZipBundleFile bundleFile) {
        this.zipEntry = zipEntry;
        this.bundleFile = bundleFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.bundleFile.getInputStream(this.zipEntry);
    }

    @Override
    public long getSize() {
        return this.zipEntry.getSize();
    }

    @Override
    public String getName() {
        return this.zipEntry.getName();
    }

    @Override
    public long getTime() {
        return this.zipEntry.getTime();
    }

    @Override
    public URL getLocalURL() {
        try {
            return new URL("jar:" + this.bundleFile.basefile.toURL() + "!/" + this.zipEntry.getName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public URL getFileURL() {
        try {
            File file = this.bundleFile.getFile(this.zipEntry.getName(), false);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }
}

