/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;

class BuildResultCollector
implements IIncrementalBuildFramework.BuildResultCollector {
    private String currentParticipantId;
    private final Set<File> refresh = new HashSet<File>();
    private final Map<String, List<Message>> messages = new LinkedHashMap<String, List<Message>>();
    private final Map<String, List<File>> removeMessages = new LinkedHashMap<String, List<File>>();

    BuildResultCollector() {
    }

    @Override
    public Set<File> getFiles() {
        return this.refresh;
    }

    @Override
    public void refresh(File file) {
        this.refresh.add(file);
    }

    @Override
    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        if (this.currentParticipantId == null) {
            throw new IllegalStateException("currentBuildParticipantId cannot be null or empty");
        }
        List<Message> messageList = this.messages.get(this.currentParticipantId);
        if (messageList == null) {
            messageList = new ArrayList<Message>();
            this.messages.put(this.currentParticipantId, messageList);
        }
        messageList.add(new Message(file, line, column, message, severity, cause));
    }

    @Override
    public void removeMessages(File file) {
        if (this.currentParticipantId == null) {
            throw new IllegalStateException("currentBuildParticipantId cannot be null or empty");
        }
        List<File> files = this.removeMessages.get(this.currentParticipantId);
        if (files == null) {
            files = new ArrayList<File>();
            this.removeMessages.put(this.currentParticipantId, files);
        }
        files.add(file);
    }

    public Map<String, List<Message>> getMessages() {
        return this.messages;
    }

    public Map<String, List<File>> getRemoveMessages() {
        return this.removeMessages;
    }

    public void setParticipantId(String participantId) {
        this.currentParticipantId = participantId;
    }

    public static class Message {
        public final File file;
        public final int line;
        public final int column;
        public final String message;
        public final int severity;
        public final Throwable cause;

        Message(File file, int line, int column, String message, int severity, Throwable cause) {
            this.file = file;
            this.line = line;
            this.column = column;
            if (message == null && cause != null) {
                message = cause.getMessage();
            }
            this.message = message;
            this.severity = severity;
            this.cause = cause;
        }
    }
}

