/*******************************************************************************
 * Copyright (c) 2012 BestSolution.at and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tom Schindl<tom.schindl@bestsolution.at> - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.formats.svg.svg;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.fx.formats.svg.svg.SvgFactory
 * @model kind="package"
 * @generated
 */
public interface SvgPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "svg";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.w3.org/2000/svg";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "svg";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SvgPackage eINSTANCE = org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.ContentElement <em>Content Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.ContentElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getContentElement()
	 * @generated
	 */
	int CONTENT_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_ELEMENT__CHILDREN = 0;

	/**
	 * The number of structural features of the '<em>Content Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_ELEMENT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.ContainerElement <em>Container Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.ContainerElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getContainerElement()
	 * @generated
	 */
	int CONTAINER_ELEMENT = 1;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER_ELEMENT__CHILDREN = CONTENT_ELEMENT__CHILDREN;

	/**
	 * The number of structural features of the '<em>Container Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER_ELEMENT_FEATURE_COUNT = CONTENT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.StructuralElement <em>Structural Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.StructuralElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getStructuralElement()
	 * @generated
	 */
	int STRUCTURAL_ELEMENT = 2;

	/**
	 * The number of structural features of the '<em>Structural Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURAL_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.SvgElement <em>Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.SvgElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgElement()
	 * @generated
	 */
	int SVG_ELEMENT = 3;

	/**
	 * The number of structural features of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.DescriptiveElement <em>Descriptive Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.DescriptiveElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getDescriptiveElement()
	 * @generated
	 */
	int DESCRIPTIVE_ELEMENT = 4;

	/**
	 * The number of structural features of the '<em>Descriptive Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTIVE_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.GraphicsElement <em>Graphics Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.GraphicsElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getGraphicsElement()
	 * @generated
	 */
	int GRAPHICS_ELEMENT = 5;

	/**
	 * The number of structural features of the '<em>Graphics Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICS_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.GraphicsReferencingElement <em>Graphics Referencing Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.GraphicsReferencingElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getGraphicsReferencingElement()
	 * @generated
	 */
	int GRAPHICS_REFERENCING_ELEMENT = 6;

	/**
	 * The number of structural features of the '<em>Graphics Referencing Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICS_REFERENCING_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.ShapeElement <em>Shape Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.ShapeElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getShapeElement()
	 * @generated
	 */
	int SHAPE_ELEMENT = 7;

	/**
	 * The number of structural features of the '<em>Shape Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.BasicShapeElement <em>Basic Shape Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.BasicShapeElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getBasicShapeElement()
	 * @generated
	 */
	int BASIC_SHAPE_ELEMENT = 8;

	/**
	 * The number of structural features of the '<em>Basic Shape Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_SHAPE_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.TextContentElement <em>Text Content Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.TextContentElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getTextContentElement()
	 * @generated
	 */
	int TEXT_CONTENT_ELEMENT = 9;

	/**
	 * The number of structural features of the '<em>Text Content Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_CONTENT_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.TextContentChildElement <em>Text Content Child Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.TextContentChildElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getTextContentChildElement()
	 * @generated
	 */
	int TEXT_CONTENT_CHILD_ELEMENT = 10;

	/**
	 * The number of structural features of the '<em>Text Content Child Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_CONTENT_CHILD_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.GradientElement <em>Gradient Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.GradientElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getGradientElement()
	 * @generated
	 */
	int GRADIENT_ELEMENT = 11;

	/**
	 * The number of structural features of the '<em>Gradient Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRADIENT_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.LightSourceElement <em>Light Source Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.LightSourceElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getLightSourceElement()
	 * @generated
	 */
	int LIGHT_SOURCE_ELEMENT = 12;

	/**
	 * The number of structural features of the '<em>Light Source Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIGHT_SOURCE_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.FilterPrimitiveElement <em>Filter Primitive Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.FilterPrimitiveElement
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getFilterPrimitiveElement()
	 * @generated
	 */
	int FILTER_PRIMITIVE_ELEMENT = 13;

	/**
	 * The number of structural features of the '<em>Filter Primitive Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.AnimationElementImpl <em>Animation Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.AnimationElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getAnimationElement()
	 * @generated
	 */
	int ANIMATION_ELEMENT = 14;

	/**
	 * The number of structural features of the '<em>Animation Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANIMATION_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.____ENUMS____Impl <em>ENUMS </em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.____ENUMS____Impl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#get____ENUMS____()
	 * @generated
	 */
	int _ENUMS_ = 15;

	/**
	 * The number of structural features of the '<em>ENUMS </em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int _ENUMS__FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.____DATATYPES____Impl <em>DATATYPES </em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.____DATATYPES____Impl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#get____DATATYPES____()
	 * @generated
	 */
	int _DATATYPES_ = 16;

	/**
	 * The number of structural features of the '<em>DATATYPES </em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int _DATATYPES__FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.____ATTRIBUTES____Impl <em>ATTRIBUTES </em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.____ATTRIBUTES____Impl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#get____ATTRIBUTES____()
	 * @generated
	 */
	int _ATTRIBUTES_ = 17;

	/**
	 * The number of structural features of the '<em>ATTRIBUTES </em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int _ATTRIBUTES__FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.ConditionalProcessingAttributes <em>Conditional Processing Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.ConditionalProcessingAttributes
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getConditionalProcessingAttributes()
	 * @generated
	 */
	int CONDITIONAL_PROCESSING_ATTRIBUTES = 18;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_PROCESSING_ATTRIBUTES__REQUIRED_FEATURES = 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_PROCESSING_ATTRIBUTES__REQUIRED_EXTENSIONS = 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_PROCESSING_ATTRIBUTES__SYSTEM_LANGUAGE = 2;

	/**
	 * The number of structural features of the '<em>Conditional Processing Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_PROCESSING_ATTRIBUTES_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.CoreAttributes <em>Core Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.CoreAttributes
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getCoreAttributes()
	 * @generated
	 */
	int CORE_ATTRIBUTES = 19;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ATTRIBUTES__ID = 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ATTRIBUTES__XML_BASE = 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ATTRIBUTES__XML_LANG = 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ATTRIBUTES__XML_SPACE = 3;

	/**
	 * The number of structural features of the '<em>Core Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ATTRIBUTES_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes <em>Document Event Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.DocumentEventAttributes
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getDocumentEventAttributes()
	 * @generated
	 */
	int DOCUMENT_EVENT_ATTRIBUTES = 20;

	/**
	 * The feature id for the '<em><b>Onunload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_EVENT_ATTRIBUTES__ONUNLOAD = 0;

	/**
	 * The feature id for the '<em><b>Onabort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_EVENT_ATTRIBUTES__ONABORT = 1;

	/**
	 * The feature id for the '<em><b>Onerror</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_EVENT_ATTRIBUTES__ONERROR = 2;

	/**
	 * The feature id for the '<em><b>Onresize</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_EVENT_ATTRIBUTES__ONRESIZE = 3;

	/**
	 * The feature id for the '<em><b>Onscroll</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_EVENT_ATTRIBUTES__ONSCROLL = 4;

	/**
	 * The feature id for the '<em><b>Onzoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_EVENT_ATTRIBUTES__ONZOOM = 5;

	/**
	 * The number of structural features of the '<em>Document Event Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_EVENT_ATTRIBUTES_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.GraphicalEventAttributes <em>Graphical Event Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.GraphicalEventAttributes
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getGraphicalEventAttributes()
	 * @generated
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES = 21;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONFOCUSIN = 0;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONFOCUSOUT = 1;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONACTIVATE = 2;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONCLICK = 3;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONMOUSEDOWN = 4;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONMOUSEUP = 5;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONMOUSEOVER = 6;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONMOUSEMOVE = 7;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONMOUSEOUT = 8;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES__ONLOAD = 9;

	/**
	 * The number of structural features of the '<em>Graphical Event Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHICAL_EVENT_ATTRIBUTES_FEATURE_COUNT = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.PresentationAttributes <em>Presentation Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.PresentationAttributes
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getPresentationAttributes()
	 * @generated
	 */
	int PRESENTATION_ATTRIBUTES = 22;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__ALIGNMENT_BASELINE = 0;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__BASELINE_SHIFT = 1;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__CLIP = 2;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__CLIP_PATH = 3;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__CLIP_RULE = 4;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__COLOR = 5;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__COLOR_INTERPOLATION = 6;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__COLOR_INTERPOLATION_FILTERS = 7;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__COLOR_PROFILE = 8;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__COLOR_RENDERING = 9;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__CURSOR = 10;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__DIRECTION = 11;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__DISPLAY = 12;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__DOMINANT_BASELINE = 13;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__ENABLE_BACKGROUND = 14;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FILL = 15;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FILL_OPACITY = 16;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FILL_RULE = 17;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FILTER = 18;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FLOOD_COLOR = 19;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FLOOD_OPACITY = 20;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FONT_FAMILY = 21;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FONT_SIZE = 22;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FONT_SIZE_ADJUST = 23;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FONT_STRETCH = 24;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FONT_STYLE = 25;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FONT_VARIANT = 26;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__FONT_WEIGHT = 27;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__GLYPH_ORIENTATION_HORIZONTAL = 28;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__GLYPH_ORIENTATION_VERTICAL = 29;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__IMAGE_RENDERING = 30;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__KERNING = 31;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__LETTER_SPACING = 32;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__LIGHTING_COLOR = 33;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__MARKER_END = 34;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__MARKER_MID = 35;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__MARKER_START = 36;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__MASKS = 37;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__OPACITY = 38;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__OVERFLOW = 39;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__POINTER_EVENTS = 40;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__SHAPE_RENDERING = 41;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STOP_COLOR = 42;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STOP_OPACITY = 43;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE = 44;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE_DASHARRAY = 45;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE_DASHOFFSET = 46;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE_LINECAP = 47;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE_LINEJOIN = 48;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE_MITERLIMIT = 49;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE_OPACITY = 50;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__STROKE_WIDTH = 51;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__TEXT_ANCHOR = 52;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__TEXT_DECORATION = 53;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__TEXT_RENDERING = 54;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__UNICODE_BIDI = 55;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__VISIBILITY = 56;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__WORD_SPACING = 57;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES__WRITING_MODE = 58;

	/**
	 * The number of structural features of the '<em>Presentation Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTATION_ATTRIBUTES_FEATURE_COUNT = 59;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.XLinkAttributes <em>XLink Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.XLinkAttributes
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getXLinkAttributes()
	 * @generated
	 */
	int XLINK_ATTRIBUTES = 23;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__XLINK_HREF = 0;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__XLINK_SHOW = 1;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__XLINK_ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__XLINK_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__XLINK_ROLE = 4;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__XLINK_ARCROLE = 5;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__XLINK_TITLE = 6;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES__RESOLVED_INSTANCE = 7;

	/**
	 * The number of structural features of the '<em>XLink Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XLINK_ATTRIBUTES_FEATURE_COUNT = 8;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.FilterPrimitiveAttributes <em>Filter Primitive Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.FilterPrimitiveAttributes
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getFilterPrimitiveAttributes()
	 * @generated
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES = 24;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES__X = 0;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES__Y = 1;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES__WIDTH = 2;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES__HEIGHT = 3;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES__RESULT = 4;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES__IN = 5;

	/**
	 * The number of structural features of the '<em>Filter Primitive Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PRIMITIVE_ATTRIBUTES_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.____ELEMENTES____Impl <em>ELEMENTES </em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.____ELEMENTES____Impl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#get____ELEMENTES____()
	 * @generated
	 */
	int _ELEMENTES_ = 25;

	/**
	 * The number of structural features of the '<em>ELEMENTES </em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int _ELEMENTES__FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgSvgElementImpl <em>Svg Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgSvgElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgSvgElement()
	 * @generated
	 */
	int SVG_SVG_ELEMENT = 26;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onunload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONUNLOAD = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onabort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONABORT = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onerror</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONERROR = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onresize</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONRESIZE = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onscroll</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONSCROLL = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onzoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONZOOM = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>View Box</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__VIEW_BOX = SVG_ELEMENT_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>Preserve Aspect Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__PRESERVE_ASPECT_RATIO = SVG_ELEMENT_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Zoom And Pan</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__ZOOM_AND_PAN = SVG_ELEMENT_FEATURE_COUNT + 92;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__VERSION = SVG_ELEMENT_FEATURE_COUNT + 93;

	/**
	 * The feature id for the '<em><b>Base Profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__BASE_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 94;

	/**
	 * The feature id for the '<em><b>Content Script Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CONTENT_SCRIPT_TYPE = SVG_ELEMENT_FEATURE_COUNT + 95;

	/**
	 * The feature id for the '<em><b>Content Style Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__CONTENT_STYLE_TYPE = SVG_ELEMENT_FEATURE_COUNT + 96;

	/**
	 * The feature id for the '<em><b>Style Sheet</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT__STYLE_SHEET = SVG_ELEMENT_FEATURE_COUNT + 97;

	/**
	 * The number of structural features of the '<em>Svg Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SVG_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 98;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgGElementImpl <em>GElement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgGElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgGElement()
	 * @generated
	 */
	int SVG_GELEMENT = 27;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The number of structural features of the '<em>GElement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_GELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgDefsElementImpl <em>Defs Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgDefsElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgDefsElement()
	 * @generated
	 */
	int SVG_DEFS_ELEMENT = 28;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The number of structural features of the '<em>Defs Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DEFS_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgDescElementImpl <em>Desc Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgDescElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgDescElement()
	 * @generated
	 */
	int SVG_DESC_ELEMENT = 29;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Desc Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_DESC_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgTitleElementImpl <em>Title Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgTitleElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgTitleElement()
	 * @generated
	 */
	int SVG_TITLE_ELEMENT = 30;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Title Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TITLE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgSymbolElementImpl <em>Symbol Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgSymbolElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgSymbolElement()
	 * @generated
	 */
	int SVG_SYMBOL_ELEMENT = 31;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>View Box</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__VIEW_BOX = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Preserve Aspect Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT__PRESERVE_ASPECT_RATIO = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The number of structural features of the '<em>Symbol Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SYMBOL_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgUseElementImpl <em>Use Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgUseElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgUseElement()
	 * @generated
	 */
	int SVG_USE_ELEMENT = 32;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 92;

	/**
	 * The number of structural features of the '<em>Use Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_USE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 93;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgImageElementImpl <em>Image Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgImageElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgImageElement()
	 * @generated
	 */
	int SVG_IMAGE_ELEMENT = 33;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>Preserve Aspect Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__PRESERVE_ASPECT_RATIO = SVG_ELEMENT_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 92;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 93;

	/**
	 * The number of structural features of the '<em>Image Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_IMAGE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 94;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgSwitchElementImpl <em>Switch Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgSwitchElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgSwitchElement()
	 * @generated
	 */
	int SVG_SWITCH_ELEMENT = 34;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The number of structural features of the '<em>Switch Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_SWITCH_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgPathElementImpl <em>Path Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPathElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgPathElement()
	 * @generated
	 */
	int SVG_PATH_ELEMENT = 35;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>D</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__D = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Path Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT__PATH_LENGTH = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The number of structural features of the '<em>Path Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATH_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgRectElementImpl <em>Rect Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgRectElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgRectElement()
	 * @generated
	 */
	int SVG_RECT_ELEMENT = 36;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Rx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__RX = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Ry</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT__RY = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The number of structural features of the '<em>Rect Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RECT_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgCircleElementImpl <em>Circle Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgCircleElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgCircleElement()
	 * @generated
	 */
	int SVG_CIRCLE_ELEMENT = 37;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Cx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CX = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Cy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__CY = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>R</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT__R = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The number of structural features of the '<em>Circle Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CIRCLE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgEllipseElementImpl <em>Ellipse Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgEllipseElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgEllipseElement()
	 * @generated
	 */
	int SVG_ELLIPSE_ELEMENT = 38;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Cx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CX = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Cy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__CY = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Rx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__RX = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Ry</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT__RY = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The number of structural features of the '<em>Ellipse Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ELLIPSE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgLineElementImpl <em>Line Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgLineElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgLineElement()
	 * @generated
	 */
	int SVG_LINE_ELEMENT = 39;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>X1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__X1 = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Y1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__Y1 = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>X2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__X2 = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Y2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT__Y2 = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The number of structural features of the '<em>Line Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgPolylineElementImpl <em>Polyline Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPolylineElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgPolylineElement()
	 * @generated
	 */
	int SVG_POLYLINE_ELEMENT = 40;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Points</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT__POINTS = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The number of structural features of the '<em>Polyline Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYLINE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgPolygonElementImpl <em>Polygon Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPolygonElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgPolygonElement()
	 * @generated
	 */
	int SVG_POLYGON_ELEMENT = 41;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Points</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT__POINTS = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The number of structural features of the '<em>Polygon Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_POLYGON_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgTextElementImpl <em>Text Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgTextElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgTextElement()
	 * @generated
	 */
	int SVG_TEXT_ELEMENT = 42;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Length Adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__LENGTH_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Dx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__DX = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Dy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__DY = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Rotate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__ROTATE = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>Text Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__TEXT_LENGTH = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>Text Content</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT__TEXT_CONTENT = SVG_ELEMENT_FEATURE_COUNT + 88;

	/**
	 * The number of structural features of the '<em>Text Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 89;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgTspanElementImpl <em>Tspan Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgTspanElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgTspanElement()
	 * @generated
	 */
	int SVG_TSPAN_ELEMENT = 43;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Dx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__DX = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Dy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__DY = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Rotate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__ROTATE = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Text Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__TEXT_LENGTH = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Length Adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT__LENGTH_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The number of structural features of the '<em>Tspan Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TSPAN_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgTrefElementImpl <em>Tref Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgTrefElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgTrefElement()
	 * @generated
	 */
	int SVG_TREF_ELEMENT = 44;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The number of structural features of the '<em>Tref Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TREF_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 88;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgTextPathElementImpl <em>Text Path Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgTextPathElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgTextPathElement()
	 * @generated
	 */
	int SVG_TEXT_PATH_ELEMENT = 45;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>Start Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__START_OFFSET = SVG_ELEMENT_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__METHOD = SVG_ELEMENT_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>Spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT__SPACING = SVG_ELEMENT_FEATURE_COUNT + 90;

	/**
	 * The number of structural features of the '<em>Text Path Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_TEXT_PATH_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 91;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphElementImpl <em>Alt Glyph Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgAltGlyphElement()
	 * @generated
	 */
	int SVG_ALT_GLYPH_ELEMENT = 46;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Onfocusin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONFOCUSIN = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Onfocusout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONFOCUSOUT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Onactivate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONACTIVATE = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Onclick</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONCLICK = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Onmousedown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONMOUSEDOWN = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Onmouseup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONMOUSEUP = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Onmouseover</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONMOUSEOVER = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Onmousemove</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONMOUSEMOVE = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Onmouseout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONMOUSEOUT = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Onload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ONLOAD = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>Dx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__DX = SVG_ELEMENT_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>Dy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__DY = SVG_ELEMENT_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Glyph Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__GLYPH_REF = SVG_ELEMENT_FEATURE_COUNT + 92;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__FORMAT = SVG_ELEMENT_FEATURE_COUNT + 93;

	/**
	 * The feature id for the '<em><b>Rotate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT__ROTATE = SVG_ELEMENT_FEATURE_COUNT + 94;

	/**
	 * The number of structural features of the '<em>Alt Glyph Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 95;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphDefElementImpl <em>Alt Glyph Def Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphDefElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgAltGlyphDefElement()
	 * @generated
	 */
	int SVG_ALT_GLYPH_DEF_ELEMENT = 47;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_DEF_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_DEF_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_DEF_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_DEF_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_DEF_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Alt Glyph Def Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_DEF_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphItemElementImpl <em>Alt Glyph Item Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphItemElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgAltGlyphItemElement()
	 * @generated
	 */
	int SVG_ALT_GLYPH_ITEM_ELEMENT = 48;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ITEM_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ITEM_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ITEM_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ITEM_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ITEM_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Alt Glyph Item Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_ITEM_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphRefElementImpl <em>Alt Glyph Ref Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgAltGlyphRefElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgAltGlyphRefElement()
	 * @generated
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT = 49;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Dx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__DX = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Dy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__DY = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Glyph Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__GLYPH_REF = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT__FORMAT = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The number of structural features of the '<em>Alt Glyph Ref Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_ALT_GLYPH_REF_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgMarkerElementImpl <em>Marker Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgMarkerElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgMarkerElement()
	 * @generated
	 */
	int SVG_MARKER_ELEMENT = 50;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>View Box</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__VIEW_BOX = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Preserve Aspect Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__PRESERVE_ASPECT_RATIO = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Ref X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__REF_X = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Ref Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__REF_Y = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Marker Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__MARKER_UNITS = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Marker Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__MARKER_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Marker Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__MARKER_HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Orient</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT__ORIENT = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The number of structural features of the '<em>Marker Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MARKER_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgColorProfileElementImpl <em>Color Profile Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgColorProfileElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgColorProfileElement()
	 * @generated
	 */
	int SVG_COLOR_PROFILE_ELEMENT = 51;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__LOCAL = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__NAME = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Rendering intent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT__RENDERING_INTENT = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The number of structural features of the '<em>Color Profile Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_COLOR_PROFILE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgLinearGradientElementImpl <em>Linear Gradient Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgLinearGradientElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgLinearGradientElement()
	 * @generated
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT = 52;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>X1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__X1 = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Y1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__Y1 = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>X2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__X2 = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Y2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__Y2 = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Gradient Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__GRADIENT_UNITS = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Spread Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__SPREAD_METHOD = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Gradient Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT__GRADIENT_TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The number of structural features of the '<em>Linear Gradient Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_LINEAR_GRADIENT_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgRadialGradientElementImpl <em>Radial Gradient Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgRadialGradientElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgRadialGradientElement()
	 * @generated
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT = 53;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Cx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CX = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Cy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__CY = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>R</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__R = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Fx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FX = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Fy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__FY = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Spread Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__SPREAD_METHOD = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Gradient Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__GRADIENT_UNITS = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Gradient Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT__GRADIENT_TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The number of structural features of the '<em>Radial Gradient Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_RADIAL_GRADIENT_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgStopElementImpl <em>Stop Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgStopElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgStopElement()
	 * @generated
	 */
	int SVG_STOP_ELEMENT = 54;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT__OFFSET = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The number of structural features of the '<em>Stop Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_STOP_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgPatternElementImpl <em>Pattern Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPatternElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgPatternElement()
	 * @generated
	 */
	int SVG_PATTERN_ELEMENT = 55;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>View Box</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__VIEW_BOX = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Preserve Aspect Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__PRESERVE_ASPECT_RATIO = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Pattern Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__PATTERN_UNITS = SVG_ELEMENT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Pattern Content Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__PATTERN_CONTENT_UNITS = SVG_ELEMENT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Pattern Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT__PATTERN_TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 86;

	/**
	 * The number of structural features of the '<em>Pattern Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_PATTERN_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 87;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgClipPathElementImpl <em>Clip Path Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgClipPathElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgClipPathElement()
	 * @generated
	 */
	int SVG_CLIP_PATH_ELEMENT = 56;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__TRANSFORM = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Clip Path Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT__CLIP_PATH_UNITS = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Clip Path Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_CLIP_PATH_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgMaskElementImpl <em>Mask Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgMaskElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgMaskElement()
	 * @generated
	 */
	int SVG_MASK_ELEMENT = 57;

	/**
	 * The feature id for the '<em><b>Required Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__REQUIRED_FEATURES = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required Extensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__REQUIRED_EXTENSIONS = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__SYSTEM_LANGUAGE = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Mask Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__MASK_UNITS = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Mask Content Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT__MASK_CONTENT_UNITS = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The number of structural features of the '<em>Mask Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_MASK_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFilterElementImpl <em>Filter Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFilterElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFilterElement()
	 * @generated
	 */
	int SVG_FILTER_ELEMENT = 58;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Filter Res</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FILTER_RES = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Filter Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__FILTER_UNITS = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Primitive Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT__PRIMITIVE_UNITS = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The number of structural features of the '<em>Filter Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FILTER_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeDistantLightElementImpl <em>Fe Distant Light Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeDistantLightElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeDistantLightElement()
	 * @generated
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT = 59;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Azimuth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT__AZIMUTH = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Elevation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT__ELEVATION = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Fe Distant Light Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISTANT_LIGHT_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFePointLightElementImpl <em>Fe Point Light Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFePointLightElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFePointLightElement()
	 * @generated
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT = 60;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT__Z = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Fe Point Light Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_POINT_LIGHT_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeSpotLightElementImpl <em>Fe Spot Light Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeSpotLightElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeSpotLightElement()
	 * @generated
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT = 61;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__Z = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Points At X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__POINTS_AT_X = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Points At Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__POINTS_AT_Y = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Points At Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__POINTS_AT_Z = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Specular Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__SPECULAR_EXPONENT = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Limiting Cone Angle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT__LIMITING_CONE_ANGLE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>Fe Spot Light Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPOT_LIGHT_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeBlendElementImpl <em>Fe Blend Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeBlendElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeBlendElement()
	 * @generated
	 */
	int SVG_FE_BLEND_ELEMENT = 62;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>In2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__IN2 = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT__MODE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The number of structural features of the '<em>Fe Blend Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_BLEND_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeColorMatrixElementImpl <em>Fe Color Matrix Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeColorMatrixElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeColorMatrixElement()
	 * @generated
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT = 63;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__TYPE = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Values</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT__VALUES = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The number of structural features of the '<em>Fe Color Matrix Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COLOR_MATRIX_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeComponentTransferElementImpl <em>Fe Component Transfer Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeComponentTransferElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeComponentTransferElement()
	 * @generated
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT = 64;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Fe Component Transfer Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPONENT_TRANSFER_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncRElementImpl <em>Fe Func RElement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncRElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeFuncRElement()
	 * @generated
	 */
	int SVG_FE_FUNC_RELEMENT = 65;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The number of structural features of the '<em>Fe Func RElement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_RELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncGElementImpl <em>Fe Func GElement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncGElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeFuncGElement()
	 * @generated
	 */
	int SVG_FE_FUNC_GELEMENT = 66;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The number of structural features of the '<em>Fe Func GElement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_GELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncBElementImpl <em>Fe Func BElement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncBElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeFuncBElement()
	 * @generated
	 */
	int SVG_FE_FUNC_BELEMENT = 67;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The number of structural features of the '<em>Fe Func BElement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_BELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncAElementImpl <em>Fe Func AElement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeFuncAElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeFuncAElement()
	 * @generated
	 */
	int SVG_FE_FUNC_AELEMENT = 68;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The number of structural features of the '<em>Fe Func AElement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FUNC_AELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeCompositeElementImpl <em>Fe Composite Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeCompositeElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeCompositeElement()
	 * @generated
	 */
	int SVG_FE_COMPOSITE_ELEMENT = 69;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>In2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__IN2 = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__OPERATOR = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>K1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__K1 = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>K2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__K2 = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>K3</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__K3 = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>K4</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT__K4 = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The number of structural features of the '<em>Fe Composite Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_COMPOSITE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeConvolveMatrixElementImpl <em>Fe Convolve Matrix Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeConvolveMatrixElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeConvolveMatrixElement()
	 * @generated
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT = 70;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__ORDER = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Kernel Matrix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__KERNEL_MATRIX = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Divisor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__DIVISOR = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Bias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__BIAS = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Target X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__TARGET_X = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Target Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__TARGET_Y = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Edge Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__EDGE_MODE = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Kernel Unit Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__KERNEL_UNIT_LENGTH = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Preserve Alpha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT__PRESERVE_ALPHA = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The number of structural features of the '<em>Fe Convolve Matrix Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_CONVOLVE_MATRIX_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeDiffuseLightingElementImpl <em>Fe Diffuse Lighting Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeDiffuseLightingElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeDiffuseLightingElement()
	 * @generated
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT = 71;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Surface Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__SURFACE_SCALE = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Diffuse Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__DIFFUSE_CONSTANT = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Kernel Unit Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT__KERNEL_UNIT_LENGTH = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The number of structural features of the '<em>Fe Diffuse Lighting Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DIFFUSE_LIGHTING_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeDisplacementMapElementImpl <em>Fe Displacement Map Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeDisplacementMapElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeDisplacementMapElement()
	 * @generated
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT = 72;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>In2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__IN2 = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__SCALE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>XChannel Selector</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__XCHANNEL_SELECTOR = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>YChannel Selector</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT__YCHANNEL_SELECTOR = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The number of structural features of the '<em>Fe Displacement Map Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_DISPLACEMENT_MAP_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeFloodElementImpl <em>Fe Flood Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeFloodElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeFloodElement()
	 * @generated
	 */
	int SVG_FE_FLOOD_ELEMENT = 73;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Fe Flood Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_FLOOD_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeGaussianBlurElementImpl <em>Fe Gaussian Blur Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeGaussianBlurElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeGaussianBlurElement()
	 * @generated
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT = 74;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Std Deviation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT__STD_DEVIATION = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The number of structural features of the '<em>Fe Gaussian Blur Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_GAUSSIAN_BLUR_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeImageElementImpl <em>Fe Image Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeImageElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeImageElement()
	 * @generated
	 */
	int SVG_FE_IMAGE_ELEMENT = 75;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Xlink href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XLINK_HREF = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Xlink show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XLINK_SHOW = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Xlink actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XLINK_ACTUATE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Xlink type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XLINK_TYPE = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Xlink role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XLINK_ROLE = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Xlink arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XLINK_ARCROLE = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Xlink title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__XLINK_TITLE = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Resolved Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__RESOLVED_INSTANCE = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__EXTERNAL_RESOURCES_REQUIRED = SVG_ELEMENT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Preserve Aspect Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT__PRESERVE_ASPECT_RATIO = SVG_ELEMENT_FEATURE_COUNT + 81;

	/**
	 * The number of structural features of the '<em>Fe Image Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_IMAGE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 82;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeMergeElementImpl <em>Fe Merge Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeMergeElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeMergeElement()
	 * @generated
	 */
	int SVG_FE_MERGE_ELEMENT = 76;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Fe Merge Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeMergeNodeElementImpl <em>Fe Merge Node Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeMergeNodeElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeMergeNodeElement()
	 * @generated
	 */
	int SVG_FE_MERGE_NODE_ELEMENT = 77;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_NODE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_NODE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_NODE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_NODE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_NODE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Fe Merge Node Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MERGE_NODE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeMorphologyElementImpl <em>Fe Morphology Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeMorphologyElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeMorphologyElement()
	 * @generated
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT = 78;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__OPERATOR = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT__RADIUS = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The number of structural features of the '<em>Fe Morphology Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_MORPHOLOGY_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeOffsetElementImpl <em>Fe Offset Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeOffsetElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeOffsetElement()
	 * @generated
	 */
	int SVG_FE_OFFSET_ELEMENT = 79;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Dx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__DX = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Dy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT__DY = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The number of structural features of the '<em>Fe Offset Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_OFFSET_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeSpecularLightingElementImpl <em>Fe Specular Lighting Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeSpecularLightingElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeSpecularLightingElement()
	 * @generated
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT = 80;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Surface Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__SURFACE_SCALE = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Specular Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__SPECULAR_CONSTANT = SVG_ELEMENT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Specular Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__SPECULAR_EXPONENT = SVG_ELEMENT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Kernel Unit Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT__KERNEL_UNIT_LENGTH = SVG_ELEMENT_FEATURE_COUNT + 75;

	/**
	 * The number of structural features of the '<em>Fe Specular Lighting Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_SPECULAR_LIGHTING_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 76;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeTileElementImpl <em>Fe Tile Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeTileElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeTileElement()
	 * @generated
	 */
	int SVG_FE_TILE_ELEMENT = 81;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__WRITING_MODE = SVG_ELEMENT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__X = SVG_ELEMENT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__Y = SVG_ELEMENT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__WIDTH = SVG_ELEMENT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__HEIGHT = SVG_ELEMENT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__RESULT = SVG_ELEMENT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__IN = SVG_ELEMENT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__CHILDREN = SVG_ELEMENT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__CLASS = SVG_ELEMENT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT__STYLE = SVG_ELEMENT_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Fe Tile Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TILE_ELEMENT_FEATURE_COUNT = SVG_ELEMENT_FEATURE_COUNT + 72;

	/**
	 * The meta object id for the '{@link org.eclipse.fx.formats.svg.svg.impl.SvgFeTurbulenceElementImpl <em>Fe Turbulence Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgFeTurbulenceElementImpl
	 * @see org.eclipse.fx.formats.svg.svg.impl.SvgPackageImpl#getSvgFeTurbulenceElement()
	 * @generated
	 */
	int SVG_FE_TURBULENCE_ELEMENT = 82;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__ID = SVG_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Xml base</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__XML_BASE = SVG_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__XML_LANG = SVG_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Xml space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__XML_SPACE = SVG_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Alignment baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__ALIGNMENT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Baseline shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__BASELINE_SHIFT = SVG_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__CLIP = SVG_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Clip path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__CLIP_PATH = SVG_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Clip rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__CLIP_RULE = SVG_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__COLOR = SVG_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Color interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__COLOR_INTERPOLATION = SVG_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Color interpolation filters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__COLOR_INTERPOLATION_FILTERS = SVG_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Color profile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__COLOR_PROFILE = SVG_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Color rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__COLOR_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Cursor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__CURSOR = SVG_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__DIRECTION = SVG_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__DISPLAY = SVG_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dominant baseline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__DOMINANT_BASELINE = SVG_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable background</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__ENABLE_BACKGROUND = SVG_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Fill</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FILL = SVG_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fill opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FILL_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Fill rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FILL_RULE = SVG_ELEMENT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FILTER = SVG_ELEMENT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Flood color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FLOOD_COLOR = SVG_ELEMENT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Flood opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FLOOD_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Font family</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FONT_FAMILY = SVG_ELEMENT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Font size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FONT_SIZE = SVG_ELEMENT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Font size adjust</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FONT_SIZE_ADJUST = SVG_ELEMENT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Font stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FONT_STRETCH = SVG_ELEMENT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Font style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FONT_STYLE = SVG_ELEMENT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Font variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FONT_VARIANT = SVG_ELEMENT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Font weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__FONT_WEIGHT = SVG_ELEMENT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Glyph orientation horizontal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__GLYPH_ORIENTATION_HORIZONTAL = SVG_ELEMENT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Glyph orientation vertical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__GLYPH_ORIENTATION_VERTICAL = SVG_ELEMENT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Image rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__IMAGE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Kerning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__KERNING = SVG_ELEMENT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Letter spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__LETTER_SPACING = SVG_ELEMENT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Lighting color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__LIGHTING_COLOR = SVG_ELEMENT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Marker end</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__MARKER_END = SVG_ELEMENT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Marker mid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__MARKER_MID = SVG_ELEMENT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Marker start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__MARKER_START = SVG_ELEMENT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Masks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__MASKS = SVG_ELEMENT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__OPACITY = SVG_ELEMENT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Overflow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__OVERFLOW = SVG_ELEMENT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Pointer events</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__POINTER_EVENTS = SVG_ELEMENT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Shape rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__SHAPE_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Stop color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STOP_COLOR = SVG_ELEMENT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Stop opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STOP_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Stroke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE = SVG_ELEMENT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Stroke dasharray</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE_DASHARRAY = SVG_ELEMENT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Stroke dashoffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE_DASHOFFSET = SVG_ELEMENT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Stroke linecap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE_LINECAP = SVG_ELEMENT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Stroke linejoin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE_LINEJOIN = SVG_ELEMENT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Stroke miterlimit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE_MITERLIMIT = SVG_ELEMENT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Stroke opacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE_OPACITY = SVG_ELEMENT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Stroke width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__STROKE_WIDTH = SVG_ELEMENT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Text anchor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__TEXT_ANCHOR = SVG_ELEMENT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Text decoration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__TEXT_DECORATION = SVG_ELEMENT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Text rendering</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__TEXT_RENDERING = SVG_ELEMENT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Unicode bidi</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__UNICODE_BIDI = SVG_ELEMENT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__VISIBILITY = SVG_ELEMENT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Word spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SVG_FE_TURBULENCE_ELEMENT__WORD_SPACING = SVG_ELEMENT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Writing mode</b><