/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.jfx;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.ide.css.cssext.ICSSExtModelProvider;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class JFXModelProvider
implements ICSSExtModelProvider {
    private CssExtension jfx2Model;
    private CssExtension jfx8Model;
    private Map<IVMInstall, Boolean> JDK8CACHE = new HashMap<IVMInstall, Boolean>();
    private Logger logger;

    public Collection<CssExtension> getModels(IFile file) {
        try {
            System.err.println("logger: " + this.logger.isEnabled(Logger.Level.DEBUG));
            this.logger.debug("Resolving models on file '" + file + "'");
            if (!this.isJDTProject(file.getProject())) {
                this.logger.debug("Project is not a JDT-Project");
                return Collections.emptySet();
            }
            IJavaProject jp = JavaCore.create((IProject)file.getProject());
            IVMInstall i = JavaRuntime.getVMInstall((IJavaProject)jp);
            if (i == null) {
                this.logger.debug("No VM-Install found using default");
                i = JavaRuntime.getDefaultVMInstall();
            }
            this.logger.debug("Java Runtime is " + i);
            if (!this.isJava8(i)) {
                if (this.jfx2Model == null) {
                    this.jfx2Model = this.loadModel("jfx2");
                }
                this.logger.debug("This is Java7");
                return Collections.singleton(this.jfx2Model);
            }
            if (this.jfx8Model == null) {
                this.jfx8Model = this.loadModel("jfx8");
            }
            this.logger.debug("This is Java8");
            return Collections.singleton(this.jfx8Model);
        }
        catch (CoreException e) {
            this.logger.error("Failed to extract JDT informations", (Throwable)e);
            this.logger.debug("No format CSS-Ext files are found");
            return Collections.emptySet();
        }
    }

    private boolean isJava8(IVMInstall i) {
        Boolean rv = this.JDK8CACHE.get(i);
        if (rv != null) {
            return rv;
        }
        LibraryLocation[] libraryLocationArray = JavaRuntime.getLibraryLocations((IVMInstall)i);
        int n = libraryLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryLocation l = libraryLocationArray[n2];
            if ("jfxrt.jar".equals(l.getSystemLibraryPath().lastSegment())) {
                this.JDK8CACHE.put(i, Boolean.TRUE);
                return true;
            }
            ++n2;
        }
        this.JDK8CACHE.put(i, Boolean.FALSE);
        return false;
    }

    private boolean isJDTProject(IProject p) throws CoreException {
        return p.getNature("org.eclipse.jdt.core.javanature") != null;
    }

    private CssExtension loadModel(String name) {
        URI uri = URI.createPlatformPluginURI((String)("/org.eclipse.fx.ide.css.jfx/OSGI-INF/" + name + ".cssext"), (boolean)true);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.getResource(uri, true);
        CssExtension model = (CssExtension)resource.getContents().get(0);
        return model;
    }

    public void bindLoggerFactory(LoggerFactory factory) {
        this.logger = factory.createLogger(this.getClass().getName());
    }

    public void unbindLoggerFactory(LoggerFactory factory) {
        this.logger = null;
    }
}

