/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.pde.ui.e4.project.boot;

import org.eclipse.fx.ide.pde.ui.e4.project.boot.AppBundleProjectData;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class GeneratorConfigurationPage
extends WizardPage {
    private AppBundleProjectData data;
    private Button jemmyButton;
    private Button tychoButton;
    private Button nativePackaging;
    private Text productName;
    private ModifyListener propertiesListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneratorConfigurationPage.this.setPageComplete(GeneratorConfigurationPage.this.validate());
        }
    };
    private SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GeneratorConfigurationPage.this.setPageComplete(GeneratorConfigurationPage.this.validate());
        }
    };

    public GeneratorConfigurationPage(AppBundleProjectData data, String pageName, String title) {
        super(pageName, title, null);
        this.data = data;
        this.setPageComplete(false);
    }

    protected boolean validate() {
        this.setErrorMessage(null);
        if (this.productName.getText().trim().isEmpty()) {
            this.setErrorMessage("You need to enter a product name");
            return false;
        }
        this.data.setProductName(this.productName.getText());
        this.data.setJemmyTest(this.jemmyButton.getSelection());
        this.data.setTychoIntegration(this.tychoButton.getSelection());
        this.data.setNativeExport(this.nativePackaging.getSelection());
        return true;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Customizations");
        group.setLayout((Layout)new GridLayout(2, false));
        this.createLabel((Composite)group, "Product Name:");
        this.productName = this.createText((Composite)group, this.propertiesListener, 1);
        this.productName.setMessage("Enter a product name");
        this.createLabel((Composite)group, "Jemmy Unittest stubs:");
        this.jemmyButton = this.createCheckbox((Composite)group, this.listener);
        this.jemmyButton.setSelection(this.data.isJemmyTest());
        this.jemmyButton.setEnabled(this.data.isJemmyTest());
        this.createLabel((Composite)group, "Tycho Build Stubs:");
        this.tychoButton = this.createCheckbox((Composite)group, this.listener);
        this.tychoButton.setSelection(this.data.isTychoIntegration());
        this.createLabel((Composite)group, "Native packaging:");
        this.nativePackaging = this.createCheckbox((Composite)group, this.listener);
        this.nativePackaging.setSelection(this.data.isNativeExport());
        this.setControl((Control)container);
    }

    protected Text createText(Composite parent, ModifyListener listener, int horizSpan) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.horizontalSpan = horizSpan;
        text.setLayoutData((Object)data);
        text.addModifyListener(listener);
        return text;
    }

    private Button createCheckbox(Composite container, SelectionListener listener) {
        Button b = new Button(container, 32);
        b.addSelectionListener(listener);
        return b;
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        return label;
    }
}

