/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fx.ide.jdt.core.FXVersionUtil;
import org.eclipse.fx.ide.jdt.core.internal.BuildPathSupport;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public class JavaFXClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public static IClasspathEntry getCssExtClasspathEntry(IJavaProject project) {
        try {
            return JavaFXClasspathContainerInitializer.getCssExtClasspathEntry(JavaRuntime.getVMInstall((IJavaProject)project));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IClasspathEntry getCssExtClasspathEntry(IVMInstall i) {
        switch (FXVersionUtil.getFxVersion(i)) {
            case FX2: {
                return JavaFXClasspathContainerInitializer.getBundleAsEntryByName("org.eclipse.fx.ide.css.jfx2");
            }
            case FX8: {
                return JavaFXClasspathContainerInitializer.getBundleAsEntryByName("org.eclipse.fx.ide.css.jfx8");
            }
        }
        return null;
    }

    private static IClasspathEntry getBundleAsEntryByName(String name) {
        try {
            Bundle bundle = Platform.getBundle((String)name);
            if (bundle != null) {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                Path path = new Path(bundleFile.getAbsolutePath());
                return JavaCore.newLibraryEntry((IPath)path, null, null);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        System.err.println("requestUpdate " + containerSuggestion);
        if (JavaFXClasspathContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            JavaFXContainer container = JavaFXClasspathContainerInitializer.getNewContainer(containerPath, project);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public void initialize(final IPath containerPath, final IJavaProject project) throws CoreException {
        if (JavaFXClasspathContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            JavaFXContainer container = JavaFXClasspathContainerInitializer.getNewContainer(containerPath, project);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
        IElementChangedListener listener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                if (event.getDelta().getKind() == 4 && (event.getDelta().getFlags() & 8) == 8) {
                    IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
                    int n = iJavaElementDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElementDelta delta = iJavaElementDeltaArray[n2];
                        if ((delta.getFlags() & 0x20000) == 131072 && delta.getElement().getElementType() == 2 && delta.getElement().getJavaProject().equals(project)) {
                            try {
                                JavaFXClasspathContainerInitializer.this.requestClasspathContainerUpdate(containerPath, project, null);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                }
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)listener);
    }

    private static JavaFXContainer getNewContainer(IPath containerPath, IJavaProject project) {
        IClasspathEntry jfxLibEntry = BuildPathSupport.getJavaFXLibraryEntry(project);
        IClasspathEntry cssExtEntry = JavaFXClasspathContainerInitializer.getCssExtClasspathEntry(project);
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        if (jfxLibEntry != null) {
            entries.add(jfxLibEntry);
        }
        if (cssExtEntry != null) {
            entries.add(cssExtEntry);
        }
        return new JavaFXContainer(containerPath, entries.toArray(new IClasspathEntry[0]));
    }

    private static boolean isValidJUnitContainerPath(IPath path) {
        return path != null && "org.eclipse.fx.ide.jdt.core.JAVAFX_CONTAINER".equals(path.segment(0));
    }

    private static class JavaFXContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public JavaFXContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            return "JavaFX SDK";
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

