/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.mobile.sim.device;

import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Rectangle;

public abstract class BasicDevice {
    private BorderPane pane;
    private AnchorPane contentPane;
    private double contentWidth;
    private double contentHeight;

    protected abstract BorderPane createContentPane();

    protected abstract double marginWidth();

    protected abstract double marginHeight();

    public BasicDevice(double contentWidth, double contentHeight) {
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
    }

    public void setContentSize(double width, double height) {
        if (this.pane == null) {
            this.contentWidth = width;
            this.contentHeight = height;
        } else {
            this.contentPane.setClip((Node)new Rectangle(0.0, 0.0, width, height));
            this.contentPane.setPrefSize(width, height);
            this.contentPane.setMinSize(width, height);
            this.contentPane.setMaxSize(width, height);
            double wPlus = this.marginWidth();
            double hPlus = this.marginHeight();
            this.pane.setMinSize(width + wPlus, height + hPlus);
            this.pane.setPrefSize(width + wPlus, height + hPlus);
            this.pane.setMaxSize(width + wPlus, height + hPlus);
        }
    }

    public void setContent(Node node) {
        AnchorPane.setLeftAnchor((Node)node, (Double)0.0);
        AnchorPane.setRightAnchor((Node)node, (Double)0.0);
        AnchorPane.setTopAnchor((Node)node, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)node, (Double)0.0);
        this.contentPane.getChildren().setAll((Object[])new Node[]{node});
    }

    public Node getSimulatorNode() {
        if (this.pane == null) {
            this.pane = this.createContentPane();
            this.contentPane = new AnchorPane();
            this.pane.setCenter((Node)this.contentPane);
            this.setContentSize(this.contentWidth, this.contentHeight);
        }
        return this.pane;
    }

    protected static String getIconUrl(String url) {
        System.err.println("RESOURCE: " + url);
        return BasicDevice.class.getClassLoader().getResource(url).toExternalForm();
    }
}

