/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.filesystem.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.eclipse.fx.ui.controls.filesystem.DirItem;
import org.eclipse.fx.ui.controls.filesystem.DirectoryView;
import org.eclipse.fx.ui.controls.filesystem.FileItem;
import org.eclipse.fx.ui.controls.filesystem.IconSize;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;
import org.eclipse.fx.ui.controls.filesystem.behavior.DirectoryViewBehavior;
import org.eclipse.jdt.annotation.NonNull;

public class DirectoryViewSkin
extends BehaviorSkinBase<DirectoryView, DirectoryViewBehavior> {
    private ObservableList<@NonNull ResourceItem> elements = FXCollections.observableArrayList();
    private final ObservableList<ResourceItem> selectedItems;
    private DirItem currentItem;

    public DirectoryViewSkin(DirectoryView control, ObservableList<ResourceItem> selectedItems) {
        super((Control)control, (BehaviorBase)new DirectoryViewBehavior(control));
        this.selectedItems = selectedItems;
        control.dirProperty().addListener(this::pathChangedHandler);
        this.setupView();
        this.pathChangedHandler((Observable)((DirectoryView)this.getSkinnable()).dirProperty());
    }

    private void setupView() {
        switch (((DirectoryView)this.getSkinnable()).getDisplayType()) {
            // Empty switch
        }
        Node n = this.setupListView();
        this.getChildren().setAll((Object[])new Node[]{n});
    }

    private Node setupListView() {
        TableView t = new TableView();
        t.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ResourceBundle b = ResourceBundle.getBundle("org.eclipse.fx.ui.controls.filesystem.skin.resource");
        TableColumn c = new TableColumn(b.getString("DirectoryViewSkin_Name"));
        c.setPrefWidth(400.0);
        c.setMinWidth(400.0);
        c.setCellFactory(co -> new NameTableCell());
        c.setCellValueFactory(cdf -> new SimpleObjectProperty((Object)((ResourceItem)cdf.getValue())));
        t.getColumns().add((Object)c);
        c = new TableColumn(b.getString("DirectoryViewSkin_ChangeDate"));
        c.setMinWidth(100.0);
        c.setCellFactory(co -> new LastModifiedCell());
        c.setCellValueFactory(cdf -> ((ResourceItem)cdf.getValue()).lastModifiedProperty());
        t.getColumns().add((Object)c);
        c = new TableColumn(b.getString("DirectoryViewSkin_Size"));
        c.setCellFactory(co -> new SizeCell());
        c.setCellValueFactory(cdf -> {
            if (cdf.getValue() instanceof DirItem) {
                return new SimpleObjectProperty(null);
            }
            return ((FileItem)cdf.getValue()).fileSizeProperty();
        });
        c.setMinWidth(100.0);
        t.getColumns().add((Object)c);
        t.setItems(this.elements);
        t.setOnMouseReleased(e -> {
            if (e.getClickCount() == 2) {
                ((DirectoryViewBehavior)this.getBehavior()).openSelectedResources();
            }
        });
        Bindings.bindContent(this.selectedItems, (ObservableList)t.getSelectionModel().getSelectedItems());
        return t;
    }

    private void pathChangedHandler(Observable o) {
        if (this.currentItem != null) {
            Bindings.unbindContent(this.elements, this.currentItem.getChildren());
        }
        this.elements.clear();
        this.currentItem = ((DirectoryView)this.getSkinnable()).getDir();
        if (this.currentItem != null) {
            Bindings.bindContent(this.elements, this.currentItem.getChildren());
        }
    }

    static int size(IconSize s) {
        switch (s) {
            case SMALL: {
                return 26;
            }
            case MEDIUM: {
                return 42;
            }
        }
        return 58;
    }

    class LastModifiedCell
    extends TableCell<ResourceItem, LocalDateTime> {
        public LastModifiedCell() {
            this.setAlignment(Pos.CENTER_LEFT);
        }

        protected void updateItem(LocalDateTime item, boolean empty) {
            if (item != null && !empty) {
                this.setText(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(item));
            } else {
                this.setText(null);
            }
            super.updateItem((Object)item, empty);
        }
    }

    class NameTableCell
    extends TableCell<ResourceItem, ResourceItem> {
        NameTableCell() {
        }

        protected void updateItem(ResourceItem item, boolean empty) {
            if (item != null && !empty) {
                Label l = new Label();
                ImageView v = new ImageView();
                if (item instanceof DirItem) {
                    String styleClass;
                    switch (((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) {
                        case SMALL: {
                            styleClass = "folderSmall";
                            break;
                        }
                        case MEDIUM: {
                            styleClass = "folderMedium";
                            break;
                        }
                        default: {
                            styleClass = "folderBig";
                        }
                    }
                    v.getStyleClass().add((Object)styleClass);
                } else if (item.getName().endsWith(".gif") || item.getName().endsWith(".png") || item.getName().endsWith(".jpg")) {
                    int size;
                    switch (((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) {
                        case SMALL: {
                            size = 16;
                            break;
                        }
                        case MEDIUM: {
                            size = 32;
                            break;
                        }
                        default: {
                            size = 48;
                        }
                    }
                    Image img = new Image(item.getUri(), (double)size, (double)size, true, true, true);
                    v.setImage(img);
                } else {
                    String styleClass;
                    switch (((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) {
                        case SMALL: {
                            styleClass = "fileSmall";
                            break;
                        }
                        case MEDIUM: {
                            styleClass = "fileMedium";
                            break;
                        }
                        default: {
                            styleClass = "fileBig";
                        }
                    }
                    v.getStyleClass().add((Object)styleClass);
                }
                l.setGraphic((Node)v);
                l.setText(item.getName());
                v.setFitWidth((double)(DirectoryViewSkin.size(((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()) - 10));
                v.setPreserveRatio(true);
                l.setMaxHeight((double)DirectoryViewSkin.size(((DirectoryView)DirectoryViewSkin.this.getSkinnable()).getIconSize()));
                this.setGraphic((Node)l);
            } else {
                this.setGraphic(null);
            }
            super.updateItem((Object)item, empty);
        }
    }

    static class SizeCell
    extends TableCell<ResourceItem, Long> {
        private static NumberFormat BYTE_FORMAT = new DecimalFormat("#,##0 'Bytes'");
        private static NumberFormat KB_FORMAT = new DecimalFormat("#,##0 'KB'");
        private static NumberFormat MB_FORMAT = new DecimalFormat("#,##0.0 'MB'");

        public SizeCell() {
            this.setAlignment(Pos.CENTER_RIGHT);
        }

        protected void updateItem(Long item, boolean empty) {
            if (!empty) {
                if (item == null) {
                    this.setText("--");
                } else if (item >= 1000000L) {
                    this.setText(MB_FORMAT.format((double)item.longValue() / 1048576.0));
                } else if (item >= 1000L) {
                    this.setText(KB_FORMAT.format((double)item.longValue() / 1000.0));
                } else {
                    this.setText(BYTE_FORMAT.format(item));
                }
            } else {
                this.setText(null);
            }
            super.updateItem((Object)item, empty);
        }
    }
}

