/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Font_style implements Enumerator
{
    NORMAL(0, "normal", "normal"),
    ITALIC(1, "italic", "italic"),
    OBLIQUE(2, "oblique", "oblique"),
    INHERIT(3, "inherit", "inherit");

    public static final int NORMAL_VALUE = 0;
    public static final int ITALIC_VALUE = 1;
    public static final int OBLIQUE_VALUE = 2;
    public static final int INHERIT_VALUE = 3;
    private static final Font_style[] VALUES_ARRAY;
    public static final List<Font_style> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Font_style[]{NORMAL, ITALIC, OBLIQUE, INHERIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Font_style get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Font_style result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Font_style getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Font_style result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Font_style get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return ITALIC;
            }
            case 2: {
                return OBLIQUE;
            }
            case 3: {
                return INHERIT;
            }
        }
        return null;
    }

    private Font_style(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

