/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.handler;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.jdt.ui.internal.JavaFXUIPlugin;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTask;
import org.eclipse.fx.ide.jdt.ui.internal.handler.AbstractAntHandler;
import org.eclipse.fx.ide.jdt.ui.internal.handler.CreateBuildXML;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall3;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public abstract class AbstractBuildHandler
extends AbstractAntHandler {
    private static Logger LOGGER = LoggerCreator.createLogger(AbstractBuildHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        IFile f = this.getConfigurationFile(context);
        if (f == null) {
            return null;
        }
        try {
            URI resourceURI = URI.createPlatformResourceURI((String)f.getFullPath().toString(), (boolean)true);
            Resource resource = null;
            try {
                resource = new ResourceSetImpl().getResource(resourceURI, true);
            }
            catch (Exception e) {
                resource = new ResourceSetImpl().getResource(resourceURI, false);
            }
            AntTask task = (AntTask)resource.getContents().get(0);
            InputStream in = f.getContents();
            in.close();
            AbstractAntHandler.BuildConfiguration rv = this.prepareBuild(f, task);
            if (rv != null) {
                CreateBuildXML b = new CreateBuildXML();
                File buildFile = b.run(rv);
                f.getProject().refreshLocal(2, null);
                ILaunchConfiguration cfg = this.getLaunchConfig(buildFile, rv, f);
                if (cfg != null && this.launchAnt()) {
                    DebugUITools.launch((ILaunchConfiguration)cfg, (String)"run");
                }
            }
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to export application", (Throwable)e);
        }
        return null;
    }

    protected abstract boolean launchAnt();

    protected abstract IFile getConfigurationFile(IEvaluationContext var1);

    private ILaunchConfiguration getLaunchConfig(File buildFile, AbstractAntHandler.BuildConfiguration cfgData, IFile buildCfgFile) throws CoreException {
        ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = mgr.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        if (type != null) {
            ILaunchConfiguration cfg;
            Object name = (String)cfgData.builderName;
            if (name == null) {
                name = "JFX Build - " + cfgData.projectName;
            }
            File fBuildFile = new File(cfgData.buildDirectory + "/build.xml");
            ILaunchConfiguration[] iLaunchConfigurationArray = mgr.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                cfg = iLaunchConfigurationArray[n2];
                if (cfg.getName().equals(name)) {
                    String s = cfg.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
                    if (!s.equals("") && new File(s).equals(fBuildFile)) {
                        return cfg;
                    }
                    cfg.delete();
                }
                ++n2;
            }
            cfg = type.newInstance(null, (String)name);
            cfg.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", buildFile.getAbsolutePath());
            cfg.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", buildFile.getParentFile().getAbsolutePath());
            cfg.setAttribute("org.eclipse.debug.core.ATTR_REFRESH_SCOPE", "${project}");
            cfg.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
            cfg.setAttribute("org.eclipse.jdt.launching.MAIN_TYPE", "org.eclipse.ant.internal.launching.remote.InternalAntRunner");
            cfg.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
            IVMInstall install = null;
            IClasspathEntry[] iClasspathEntryArray = this.project.getRawClasspath();
            int n3 = iClasspathEntryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IClasspathEntry e = iClasspathEntryArray[n4];
                String start = e.getPath().segment(0);
                if (start.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    install = JavaRuntime.getVMInstall((IPath)e.getPath());
                    cfg.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, e.getPath().toString());
                }
                ++n4;
            }
            if (!AbstractBuildHandler.isJDK(install)) {
                if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Not a JDK", (String)"The project is attached to a JRE only so ant would be started with a JRE which does not have a compiler. Would you like to proceed and select a JDK?")) {
                    JDKSelectionDialog d = new JDKSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    if (d.open() == 0) {
                        cfg.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)d.install).toString());
                    }
                } else {
                    return null;
                }
            }
            if (AbstractBuildHandler.isAnt18AndJDK8(install)) {
                cfg.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "-Dbuild.compiler=javac1.7");
            }
            cfg.doSave();
            return cfg;
        }
        return null;
    }

    static boolean isJDK(IVMInstall install) {
        if (install == null) {
            return false;
        }
        File f = install.getInstallLocation();
        File tools = new File(new File(f, "lib"), "tools.jar");
        return tools.exists();
    }

    static boolean isAnt18AndJDK8(IVMInstall install) {
        boolean rv = true;
        try {
            Bundle b;
            String version;
            if (install instanceof IVMInstall3 && (version = (String)((IVMInstall3)install).evaluateSystemProperties(new String[]{"java.version"}, (IProgressMonitor)new NullProgressMonitor()).get("java.version")) != null) {
                rv = version.startsWith("1.8.0");
            }
            if (rv && (b = Platform.getBundle((String)"org.apache.ant")).getVersion().toString().startsWith("1.9")) {
                return false;
            }
        }
        catch (CoreException e) {
            LOGGER.error("Unable to detect java version", (Throwable)e);
        }
        return rv;
    }

    static class JDKSelectionDialog
    extends TitleAreaDialog {
        private TableViewer viewer;
        private IVMInstall install;

        public JDKSelectionDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite content = (Composite)super.createDialogArea(parent);
            this.getShell().setText("Select a JDK");
            this.setTitle("Select a JDK");
            this.setMessage("To build your product you need to run ant with a JDK. Select one in the list below");
            parent = new Composite(content, 0);
            parent.setLayoutData((Object)new GridData(1808));
            parent.setLayout((Layout)new GridLayout());
            Label l = new Label(parent, 0);
            l.setText("Select a JDK");
            this.viewer = new TableViewer(parent, 68352);
            this.viewer.getControl().setLayoutData((Object)new GridData(1808));
            this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

                public void update(ViewerCell cell) {
                    IVMInstall install = (IVMInstall)cell.getElement();
                    StyledString s = new StyledString(install.getName());
                    s.append(" - " + install.getInstallLocation().getAbsolutePath(), StyledString.DECORATIONS_STYLER);
                    cell.setStyleRanges(s.getStyleRanges());
                    cell.setText(s.getString());
                    cell.setImage(JavaFXUIPlugin.getDefault().getImageRegistry().getDescriptor(JavaFXUIPlugin.LIBRARY_ICON).createImage());
                }
            });
            List<IVMInstall> installs = this.getWorkspaceJREs();
            Iterator<IVMInstall> it = installs.iterator();
            while (it.hasNext()) {
                if (AbstractBuildHandler.isJDK(it.next())) continue;
                it.remove();
            }
            this.viewer.setInput(installs);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection s = event.getSelection();
                    if (s.isEmpty()) {
                        this.getButton(0).setEnabled(false);
                    } else {
                        install = (IVMInstall)((IStructuredSelection)s).getFirstElement();
                        this.getButton(0).setEnabled(true);
                    }
                }
            });
            return content;
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            Button b = super.createButton(parent, id, label, defaultButton);
            if (id == 0) {
                b.setEnabled(false);
            }
            return b;
        }

        private List<IVMInstall> getWorkspaceJREs() {
            ArrayList<IVMInstall> standins = new ArrayList<IVMInstall>();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    standins.add((IVMInstall)new VMStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins;
        }
    }
}

