/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl.generators;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.ide.rrobot.model.bundle.Element;
import org.eclipse.fx.ide.rrobot.model.bundle.Extension;
import org.eclipse.fx.ide.rrobot.model.bundle.PluginXMLFile;
import org.eclipse.fx.ide.rrobot.model.task.BooleanExpression;
import org.eclipse.fx.ide.rrobot.model.task.ExcludeableElementMixin;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PluginXMLGenerator
implements Generator<PluginXMLFile> {
    public InputStream generate(PluginXMLFile file, Map<String, Object> data) {
        byte[] _bytes = this.generateContent(file, data).toString().getBytes();
        return new ByteArrayInputStream(_bytes);
    }

    public CharSequence generateContent(PluginXMLFile file, Map<String, Object> data) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<?eclipse version=\"3.0\"?>");
        _builder.newLine();
        _builder.append("<plugin>");
        _builder.newLine();
        Functions.Function1 _function = e -> this.excludeExpression((ExcludeableElementMixin)e, data);
        Iterable _filter = IterableExtensions.filter((Iterable)file.getExtensions(), (Functions.Function1)_function);
        for (Extension ext : _filter) {
            boolean _notEquals;
            _builder.append("<extension ");
            String _id = ext.getId();
            boolean bl = _notEquals = !Objects.equals(_id, null);
            if (_notEquals) {
                _builder.append("id=\"");
                String _id_1 = ext.getId();
                _builder.append(_id_1);
                _builder.append("\"");
            }
            _builder.append(" point=\"");
            String _point = ext.getPoint();
            _builder.append(_point);
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            EList _elements = ext.getElements();
            for (Element el : _elements) {
                _builder.append("\t");
                CharSequence _elementBuilder = this.elementBuilder(el);
                _builder.append((Object)_elementBuilder, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("</extension>");
            _builder.newLine();
        }
        _builder.append("</plugin>");
        _builder.newLine();
        return _builder;
    }

    public boolean excludeExpression(ExcludeableElementMixin mixin, Map<String, Object> data) {
        boolean _notEquals;
        BooleanExpression _excludeExpression = mixin.getExcludeExpression();
        boolean bl = _notEquals = !Objects.equals(_excludeExpression, null);
        if (_notEquals) {
            boolean _execute = mixin.getExcludeExpression().execute(data);
            return !_execute;
        }
        return true;
    }

    public CharSequence elementBuilder(Element el) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<");
        String _name = el.getName();
        _builder.append(_name);
        _builder.append(" ");
        Functions.Function1 _function = a -> {
            String _name_1 = a.getName();
            String _plus = _name_1 + "=\"";
            String _value = a.getValue();
            String _plus_1 = _plus + _value;
            return _plus_1 + "\"";
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)el.getAttributes(), (Functions.Function1)_function), (CharSequence)" ");
        _builder.append(_join);
        _builder.append(" ");
        boolean _isEmpty = el.getChildren().isEmpty();
        if (_isEmpty) {
            _builder.append("/");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty_1 = el.getChildren().isEmpty();
        boolean bl = _not = !_isEmpty_1;
        if (_not) {
            EList _children = el.getChildren();
            for (Element c : _children) {
                _builder.append("\t");
                CharSequence _elementBuilder = this.elementBuilder(c);
                _builder.append((Object)_elementBuilder, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("</");
            String _name_1 = el.getName();
            _builder.append(_name_1);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }
}

