/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.proposals.internal.paint;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.eclipse.fx.ide.css.extapi.Proposal;
import org.eclipse.fx.ide.css.ui.extapi.UIProposal;
import org.eclipse.fx.ui.controls.paint.PaintEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PaintProposal
implements UIProposal {
    private String proposal;

    public Object getAdditionalInfo() {
        return null;
    }

    public String getProposal() {
        return this.proposal;
    }

    public String getImageUrl() {
        return null;
    }

    public String getLabel() {
        return "Pick Paint...";
    }

    public int getPriority() {
        return 3;
    }

    public boolean show() {
        Shell shell = new Shell();
        FXCanvas canvas = new FXCanvas((Composite)shell, 0);
        PaintEditor editor = new PaintEditor(null, new PaintEditor.State[]{PaintEditor.State.OK, PaintEditor.State.CANCEL});
        Scene scene = new Scene((Parent)editor);
        canvas.setScene(scene);
        shell.setLayout((Layout)new FillLayout());
        shell.open();
        shell.pack();
        AtomicBoolean bla = new AtomicBoolean();
        bla.set(true);
        editor.setStateConsumer((s, o) -> {
            if (s == PaintEditor.State.OK) {
                this.update((Paint)o);
                bla.set(true);
                shell.dispose();
            } else if (s == PaintEditor.State.CANCEL) {
                bla.set(false);
                shell.dispose();
            }
        });
        Display d = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        return this.proposal != null ? bla.get() : false;
    }

    private void update(Paint paint) {
        if (paint instanceof LinearGradient) {
            LinearGradient g = (LinearGradient)paint;
            if (g.isProportional()) {
                this.proposal = "linear-gradient( ";
                this.proposal = String.valueOf(this.proposal) + "from " + PaintProposal.p(g.getStartX()) + "% " + PaintProposal.p(g.getStartY()) + "% ";
                this.proposal = String.valueOf(this.proposal) + "to " + PaintProposal.p(g.getEndX()) + "% " + PaintProposal.p(g.getEndY()) + "%";
                if (g.getCycleMethod() == CycleMethod.REFLECT) {
                    this.proposal = String.valueOf(this.proposal) + ", reflect";
                } else if (g.getCycleMethod() == CycleMethod.REPEAT) {
                    this.proposal = String.valueOf(this.proposal) + ", repeat";
                }
                this.proposal = String.valueOf(this.proposal) + PaintProposal.stopAsString(g.getStops());
                this.proposal = String.valueOf(this.proposal) + ")";
            } else {
                this.proposal = "linear-gradient( ";
                this.proposal = String.valueOf(this.proposal) + "from " + g.getStartX() + " " + g.getStartY() + " ";
                this.proposal = String.valueOf(this.proposal) + "to " + g.getEndX() + " " + g.getEndY();
                if (g.getCycleMethod() == CycleMethod.REFLECT) {
                    this.proposal = String.valueOf(this.proposal) + ", reflect";
                } else if (g.getCycleMethod() == CycleMethod.REPEAT) {
                    this.proposal = String.valueOf(this.proposal) + ", repeat";
                }
                this.proposal = String.valueOf(this.proposal) + PaintProposal.stopAsString(g.getStops());
                this.proposal = String.valueOf(this.proposal) + " )";
            }
        } else if (paint instanceof RadialGradient) {
            RadialGradient g = (RadialGradient)paint;
            if (g.isProportional()) {
                this.proposal = "radial-gradient( ";
                this.proposal = String.valueOf(this.proposal) + "focus-angle " + g.getFocusAngle() + "deg";
                this.proposal = String.valueOf(this.proposal) + ", focus-distance " + PaintProposal.p(g.getFocusDistance()) + "%";
                this.proposal = String.valueOf(this.proposal) + ", center " + PaintProposal.p(g.getCenterX()) + "% " + PaintProposal.p(g.getCenterY()) + "%";
                this.proposal = String.valueOf(this.proposal) + ", radius " + PaintProposal.p(g.getRadius()) + "%";
                if (g.getCycleMethod() == CycleMethod.REFLECT) {
                    this.proposal = String.valueOf(this.proposal) + ", reflect";
                } else if (g.getCycleMethod() == CycleMethod.REPEAT) {
                    this.proposal = String.valueOf(this.proposal) + ", repeat";
                }
                this.proposal = String.valueOf(this.proposal) + PaintProposal.stopAsString(g.getStops());
                this.proposal = String.valueOf(this.proposal) + " )";
            } else {
                this.proposal = "radial-gradient( ";
                this.proposal = String.valueOf(this.proposal) + "focus-angle " + g.getFocusAngle() + "deg";
                this.proposal = String.valueOf(this.proposal) + ", focus-distance " + PaintProposal.p(g.getFocusDistance()) + "%";
                this.proposal = String.valueOf(this.proposal) + ", center " + g.getCenterX() + " " + g.getCenterY();
                this.proposal = String.valueOf(this.proposal) + ", radius " + g.getRadius();
                if (g.getCycleMethod() == CycleMethod.REFLECT) {
                    this.proposal = String.valueOf(this.proposal) + ", reflect";
                } else if (g.getCycleMethod() == CycleMethod.REPEAT) {
                    this.proposal = String.valueOf(this.proposal) + ", repeat";
                }
                this.proposal = String.valueOf(this.proposal) + PaintProposal.stopAsString(g.getStops());
                this.proposal = String.valueOf(this.proposal) + " )";
            }
        } else if (paint instanceof Color) {
            this.proposal = PaintProposal.rgb((Color)paint);
        }
    }

    private static String stopAsString(List<Stop> stops) {
        return stops.stream().map(s -> PaintProposal.rgb(s.getColor()) + " " + PaintProposal.p(s.getOffset())).collect(Collectors.joining(", ", ", ", ""));
    }

    private static String rgb(Color c) {
        Object rv = "";
        rv = c.getOpacity() == 1.0 ? (String)rv + "rgb(" : (String)rv + "rgba(";
        rv = (String)rv + PaintProposal.toInt(c.getRed()) + "," + PaintProposal.toInt(c.getGreen()) + "," + PaintProposal.toInt(c.getBlue());
        if (c.getOpacity() != 1.0) {
            rv = (String)rv + "," + c.getOpacity();
        }
        rv = (String)rv + ")";
        return rv;
    }

    private static int toInt(double v) {
        return (int)(v * 255.0);
    }

    private static double p(double v) {
        return v * 100.0;
    }

    public boolean hide() {
        return false;
    }

    public Proposal.Type getType() {
        return Proposal.Type.Value;
    }
}

