/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class VFlow<N extends Node>
extends Pane {
    private Object sync = new Object();
    private Supplier<N> nodeFactory;
    private BiConsumer<N, Integer> nodePopulator;
    private Map<Integer, N> activeNodes = new HashMap<Integer, N>();
    private Queue<N> freeNodes = new LinkedList<N>();
    private DoubleProperty lineHeigth = new SimpleDoubleProperty((Object)this, "lineHeight", 16.0);
    private IntegerProperty numberOfLines = new SimpleIntegerProperty((Object)this, "numberOfLines", 0);
    private DoubleProperty yOffset = new SimpleDoubleProperty((Object)this, "yOffset", 0.0);
    private ObjectProperty<Range<Integer>> visibleLines = new SimpleObjectProperty((Object)this, "visibleLines", (Object)Range.all());
    private Consumer<N> onRelease;
    private BiConsumer<Integer, N> onActivate;

    public DoubleProperty lineHeightProperty() {
        return this.lineHeigth;
    }

    public double getLineHeight() {
        return this.lineHeigth.get();
    }

    public void setLineHeight(double lineHeight) {
        this.lineHeigth.set(lineHeight);
    }

    public IntegerProperty numberOfLinesProperty() {
        return this.numberOfLines;
    }

    public int getNumberOfLines() {
        return this.numberOfLines.get();
    }

    public void setNumberOfLines(int lines) {
        this.numberOfLines.set(lines);
    }

    public DoubleProperty yOffsetProperty() {
        return this.yOffset;
    }

    public double getYOffset() {
        return this.yOffset.get();
    }

    public void setYOffset(double yOffset) {
        this.yOffset.set(yOffset);
    }

    public ObjectProperty<Range<Integer>> visibleLinesProperty() {
        return this.visibleLines;
    }

    public Range<Integer> getVisibleLines() {
        return (Range)this.visibleLines.get();
    }

    public void setVisibleLines(Range<Integer> visibleLines) {
        this.visibleLines.set(visibleLines);
    }

    protected void setOnRelease(Consumer<N> onRelease) {
        this.onRelease = onRelease;
    }

    protected void setOnActivate(BiConsumer<Integer, N> onActivate) {
        this.onActivate = onActivate;
    }

    public VFlow(Supplier<N> nodeFactory, BiConsumer<N, Integer> nodePopulator) {
        this.nodeFactory = nodeFactory;
        this.nodePopulator = nodePopulator;
        this.visibleLines.addListener(this::onVisibleLinesChange);
        this.yOffset.addListener(x -> this.requestLayout());
        this.numberOfLines.addListener(this::onNumberOfLinesChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permutateNodes(Function<Integer, Integer> mapping) {
        Object object = this.sync;
        synchronized (object) {
            HashMap<Integer, N> newActiveNodes = new HashMap<Integer, N>();
            HashSet<Integer> changedIndexes = new HashSet<Integer>();
            for (Map.Entry<Integer, N> entry : this.activeNodes.entrySet()) {
                Integer curIndex = entry.getKey();
                Integer newIndex = mapping.apply(entry.getKey());
                if (curIndex.intValue() != newIndex.intValue()) {
                    changedIndexes.add(newIndex);
                }
                newActiveNodes.put(newIndex, (Node)entry.getValue());
            }
            this.activeNodes = newActiveNodes;
            for (Integer index : changedIndexes) {
                if (this.onActivate == null) continue;
                this.onActivate.accept(index, (Node)this.activeNodes.get(index));
            }
        }
    }

    private void onNumberOfLinesChange(Observable x, Number o, Number n) {
        if (n.intValue() > o.intValue()) {
            TreeRangeSet toUpdate = TreeRangeSet.create();
            toUpdate.add(Range.closedOpen((Comparable)Integer.valueOf(o.intValue()), (Comparable)Integer.valueOf(n.intValue())));
            this.triggerUpdate((RangeSet<Integer>)toUpdate);
        } else if (n.intValue() < o.intValue()) {
            TreeRangeSet toRelease = TreeRangeSet.create();
            toRelease.add(Range.closed((Comparable)Integer.valueOf(n.intValue()), (Comparable)Integer.valueOf(o.intValue())));
            this.triggerRelease((RangeSet<Integer>)toRelease);
        }
    }

    private void onVisibleLinesChange(Observable x, Range<Integer> o, Range<Integer> n) {
        TreeRangeSet toUpdate = TreeRangeSet.create();
        TreeRangeSet toRelease = TreeRangeSet.create();
        if (o != null && n != null) {
            TreeRangeSet hidden = TreeRangeSet.create();
            hidden.add(o);
            hidden.remove(n);
            toRelease.addAll((RangeSet)hidden);
        }
        if (n != null) {
            toUpdate.add(this.getVisible());
        }
        this.triggerUpdate((RangeSet<Integer>)toUpdate);
        this.triggerRelease((RangeSet<Integer>)toRelease);
        this.requestLayout();
    }

    private Range<Integer> getVisible() {
        return (Range)this.visibleLines.get();
    }

    private void triggerUpdate(RangeSet<Integer> range) {
        Range all = Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.getNumberOfLines()));
        RangeSet onlyExisting = range.subRangeSet(all);
        RangeSet onlyVisible = onlyExisting.subRangeSet(this.getVisible());
        onlyVisible.asRanges().stream().flatMapToInt(VFlow::toIntStream).forEach(index -> this.updateNode(index));
    }

    private void triggerRelease(RangeSet<Integer> range) {
        if (range.contains((Comparable)Integer.valueOf(Integer.MAX_VALUE)) || range.contains((Comparable)Integer.valueOf(Integer.MIN_VALUE))) {
            return;
        }
        range.asRanges().stream().flatMapToInt(VFlow::toIntStream).forEach(index -> this.releaseNode(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChildren() {
        Object object = this.sync;
        synchronized (object) {
            this.activeNodes.entrySet().forEach(e -> {
                double x = 0.0;
                double y = (double)((Integer)e.getKey()).intValue() * this.getLineHeight() - this.getYOffset();
                double width = this.getWidth();
                double height = this.getLineHeight();
                ((Node)e.getValue()).resizeRelocate(x, y, width, height);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseNode(int lineIndex) {
        Object object = this.sync;
        synchronized (object) {
            Node node = (Node)this.activeNodes.remove(lineIndex);
            if (node != null) {
                node.setVisible(false);
                this.freeNodes.offer(node);
                if (this.onRelease != null) {
                    this.onRelease.accept(node);
                }
            }
        }
    }

    protected void updateNode(int lineIndex) {
        N node = this.getNode(lineIndex);
        node.setVisible(true);
        this.nodePopulator.accept(node, lineIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<N> getVisibleNode(int lineIndex) {
        Object object = this.sync;
        synchronized (object) {
            Node node = (Node)this.activeNodes.get(lineIndex);
            return Optional.ofNullable(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected N getNode(int lineIndex) {
        Object object = this.sync;
        synchronized (object) {
            Node node = (Node)this.activeNodes.remove(lineIndex);
            if (node == null && !this.freeNodes.isEmpty()) {
                node = (Node)this.freeNodes.poll();
            }
            if (node == null) {
                node = (Node)this.nodeFactory.get();
                this.getChildren().add((Object)node);
            }
            if (node != null && this.onActivate != null) {
                this.onActivate.accept(lineIndex, node);
            }
            this.activeNodes.put(lineIndex, node);
            return (N)node;
        }
    }

    static IntStream toIntStream(Range<Integer> range) {
        return ContiguousSet.create(range, (DiscreteDomain)DiscreteDomain.integers()).stream().mapToInt(i -> i);
    }
}

