/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.ui.contentassist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.css.cssDsl.CssDslFactory;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.css_declaration;
import org.eclipse.fx.ide.css.cssDsl.font_face;
import org.eclipse.fx.ide.css.cssDsl.ruleset;
import org.eclipse.fx.ide.css.cssDsl.selector;
import org.eclipse.fx.ide.css.cssDsl.stylesheet;
import org.eclipse.fx.ide.css.extapi.CssExt;
import org.eclipse.fx.ide.css.extapi.Proposal;
import org.eclipse.fx.ide.css.extapi.SimpleProposal;
import org.eclipse.fx.ide.css.ui.contentassist.AbstractCssDslProposalProvider;
import org.eclipse.fx.ide.css.ui.extapi.UIProposal;
import org.eclipse.fx.ide.css.util.Utils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.hover.DispatchingEObjectTextHover;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;

public class CssDslProposalProvider
extends AbstractCssDslProposalProvider {
    @Inject
    private CssExt cssExt;
    @Inject
    private DispatchingEObjectTextHover hoverDispatcher;
    @Inject
    private ILabelProvider labelProvider;
    private static Logger LOGGER = LoggerCreator.createLogger(CssDslProposalProvider.class);

    private void acceptProposals(List<Proposal> proposals, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Proposal p : proposals) {
            ConfigurableCompletionProposal cp;
            Image img = this.labelProvider.getImage((Object)CssDslFactory.eINSTANCE.createcss_property());
            if (p instanceof UIProposal) {
                cp = (ConfigurableCompletionProposal)this.createCompletionProposal(p.getLabel(), p.getLabel(), img, context);
                final UIProposal uiP = (UIProposal)p;
                if (cp == null) continue;
                cp.setTextApplier((ConfigurableCompletionProposal.IReplacementTextApplier)new ReplacementTextApplier(){

                    public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
                        if (uiP.show()) {
                            return uiP.getProposal();
                        }
                        return "";
                    }
                });
                cp.setPriority(p.getPriority());
                acceptor.accept((ICompletionProposal)cp);
                continue;
            }
            cp = (ConfigurableCompletionProposal)this.createCompletionProposal(p.getProposal(), p.getLabel(), img, context);
            if (cp != null) {
                cp.setAdditionalProposalInfo(p.getAdditionalInfo());
                cp.setHover((IEObjectHover)this.hoverDispatcher);
                cp.setTriggerCharacters(new char[]{' '});
                if (p.getType() == Proposal.Type.Property) {
                    cp.setTextApplier(new ConfigurableCompletionProposal.IReplacementTextApplier(){

                        public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
                            document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), String.valueOf(proposal.getReplacementString()) + ": ");
                            proposal.setCursorPosition(proposal.getCursorPosition() + 2);
                        }
                    });
                }
                if (p.getType() == Proposal.Type.Value) {
                    cp.setTextApplier(new ConfigurableCompletionProposal.IReplacementTextApplier(){

                        private int findWSCountBeforeProposal(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
                            int offset = 0;
                            int amount = 10;
                            if (proposal.getReplacementOffset() - amount < 0) {
                                amount = proposal.getReplacementOffset();
                            }
                            String beforeChars = document.get(proposal.getReplacementOffset() - amount, amount);
                            Pattern spaces = Pattern.compile("(.*)[ ]+$");
                            Matcher m = spaces.matcher(beforeChars);
                            if (m.matches()) {
                                offset = amount - m.end(1);
                            }
                            return offset;
                        }

                        public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
                            if (proposal.getReplacementString().equals(";")) {
                                int wsCount = this.findWSCountBeforeProposal(document, proposal);
                                document.replace(proposal.getReplacementOffset() - wsCount, proposal.getReplacementLength() + wsCount, proposal.getReplacementString());
                                proposal.setCursorPosition(proposal.getCursorPosition() - wsCount);
                            } else if (proposal.getReplacementString().equals(",")) {
                                int wsCount = this.findWSCountBeforeProposal(document, proposal);
                                document.replace(proposal.getReplacementOffset() - wsCount, proposal.getReplacementLength() + wsCount, String.valueOf(proposal.getReplacementString()) + " ");
                                proposal.setCursorPosition(proposal.getCursorPosition() + 1 - wsCount);
                            } else {
                                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), String.valueOf(proposal.getReplacementString()) + " ");
                                proposal.setCursorPosition(proposal.getCursorPosition() + 1);
                            }
                        }
                    });
                }
                cp.setPriority(p.getPriority());
                acceptor.accept((ICompletionProposal)cp);
                continue;
            }
            LOGGER.debug("cound not create proposal for " + p);
        }
    }

    private List<CssTok> findPrefixTokens(ContentAssistContext context) {
        ArrayList<CssTok> prefixToks = new ArrayList<CssTok>();
        if (context.getLastCompleteNode().getSemanticElement() instanceof CssTok) {
            CssTok currentTok = (CssTok)context.getLastCompleteNode().getSemanticElement();
            for (CssTok tok : ((css_declaration)context.getLastCompleteNode().getSemanticElement().eContainer()).getValueTokens()) {
                if (tok == currentTok) break;
                prefixToks.add(tok);
            }
            prefixToks.add(currentTok);
        }
        return prefixToks;
    }

    private List<selector> findSelectors(css_declaration decl) {
        if (decl.eContainer() instanceof ruleset) {
            return ((ruleset)decl.eContainer()).getSelectors();
        }
        return Collections.emptyList();
    }

    public void complete_CssTok(css_declaration model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model.eContainer() instanceof font_face) {
            return;
        }
        List proposals = this.cssExt.getValueProposalsForProperty(Utils.getFile((Resource)model.eResource()), (EObject)model, this.findSelectors(model), model.getProperty(), this.findPrefixTokens(context), context.getPrefix());
        this.acceptProposals(proposals, context, acceptor);
    }

    private void filterDuplicates(ruleset model, List<Proposal> proposals) {
        HashSet<String> defined = new HashSet<String>();
        for (css_declaration d : model.getDeclarations()) {
            defined.add(d.getProperty().getName());
        }
        Iterator<Proposal> filterIterator = proposals.iterator();
        while (filterIterator.hasNext()) {
            Proposal curr = filterIterator.next();
            if (!defined.contains(curr.getProposal())) continue;
            filterIterator.remove();
        }
    }

    private static <O extends EObject> void filterDuplicates(O model, Function<O, List<css_declaration>> f, List<Proposal> proposals) {
        HashSet<String> defined = new HashSet<String>();
        for (css_declaration d : f.apply(model)) {
            defined.add(d.getProperty().getName());
        }
        Iterator<Proposal> filterIterator = proposals.iterator();
        while (filterIterator.hasNext()) {
            Proposal curr = filterIterator.next();
            if (!defined.contains(curr.getProposal())) continue;
            filterIterator.remove();
        }
    }

    @Override
    public void completeFont_face_Declarations(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList<Proposal> proposals = new ArrayList<Proposal>();
        proposals.add((Proposal)new FontPropertyProposal("font-family"));
        proposals.add((Proposal)new FontPropertyProposal("src"));
        proposals.add((Proposal)new FontPropertyProposal("font-stretch"));
        proposals.add((Proposal)new FontPropertyProposal("font-style"));
        proposals.add((Proposal)new FontPropertyProposal("font-weight"));
        proposals.add((Proposal)new FontPropertyProposal("unicode-range"));
        CssDslProposalProvider.filterDuplicates((font_face)model, o -> o.getDeclarations(), proposals);
        this.acceptProposals(proposals, context, acceptor);
        super.completeFont_face_Declarations(model, assignment, context, acceptor);
    }

    public void completeRuleset_Declarations(ruleset model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List proposals = this.cssExt.getPropertyProposalsForSelector(Utils.getFile((Resource)model.eResource()), (EObject)model, (List)model.getSelectors());
        this.filterDuplicates(model, proposals);
        this.acceptProposals(proposals, context, acceptor);
    }

    public void completeRuleset_Declarations(stylesheet model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (context.getPreviousModel() instanceof ruleset) {
            ruleset ruleset2 = (ruleset)context.getPreviousModel();
            List proposals = this.cssExt.getPropertyProposalsForSelector(Utils.getFile((Resource)model.eResource()), (EObject)model, (List)ruleset2.getSelectors());
            this.filterDuplicates(ruleset2, proposals);
            this.acceptProposals(proposals, context, acceptor);
        } else {
            List proposals = this.cssExt.getPropertyProposalsForSelector(Utils.getFile((Resource)model.eResource()), (EObject)model, null);
            this.acceptProposals(proposals, context, acceptor);
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
    }

    static class FontPropertyProposal
    extends SimpleProposal {
        public FontPropertyProposal(String proposal) {
            super(proposal);
        }

        public Proposal.Type getType() {
            return Proposal.Type.Property;
        }
    }
}

