/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AuthentificationRequired;
import org.eclipse.egerrit.internal.core.command.EMFTypeAdapterFactory;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommand<T> {
    private static final String JSON_HEADER = "application/json";
    private static final Logger logger = LoggerFactory.getLogger(BaseCommand.class);
    private HttpRequestBase request;
    private GerritRepository server;
    private AuthentificationRequired fAuthIsRequired;
    private final Type fResultType;
    private Object input;
    private HashMap<String, String> parameters = new HashMap(5);
    private String pathFormat;
    private List<NameValuePair> queryParameters = new ArrayList<NameValuePair>(5);

    protected String getPath() throws UnsupportedEncodingException {
        Set<Map.Entry<String, String>> params = this.parameters.entrySet();
        String result = this.pathFormat;
        for (Map.Entry<String, String> entry : params) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected BaseCommand(GerritRepository gerritRepository, AuthentificationRequired authRequired, Class<? extends HttpRequestBase> operationType, Type returnType) {
        this.server = gerritRepository;
        this.fResultType = returnType;
        this.fAuthIsRequired = authRequired;
        this.instantiateRequest(operationType);
    }

    public T call() throws EGerritException {
        this.fillRequest();
        T result = null;
        try {
            logger.debug("Request: " + this.request.getURI().toString());
            ResponseHandler rh = new ResponseHandler<T>(){

                public T handleResponse(HttpResponse response) throws IOException {
                    StatusLine statusLine = response.getStatusLine();
                    logger.debug("Result : " + statusLine.toString());
                    if (statusLine.getStatusCode() >= 300) {
                        if (BaseCommand.this.errorsExpected()) {
                            return null;
                        }
                        throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                    if (statusLine.getStatusCode() == 204) {
                        return null;
                    }
                    HttpEntity entity = response.getEntity();
                    BufferedHttpEntity myEntity = new BufferedHttpEntity(entity);
                    if (entity == null) {
                        throw new ClientProtocolException("Response has no content");
                    }
                    if (!BaseCommand.this.expectsJson()) {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                            myEntity.writeTo((OutputStream)os);
                            return os.toString();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    GsonBuilder builder = new GsonBuilder();
                    builder.registerTypeAdapterFactory((TypeAdapterFactory)new EMFTypeAdapterFactory());
                    Gson gson = builder.create();
                    InputStreamReader reader = new InputStreamReader(myEntity.getContent());
                    return gson.fromJson((Reader)reader, BaseCommand.this.fResultType);
                }
            };
            result = this.postProcessResult(this.server.getHttpClient().execute((HttpUriRequest)this.request, rh));
        }
        catch (ClientProtocolException e) {
            if (!this.handleHttpException(e)) {
                EGerritCorePlugin.logError(String.valueOf(this.server.formatGerritVersion()) + "Transport error occurred " + this.request.getMethod() + ' ' + this.request.getURI().toASCIIString(), e);
                throw new EGerritException("An error occurred while contacting the server. Please see log for details");
            }
        }
        catch (JsonSyntaxException | IOException e) {
            EGerritCorePlugin.logError(String.valueOf(this.server.formatGerritVersion()) + "Transport error occurred " + this.request.getMethod() + ' ' + this.request.getURI().toASCIIString(), e);
            throw new EGerritException("An error occurred while contacting the server. Please see log for details");
        }
        return result;
    }

    private void instantiateRequest(Class<? extends HttpRequestBase> operationType) {
        try {
            this.request = operationType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.debug("Can't create ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private void fillRequest() throws EGerritException {
        this.setRequestURI();
        this.setInput();
        this.setHeaders();
    }

    private void setRequestURI() throws EGerritException {
        if (this.fAuthIsRequired.equals((Object)AuthentificationRequired.YES) && this.server.getServerInfo().isAnonymous()) {
            throw new EGerritException("This command requires an authenticated user but no user information is provided. Command name is " + this.getClass().getName());
        }
        boolean authenticatedURL = true;
        switch (this.fAuthIsRequired) {
            case YES: {
                authenticatedURL = true;
                break;
            }
            case NO: {
                authenticatedURL = false;
                break;
            }
            case DEPENDS: {
                authenticatedURL = !this.server.getServerInfo().isAnonymous();
            }
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(String.valueOf(this.server.getURIBuilder(authenticatedURL).toString()) + this.getPath());
            if (!this.queryParameters.isEmpty()) {
                uriBuilder.addParameters(this.queryParameters);
            }
            this.request.setURI(uriBuilder.build());
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new EGerritException(e);
        }
    }

    private void setInput() {
        if (this.input != null) {
            if (this.request instanceof HttpEntityEnclosingRequestBase) {
                try {
                    StringEntity entity = new StringEntity(new Gson().toJson(this.input));
                    entity.setContentType((Header)new BasicHeader("Content-Type", JSON_HEADER));
                    ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)entity);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                throw new IllegalArgumentException("Input should not be set if the request is not PUT or POST");
            }
        }
    }

    private void setHeaders() {
        Map<String, String> headers = this.getHeaders();
        if (headers == null) {
            return;
        }
        Set<Map.Entry<String, String>> entries = headers.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            this.request.addHeader(entry.getKey(), entry.getValue());
        }
    }

    protected boolean handleHttpException(ClientProtocolException e) throws EGerritException {
        return false;
    }

    protected boolean errorsExpected() {
        return false;
    }

    protected boolean expectsJson() {
        return true;
    }

    protected void setInput(Object input) {
        this.input = input;
    }

    protected T postProcessResult(T result) {
        return result;
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", JSON_HEADER);
        return headers;
    }

    protected void setSegment(String key, String value) {
        this.parameters.put(key, value);
    }

    protected void setSegmentToEncode(String key, String value) {
        try {
            this.parameters.put(key, URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Can't URL encode value: " + value);
            throw new IllegalArgumentException(e);
        }
    }

    protected void addQueryParameter(String key, String value) {
        this.queryParameters.add((NameValuePair)new BasicNameValuePair(key, value));
    }

    protected void setPathFormat(String pathPattern) {
        this.pathFormat = pathPattern;
    }

    protected GerritRepository getRepository() {
        return this.server;
    }
}

